/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.uc.entity.OwnPhoneBook;
import com.coraltele.db.telephony.uc.repository.OwnPhoneBookRepository;
import com.coraltele.db.telephony.uc.specification.OwnPhoneBookSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.CliCommandData;
import com.coraltele.model.InputAction;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.cLIServerCommandLog.service.CLIServerCommandLogService;
import com.coraltele.service.uc.model.OwnPhoneBookFavorite;
import com.coraltele.service.uc.model.OwnPhoneBookModel;
import com.coraltele.service.uc.model.OwnPhoneBookModelBulk;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class OwnPhoneBookService {
    private static final Logger logger = LogManager.getLogger(OwnPhoneBookService.class);
    @Autowired
    OwnPhoneBookRepository ownPhoneBookRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    private CLIServerCommandLogService cLIServerCommandLogService;

    public RequestResponse updateFavorite(OwnPhoneBookFavorite data) {
        RequestResponse returnValue = new RequestResponse();
        Optional ownPhoneBook = this.ownPhoneBookRepository.findById(data.getId());
        if (ownPhoneBook.isPresent()) {
            OwnPhoneBook dataToSave = (OwnPhoneBook)ownPhoneBook.get();
            dataToSave.setFavorite(data.getFavorite());
            this.ownPhoneBookRepository.save((Object)dataToSave);
        }
        return returnValue;
    }

    public RequestResponse create(OwnPhoneBookModel data, Authentication authentication) {
        Optional list = this.extensionsRepository.findByAssignedUserAndExtensionType(authentication.getName(), "phone");
        RequestResponse returnValue = new RequestResponse();
        OwnPhoneBook ownPhoneBook = new OwnPhoneBook();
        ownPhoneBook.setCreatedOn(LocalDateTime.now());
        ownPhoneBook.setExtension(Long.valueOf(Long.parseLong(((Extension)list.get()).getExtension())));
        ownPhoneBook.setIsDisabled(data.getIsDisabled());
        ownPhoneBook.setUuid(UUID.randomUUID().toString());
        ownPhoneBook.setEmailId(data.getEmailId());
        ownPhoneBook.setFaxNumber(data.getFaxNumber());
        ownPhoneBook.setPhoneHome(data.getPhoneHome());
        ownPhoneBook.setPhoneOffice(data.getPhoneOffice());
        ownPhoneBook.setAddressOne(data.getAddressOne());
        ownPhoneBook.setAddressTwo(data.getAddressTwo());
        ownPhoneBook.setDesignation(data.getDesignation());
        ownPhoneBook.setCompany(data.getCompany());
        ownPhoneBook.setFirstName(data.getFirstName());
        ownPhoneBook.setCreatedBy(authentication.getName());
        this.ownPhoneBookRepository.save((Object)ownPhoneBook);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OwnPhoneBook created");
        returnValue.setMessageDetail("created successfully");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse updateBulkOwnPhoneBook(HttpServletRequest request, OwnPhoneBookModelBulk data, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Constants.Error.OK);
        StringBuilder message = new StringBuilder();
        List list = this.extensionsRepository.findByAssignedUser(authentication.getName());
        for (Long row : data.getId()) {
            Optional currentRecord = this.ownPhoneBookRepository.findById(row);
            if (currentRecord.isPresent()) {
                OwnPhoneBook dataToSave = (OwnPhoneBook)currentRecord.get();
                this.saveData(request, dataToSave, authentication);
                if (data.getData().getIsDisabled() != null) {
                    dataToSave.setIsDisabled(data.getData().getIsDisabled());
                }
                if (data.getData().getEmailId() != null) {
                    dataToSave.setEmailId(data.getData().getEmailId());
                }
                if (data.getData().getFaxNumber() != null) {
                    dataToSave.setFaxNumber(data.getData().getFaxNumber());
                }
                if (data.getData().getPhoneHome() != null) {
                    dataToSave.setPhoneHome(data.getData().getPhoneHome());
                }
                if (data.getData().getPhoneOffice() != null) {
                    dataToSave.setPhoneOffice(data.getData().getPhoneOffice());
                }
                if (data.getData().getAddressTwo() != null) {
                    dataToSave.setAddressTwo(data.getData().getAddressTwo());
                }
                if (data.getData().getDesignation() != null) {
                    dataToSave.setDesignation(data.getData().getDesignation());
                }
                if (data.getData().getCompany() != null) {
                    dataToSave.setCompany(data.getData().getCompany());
                }
                if (data.getData().getAddressOne() != null) {
                    dataToSave.setAddressOne(data.getData().getAddressOne());
                }
                if (data.getData().getFirstName() != null) {
                    dataToSave.setFirstName(data.getData().getFirstName());
                }
                dataToSave.setUpdatedBy(authentication.getName());
                dataToSave.setUpdatedOn(LocalDateTime.now());
                dataToSave.setUuid(UUID.randomUUID().toString());
                dataToSave.setExtension(Long.valueOf(Long.parseLong(((Extension)list.get(0)).getExtension())));
                this.ownPhoneBookRepository.save((Object)dataToSave);
                message.append(MessageFormat.format("Data Updated successfully for id {0}.{1}", row, System.lineSeparator()));
                continue;
            }
            message.append(MessageFormat.format("Unable to locate data successfully for id {0}.{1}", row, System.lineSeparator()));
        }
        returnValue.setMessage("Data Processed");
        returnValue.setMessageDetail(message.toString());
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse update(HttpServletRequest request, OwnPhoneBookModel data, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        Optional list = this.extensionsRepository.findByAssignedUserAndExtensionType(authentication.getName(), "phone");
        Optional currentRecord = this.ownPhoneBookRepository.findById(data.getId());
        if (currentRecord.isPresent()) {
            OwnPhoneBook ownPhoneBook = (OwnPhoneBook)currentRecord.get();
            if (data.getIsDisabled() != null) {
                ownPhoneBook.setIsDisabled(data.getIsDisabled());
            }
            if (data.getFirstName() != null) {
                ownPhoneBook.setFirstName(data.getFirstName());
            }
            if (data.getCompany() != null) {
                ownPhoneBook.setCompany(data.getCompany());
            }
            if (data.getDesignation() != null) {
                ownPhoneBook.setDesignation(data.getDesignation());
            }
            if (data.getAddressTwo() != null) {
                ownPhoneBook.setAddressTwo(data.getAddressTwo());
            }
            if (data.getAddressOne() != null) {
                ownPhoneBook.setAddressOne(data.getAddressOne());
            }
            if (data.getPhoneOffice() != null) {
                ownPhoneBook.setPhoneOffice(data.getPhoneOffice());
            }
            if (data.getPhoneHome() != null) {
                ownPhoneBook.setPhoneHome(data.getPhoneHome());
            }
            if (data.getFaxNumber() != null) {
                ownPhoneBook.setFaxNumber(data.getFaxNumber());
            }
            if (data.getEmailId() != null) {
                ownPhoneBook.setEmailId(data.getEmailId());
            }
            ownPhoneBook.setUpdatedBy(authentication.getName());
            ownPhoneBook.setUpdatedOn(LocalDateTime.now());
            ownPhoneBook.setExtension(Long.valueOf(Long.parseLong(((Extension)list.get()).getExtension())));
            ownPhoneBook.setUuid(UUID.randomUUID().toString());
            this.ownPhoneBookRepository.save((Object)ownPhoneBook);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage(" updated successfully");
            returnValue.setMessageDetail("Data updated successfully");
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage(MessageFormat.format("Unable to find the record {0}", data.getId()));
        }
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getList(SearchRequest searchRequestData, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = OwnPhoneBookSpecification.generateFilters((SearchRequest)searchRequestData, (String)authentication.getName());
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.ownPhoneBookRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.ownPhoneBookRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("filtered list");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse delete(InputIdModel dataToDelete) {
        RequestResponse returnValue = new RequestResponse();
        for (Long row : dataToDelete.getId()) {
            this.ownPhoneBookRepository.deleteById((Object)row);
        }
        return returnValue;
    }

    public void saveData(HttpServletRequest request, OwnPhoneBook data, Authentication authentication) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
        ArrayList<InputAction> addValue = new ArrayList<InputAction>();
        CliCommandData cliCommandData = new CliCommandData();
        Map newMap = (Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), Map.class);
        Set entrySet = newMap.entrySet();
        Iterator iterator = entrySet.iterator();
        try {
            if (data.getId() != null && this.ownPhoneBookRepository.findById(data.getId()).isPresent()) {
                Optional oldData = this.ownPhoneBookRepository.findById(data.getId());
                Map oldMap = (Map)objectMapper.convertValue(oldData.get(), Map.class);
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    InputAction inputValue = new InputAction();
                    inputValue.setFieldName(mapEntry.getKey());
                    inputValue.setNewValue(mapEntry.getValue());
                    for (Map.Entry compare : oldMap.entrySet()) {
                        if (!mapEntry.getKey().equals(compare.getKey())) continue;
                        inputValue.setOldValue(compare.getValue());
                    }
                    addValue.add(inputValue);
                }
                cliCommandData.setData(addValue);
                cliCommandData.setEntity("m_ownphonebook");
                String dataReceived = objectMapper.writeValueAsString(addValue);
                CLIServerCommandLog dataLogs = new CLIServerCommandLog();
                dataLogs.setCLICommand(dataReceived);
                dataLogs.setRecordSource("dl");
                dataLogs.setServerCode("");
                dataLogs.setRecordCreatedBy(authentication.getName());
                dataLogs.setRecordCreatedOn(LocalDateTime.now());
                dataLogs.setOutputFileName("Name");
                dataLogs.setOutputFilePath("");
                this.cLIServerCommandLogService.save(dataLogs);
            }
        }
        catch (JsonProcessingException e) {
            logger.error("saveDataError" + (Object)((Object)e));
        }
    }
}

