/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.lastTenCalls.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.coralapps.callcenter.entity.Queue;
import com.coraltele.db.coralapps.callcenter.repository.QueueRepository;
import com.coraltele.db.telemetry.main.entity.view.MissedCallView;
import com.coraltele.db.telemetry.main.repository.MissedCallViewRepository;
import com.coraltele.db.telemetry.main.specification.MissedCallViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.background.PdfGeneratorService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="missedCallPdf")
public class MissedCallPdf
implements PdfGeneratorService {
    private static final Logger logger = LogManager.getLogger(MissedCallPdf.class);
    private static String reportFileName = "Missed Call Report";
    private static String reportFileNameDateFormat = "dd_MMMM_yyyy";
    private static String localDateFormat = "dd-MM-yyyy hh:mm:ss a";
    LocalDateTime currentTime = null;
    private static String logoImgPath = "/var/www/html/apple-icon.png";
    private static int noOfColumns = 0;
    @Autowired
    MissedCallViewRepository missedCallViewRepository;
    @Autowired
    QueueRepository queueRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    @Autowired
    PdfPageNumberEvent pageNumberEvent;
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    public void init(LocalDateTime currentTime) {
        try {
            this.pageNumberEvent.initialize(logoImgPath, reportFileName, localDateFormat, currentTime);
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
    }

    public RequestResponse generatePdfReport(SearchRequest searchRequestData, String filePath, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        this.currentTime = LocalDateTime.now();
        this.init(this.currentTime);
        logger.info("Start generating pdf for matched columns:");
        try {
            noOfColumns = searchRequestData.getColumnNames().size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = noOfColumns > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            writer.setPageEvent((PdfPageEvent)this.pageNumberEvent);
            document.open();
            this.addLogoAndDocTitle(document, searchRequestData, Integer.valueOf(noOfColumns));
            if (searchRequestData.advancedFilters != null && !searchRequestData.advancedFilters.isEmpty()) {
                MissedCallPdf.addAdvanceFilterRequest((Document)document, (SearchRequest)searchRequestData);
            }
            document.newPage();
            this.createTable(document, noOfColumns, searchRequestData, principal);
            document.close();
            byte[] pdfBytes = byteArrayOutputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            String filename = this.getPdfNameWithDate();
            this.savePdfToDestination(pdfBytes, filePath);
            headers.setContentDispositionFormData(filename, filename);
            headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
            logger.info("PDF generated successfully and saved to: {}", (Object)filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("File generated and saved successfully");
            returnValue.setData((Object)filePath);
            logger.info("NMS report generated and saved successfully");
            return returnValue;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("failed to download");
            logger.info("NMS report failed to download");
            return returnValue;
        }
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            logger.info("finding logo from location");
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)logoImgPath);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            }
            PdfPCell reportNameCell = new PdfPCell();
            reportNameCell.setHorizontalAlignment(1);
            reportNameCell.setBorder(0);
            Paragraph p1 = new Paragraph(reportFileName, COURIER);
            reportNameCell.addElement((Element)p1);
            PdfPCell dateTimeCell = new PdfPCell();
            dateTimeCell.setHorizontalAlignment(1);
            dateTimeCell.setBorder(0);
            String localDateString = this.currentTime.format(DateTimeFormatter.ofPattern(localDateFormat));
            Paragraph p2 = new Paragraph("Report generated on " + localDateString, COURIER_SMALL);
            dateTimeCell.addElement((Element)p2);
            table.addCell(logoCell);
            table.addCell(reportNameCell);
            table.addCell(dateTimeCell);
            document.add((Element)table);
            logger.info("successfully found logo for pdf");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void createTable(Document document, int noOfColumns, SearchRequest searchRequestData, Principal principal) throws DocumentException {
        try {
            logger.info("Starting creation of table for pdf");
            Specification filters = MissedCallViewSpecification.generateFilters((SearchRequest)searchRequestData, (Principal)principal);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.missedCallViewRepository.findAll(filters, sort) : this.missedCallViewRepository.findAll(filters);
            PdfPTable table = new PdfPTable(searchRequestData.getColumnNames().size());
            for (String columnName : searchRequestData.getColumnNames()) {
                BaseColor lightBlue = new BaseColor(2, 111, 194);
                PdfPCell cell = new PdfPCell(new Phrase((String)columnMappings.get(columnName), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(lightBlue);
                cell.setBorder(0);
                table.addCell(cell);
            }
            table.setHeaderRows(1);
            this.getDbData(table, filteredData, searchRequestData.getColumnNames());
            document.add((Element)table);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void getDbData(PdfPTable table, List<MissedCallView> filteredData, List<String> columnNames1) {
        try {
            BaseColor lightBackground = new BaseColor(230, 230, 230);
            for (int rowIndex = 0; rowIndex < filteredData.size(); ++rowIndex) {
                MissedCallView missedCallView = filteredData.get(rowIndex);
                table.setWidthPercentage(100.0f);
                table.getDefaultCell().setHorizontalAlignment(1);
                table.getDefaultCell().setVerticalAlignment(5);
                table.getDefaultCell().setBorder(0);
                if (rowIndex % 2 == 0) {
                    table.getDefaultCell().setBackgroundColor(BaseColor.WHITE);
                } else {
                    table.getDefaultCell().setBackgroundColor(lightBackground);
                }
                Iterator<String> iterator = columnNames1.iterator();
                while (iterator.hasNext()) {
                    String columnName;
                    switch (columnName = iterator.next()) {
                        case "agentName": {
                            table.addCell(this.getCellValue(missedCallView.getAgentName()));
                            break;
                        }
                        case "queueName": {
                            table.addCell(this.getCellValue(missedCallView.getQueueName()));
                            break;
                        }
                        case "talkDuration": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)missedCallView.getTalkDuration().longValue())));
                            break;
                        }
                        case "startTime": {
                            if (missedCallView.getStartTime() != null) {
                                table.addCell(this.formatNullableDate(missedCallView.getStartTime()).toString());
                                break;
                            }
                            table.addCell("");
                            break;
                        }
                        case "recordingFile": {
                            table.addCell(this.getCellValue(missedCallView.getRecordingFile()));
                            break;
                        }
                        case "direction": {
                            table.addCell(this.getCellValue(missedCallView.getDirection()));
                            break;
                        }
                        case "agentTalkedTo": {
                            table.addCell(this.getCellValue(missedCallView.getAgentTalkedTo()));
                            break;
                        }
                        case "queue": {
                            table.addCell(this.getCellValue(missedCallView.getQueue()));
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    public String getQueueDescription(Integer queue) {
        Optional data = this.queueRepository.findById(queue);
        if (data.isPresent()) {
            if (((Queue)data.get()).getDescription() == null || ((Queue)data.get()).getDescription().equals("")) {
                return "";
            }
            return ((Queue)data.get()).getDescription();
        }
        return "queue is not present in table";
    }

    private String formatNullableDate(Long epochMillis) {
        return epochMillis != null ? DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)epochMillis)) : "";
    }

    private String getCellValue(String value) {
        return value != null && !value.isEmpty() ? value : "";
    }

    private static void leaveEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    private String getPdfNameWithDate() {
        String localDateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern(reportFileNameDateFormat));
        return reportFileName + "-" + localDateString + ".pdf";
    }

    private static void addAdvanceFilterRequest(Document document, SearchRequest searchRequestData) throws DocumentException {
        List advancedFilters = searchRequestData.getAdvancedFilters();
        if (advancedFilters != null && !advancedFilters.isEmpty()) {
            Paragraph advancedFilterParagraph = new Paragraph();
            Font boldFont = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
            for (AdvanceFilter advanceFilter : advancedFilters) {
                advancedFilterParagraph.setFont(boldFont);
                if ("from".equals(advanceFilter.getDirection())) {
                    advancedFilterParagraph.add("Record on the basis of " + (String)columnMappings.get(advanceFilter.getFieldName()) + ": From " + advanceFilter.getValue());
                    continue;
                }
                if (!"to".equals(advanceFilter.getDirection())) continue;
                advancedFilterParagraph.add(" to " + advanceFilter.getValue());
                advancedFilterParagraph.add((Element)new Paragraph(""));
            }
            document.add((Element)advancedFilterParagraph);
        }
    }

    private void savePdfToDestination(byte[] pdfBytes, String destinationPath) {
        try (FileOutputStream fos = new FileOutputStream(destinationPath);){
            fos.write(pdfBytes);
            logger.info("PDF saved to: {}", (Object)destinationPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Failed to save PDF to: {}", (Object)destinationPath);
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String filePath) {
        try {
            PdfReportFilters pdfReportFilters = new PdfReportFilters();
            ObjectMapper objectMapper = new ObjectMapper();
            pdfReportFilters.setId(id);
            pdfReportFilters.setReportName(reportFileName);
            pdfReportFilters.setFilterParameters(objectMapper.writeValueAsString((Object)data));
            pdfReportFilters.setCreatedOnDate(this.currentTime);
            pdfReportFilters.setPdfLocation(filePath);
            pdfReportFilters.setStatus("InProgress");
            this.pdfReportRepository.save((Object)pdfReportFilters);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    static {
        columnMappings.put("agentName", "Agent Name");
        columnMappings.put("startTime", "Start Stamp");
        columnMappings.put("queueName", "Queue");
        columnMappings.put("talkDuration", "Talk Time");
        columnMappings.put("recordingFile", "Recording File");
        columnMappings.put("direction", "Direction");
        columnMappings.put("agentTalkedTo", "Customer Number");
        columnMappings.put("queue", "Queue");
        columnMappings.put("queueName", "Queue Name");
    }
}

