/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.taskStatus.service;

import com.coraltele.db.telephony.pbx.entity.TaskStatus;
import com.coraltele.db.telephony.pbx.repository.TaskStatusRepository;
import com.coraltele.db.telephony.pbx.specification.TaskStatusSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.taskStatus.model.TaskStatusModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TaskStatusService {
    private static final Logger logger = LogManager.getLogger(TaskStatusService.class);
    @Autowired
    private TaskStatusRepository taskStatusRepository;

    public RequestResponse createTaskStatus(TaskStatusModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Optional optionalTaskStatus = this.taskStatusRepository.findByTaskStatus(data.getTaskStatus());
        if (optionalTaskStatus.isPresent()) {
            returnValue.setMessage("Task status already found with name:: " + data.getTaskStatus());
            returnValue.setStatus(Constants.Error.ERROR);
            return returnValue;
        }
        logger.debug("Creating new task status: {}", (Object)data);
        try {
            TaskStatus taskStatus = new TaskStatus();
            taskStatus.setTaskStatus(data.getTaskStatus());
            taskStatus.setCreatedOn(LocalDateTime.now());
            taskStatus.setCreatedBy(principal.getName());
            this.taskStatusRepository.save((Object)taskStatus);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Task status registered successfully");
            logger.info("Task status saved: {}", (Object)returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create task status");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllTaskStatuses() {
        List list = (List)this.taskStatusRepository.findAll();
        ArrayList<TaskStatusModel> taskStatusModels = new ArrayList<TaskStatusModel>();
        RequestResponse returnValue = new RequestResponse();
        for (TaskStatus taskStatus : list) {
            TaskStatusModel model = new TaskStatusModel();
            model.setId(taskStatus.getId());
            model.setTaskStatus(taskStatus.getTaskStatus());
            model.setCreatedBy(taskStatus.getCreatedBy());
            model.setCreatedOn(taskStatus.getCreatedOn());
            model.setUpdatedBy(taskStatus.getUpdatedBy());
            model.setUpdatedOn(taskStatus.getUpdatedOn());
            taskStatusModels.add(model);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(taskStatusModels);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteTaskStatus(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional task = this.taskStatusRepository.findById((Object)ids);
            if (task.isPresent()) {
                addValue.add(task.get());
                this.taskStatusRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessage("Record Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateTaskStatus(TaskStatusModel data, Principal principal) {
        logger.debug("Updating TaskStatus: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional taskStatusOptional = this.taskStatusRepository.findById((Object)data.getId());
            if (taskStatusOptional.isPresent()) {
                TaskStatus taskStatus = (TaskStatus)taskStatusOptional.get();
                if (data.getTaskStatus() != null) {
                    taskStatus.setTaskStatus(data.getTaskStatus());
                }
                taskStatus.setUpdatedBy(principal.getName());
                taskStatus.setUpdatedOn(LocalDateTime.now());
                this.taskStatusRepository.save((Object)taskStatus);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Task status updated successfully");
                returnValue.setMessageDetail("Task status details updated successfully");
                logger.info("Task status updated successfully: {}", (Object)data.getId());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Task status not found");
                returnValue.setMessageDetail("No task status found with the given ID");
                logger.info("No task status found with ID: {}", (Object)data.getId());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update task status");
            returnValue.setMessageDetail("Please contact the administrator");
            logger.error("Error while updating task status.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getFilterTaskStatus(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = TaskStatusSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.taskStatusRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.taskStatusRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

