/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.taskPriority.service;

import com.coraltele.db.telemetry.main.entity.Severity;
import com.coraltele.db.telemetry.main.repository.SeverityRepository;
import com.coraltele.db.telephony.pbx.entity.TaskPriority;
import com.coraltele.db.telephony.pbx.repository.TaskPriorityRepository;
import com.coraltele.db.telephony.pbx.specification.TaskPrioritySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.taskPriority.model.TaskPriorityModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TaskPriorityService {
    private static final Logger logger = LogManager.getLogger(TaskPriorityService.class);
    @Autowired
    private TaskPriorityRepository taskPriorityRepository;
    @Autowired
    SeverityRepository severityRepository;

    public RequestResponse createTaskPriority(TaskPriorityModel data, Principal principal) {
        logger.debug("Creating new task priority: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            TaskPriority taskPriority = new TaskPriority();
            taskPriority.setTaskPriority(data.getTaskPriority());
            taskPriority.setCreatedBy(principal.getName());
            taskPriority.setCreatedOn(LocalDateTime.now());
            this.taskPriorityRepository.save((Object)taskPriority);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Task priority registered successfully");
            logger.info("Task priority saved: {}", (Object)returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create task priority");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllTaskPriorities() {
        Integer n;
        Integer n2;
        TaskPriorityModel model;
        List taskPriorityList = (List)this.taskPriorityRepository.findAll();
        List severityList = this.severityRepository.findAll();
        ArrayList<TaskPriorityModel> unifiedList = new ArrayList<TaskPriorityModel>();
        RequestResponse returnValue = new RequestResponse();
        Integer serialId = 1;
        for (TaskPriority taskPriority : taskPriorityList) {
            model = new TaskPriorityModel();
            n2 = serialId;
            n = serialId = Integer.valueOf(serialId + 1);
            model.setId(n2);
            model.setTaskPriority(taskPriority.getTaskPriority());
            model.setCreatedBy(taskPriority.getCreatedBy());
            model.setCreatedOn(taskPriority.getCreatedOn());
            model.setUpdatedBy(taskPriority.getUpdatedBy());
            model.setUpdatedOn(taskPriority.getUpdatedOn());
            unifiedList.add(model);
        }
        for (Severity severity : severityList) {
            model = new TaskPriorityModel();
            n2 = serialId;
            n = serialId = Integer.valueOf(serialId + 1);
            model.setId(n2);
            model.setTaskPriority(severity.getSeverityName());
            unifiedList.add(model);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Size of list:" + unifiedList.size());
        returnValue.setData(unifiedList);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteTaskPriority(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional task = this.taskPriorityRepository.findById((Object)ids);
            if (task.isPresent()) {
                addValue.add(task.get());
                this.taskPriorityRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessage("Record Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getFilterTaskPriority(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = TaskPrioritySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.taskPriorityRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.taskPriorityRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateTaskPriority(TaskPriorityModel data, Principal principal) {
        logger.debug("Updating TaskDetails: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional taskDetailsOptional = this.taskPriorityRepository.findById((Object)data.getId());
            if (taskDetailsOptional.isPresent()) {
                TaskPriority taskDetails = (TaskPriority)taskDetailsOptional.get();
                if (data.getTaskPriority() != null) {
                    taskDetails.setTaskPriority(data.getTaskPriority());
                }
                taskDetails.setUpdatedBy(principal.getName());
                taskDetails.setUpdatedOn(LocalDateTime.now());
                this.taskPriorityRepository.save((Object)taskDetails);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated successfully");
                returnValue.setMessageDetail("Task Priority updated successfully");
                logger.info("Task updated successfully: {}", (Object)data.getId());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Task details not found");
                returnValue.setMessageDetail("No task details found with the given ID");
                logger.info("No task Priority found with ID: {}", (Object)data.getId());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update task Priority");
            returnValue.setMessageDetail("Please contact the administrator");
            logger.error("Error while updating task Priority.", (Throwable)e);
        }
        return returnValue;
    }
}

