/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.fileConfiguration.callservermanager.service;

import com.coraltele.db.telephony.pbx.entity.ConferenceMailText;
import com.coraltele.db.telephony.pbx.repository.ConferenceMailTextRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.fileConfiguration.callservermanager.model.CallServerManagerFileModel;
import com.coraltele.service.pbx.fileConfiguration.callservermanager.model.EmailConfigurationFileModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CallServerManagerFileService {
    private static final Logger logger = LogManager.getLogger(CallServerManagerFileService.class);
    private static String callServerManagerPath = "/etc/coraltelecom/callserver.manager.conf";
    @Autowired
    ConferenceMailTextRepository conferenceMailTextRepository;

    public RequestResponse updateCallServerManagerFile(CallServerManagerFileModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            File file = new File(callServerManagerPath);
            Properties prop = new Properties();
            if (file.exists()) {
                FileInputStream input = new FileInputStream(callServerManagerPath);
                prop.load(input);
                input.close();
            }
            prop.setProperty("mail.from", data.getMailFrom());
            prop.setProperty("mail.name", data.getMailName());
            prop.setProperty("mail.password", data.getMailPassword());
            prop.setProperty("mail.port", data.getMailPort());
            prop.setProperty("mail.protocol", data.getMailProtocol());
            prop.setProperty("mail.ttls", String.valueOf(data.isMailTTls()));
            prop.setProperty("mail.username", data.getMailUsername());
            prop.setProperty("mail.server", data.getMailServer());
            prop.setProperty("mail.smtpauth", String.valueOf(data.isMailSmtPAuth()));
            FileOutputStream output = new FileOutputStream(callServerManagerPath);
            prop.store(output, null);
            output.close();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Updated");
            returnValue.setMessageDetail("Data Updated Successfully");
            logger.info("Data Have Been Updated Successfully");
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present At The Server.");
            logger.error("Error while updating data logs", (Throwable)e);
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while Updating Data Into File.");
            returnValue.setMessageDetail("Unable To Update Data Into File");
            logger.error("Error while updating data logs:", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed");
            returnValue.setMessageDetail("Unable To Update Data Into File");
            logger.error("Error while updating data logs", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getCallServerManager() {
        ArrayList<CallServerManagerFileModel> addValue = new ArrayList<CallServerManagerFileModel>();
        CallServerManagerFileModel returnData = new CallServerManagerFileModel();
        RequestResponse returnValue = new RequestResponse();
        FileInputStream input = null;
        Properties prop = new Properties();
        try {
            input = new FileInputStream(callServerManagerPath);
            prop.load(input);
            returnData.setId(1);
            returnData.setMailFrom(prop.getProperty("mail.from"));
            returnData.setMailName(prop.getProperty("mail.name"));
            returnData.setMailPassword(prop.getProperty("mail.password"));
            returnData.setMailPort(prop.getProperty("mail.port"));
            returnData.setMailProtocol(prop.getProperty("mail.protocol"));
            returnData.setMailTTls((prop.getProperty("mail.ttls").equals("null") ? null : Boolean.valueOf(prop.getProperty("mail.ttls"))).booleanValue());
            returnData.setMailUsername(prop.getProperty("mail.username"));
            returnData.setMailServer(prop.getProperty("mail.server"));
            returnData.setMailSmtPAuth((prop.getProperty("mail.smtpauth").equals("null") ? null : Boolean.valueOf(prop.getProperty("mail.smtpauth"))).booleanValue());
            addValue.add(returnData);
            ((InputStream)input).close();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Retrieved ");
            returnValue.setMessageDetail("Data Retrieved Successfully");
            returnValue.setData(addValue);
            logger.info("Data stored successfully");
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("File Not Found");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable To Retrieve Data From File");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllEmailConfiguration(String search) {
        ArrayList<EmailConfigurationFileModel> addValue = new ArrayList<EmailConfigurationFileModel>();
        EmailConfigurationFileModel returnData = new EmailConfigurationFileModel();
        Optional type = this.conferenceMailTextRepository.findByType(search);
        RequestResponse returnValue = new RequestResponse();
        FileInputStream input = null;
        Properties prop = new Properties();
        try {
            if (!type.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Not Found");
                returnValue.setMessageDetail("Type Not Found");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            input = new FileInputStream(callServerManagerPath);
            prop.load(input);
            returnData.setMailFrom(prop.getProperty("mail.from"));
            returnData.setMailName(prop.getProperty("mail.name"));
            returnData.setMailPassword(prop.getProperty("mail.password"));
            returnData.setMailPort(prop.getProperty("mail.port"));
            returnData.setMailProtocol(prop.getProperty("mail.protocol"));
            returnData.setMailTTls((prop.getProperty("mail.ttls").equals("null") ? null : Boolean.valueOf(prop.getProperty("mail.ttls"))).booleanValue());
            returnData.setMailUsername(prop.getProperty("mail.username"));
            returnData.setMailServer(prop.getProperty("mail.server"));
            returnData.setMailSmtPAuth((prop.getProperty("mail.smtpauth").equals("null") ? null : Boolean.valueOf(prop.getProperty("mail.smtpauth"))).booleanValue());
            returnData.setCreatedBy(((ConferenceMailText)type.get()).getCreatedBy());
            returnData.setCreatedOn(((ConferenceMailText)type.get()).getCreatedOn());
            returnData.setEmailBody(((ConferenceMailText)type.get()).getEmailBody());
            returnData.setSmsBody(((ConferenceMailText)type.get()).getSmsBody());
            returnData.setSubject(((ConferenceMailText)type.get()).getSubject());
            returnData.setEmailGreeting(((ConferenceMailText)type.get()).getEmailGreeting());
            returnData.setEmailSignature(((ConferenceMailText)type.get()).getEmailSignature());
            returnData.setId(((ConferenceMailText)type.get()).getId());
            returnData.setType(((ConferenceMailText)type.get()).getType());
            addValue.add(returnData);
            ((InputStream)input).close();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Retrieved ");
            returnValue.setMessageDetail("Data Retrieved Successfully");
            returnValue.setData(addValue);
            logger.info("Data stored successfully");
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("File Not Found");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable To Retrieve Data From File");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        return returnValue;
    }
}

