/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.extension.service;

import com.coraltele.db.coralapps.callcenter.repository.QueueRepository;
import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.entity.Tiers;
import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.db.coralapps.main.repository.TiersRepository;
import com.coraltele.db.telephony.pbx.entity.DidMapping;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.view.DirectoryList;
import com.coraltele.db.telephony.pbx.entity.view.ExtensionRegistrationView;
import com.coraltele.db.telephony.pbx.entity.view.SwitchACDView;
import com.coraltele.db.telephony.pbx.repository.DidMappingRepository;
import com.coraltele.db.telephony.pbx.repository.DirectoryListRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionRegistrationRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.SwitchACDViewRepository;
import com.coraltele.db.telephony.pbx.specification.CodeBlueNewSpecification;
import com.coraltele.db.telephony.pbx.specification.ExtensionRegistrationSpecification;
import com.coraltele.db.telephony.pbx.specification.SwitchACDViewSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.main.model.TiersModel;
import com.coraltele.service.pbx.extension.model.CodeBlueModelCreate;
import com.coraltele.service.pbx.extension.model.DirectoryListModel;
import com.coraltele.service.pbx.extension.model.ExtensionRegistrationModel;
import com.coraltele.service.pbx.extension.model.SwitchAcdExtensionCreate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class ExtensionRegistrationService {
    private static final Logger logger = LogManager.getLogger(ExtensionRegistrationService.class);
    @Autowired
    ExtensionRegistrationRepository repository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    DidMappingRepository didMappingRepository;
    @Autowired
    SwitchACDViewRepository switchACDViewRepository;
    @Autowired
    QueueRepository queueRepository;
    @Autowired
    TiersRepository tiersRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    private AgentRepository agentRepository;
    @Autowired
    DirectoryListRepository directoryListRepository;

    public RequestResponse getAllRecords() {
        RequestResponse response = new RequestResponse();
        List data = this.repository.findAll();
        ArrayList<ExtensionRegistrationModel> addValues = new ArrayList<ExtensionRegistrationModel>();
        if (data != null && !data.isEmpty()) {
            logger.info("fetch extension registration list...");
            for (ExtensionRegistrationView row : data) {
                ExtensionRegistrationModel model = new ExtensionRegistrationModel();
                model.setExtension(row.getExtension());
                model.setContact(row.getContact());
                model.setExtensionType(row.getExtensionType());
                model.setRegistration(row.getRegistration());
                model.setRluCode(row.getRluCode());
                String contact = row.getContact();
                if (contact != null && !contact.isEmpty()) {
                    String[] contactParts = contact.split("@|:");
                    if (contactParts.length >= 4) {
                        String ip = contactParts[2];
                        String portPart = contactParts[3];
                        int semicolonIndex = portPart.indexOf(59);
                        int endIndex = semicolonIndex != -1 ? semicolonIndex : portPart.length();
                        String portNumber = portPart.substring(0, endIndex);
                        model.setIp(ip);
                        model.setPortNumber(portNumber);
                    } else {
                        model.setIp("");
                        model.setPortNumber("");
                    }
                } else {
                    model.setIp("");
                    model.setPortNumber("");
                }
                addValues.add(model);
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("list of extension");
            response.setData(addValues);
            logger.info("list return successfully");
        } else {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Empty list of extension!");
        }
        return response;
    }

    public RequestResponse getFilteredList(SearchRequest searchRequest) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionRegistrationSpecification.generateFilters((SearchRequest)searchRequest);
        Sort sort = null;
        if (searchRequest.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequest.getSortBy()}).ascending();
        } else if (searchRequest.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequest.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.repository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()))) : this.repository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequest.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequest.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("node-cluster list rendered successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createDataForCodeBlueManager(CodeBlueModelCreate data) {
        logger.debug("create new code blue: {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional ext = this.extensionsRepository.findByExtension(data.getExtension());
            if (ext.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Code Blue is already present");
                returnValue.setMessageDetail("Please enter different Code Blue");
                return returnValue;
            }
            Extension extension = new Extension();
            extension.setExtension(data.getExtension());
            extension.setExtensionType("codeblue");
            extension.setData(data.getData());
            if (data.getIsSent() != null) {
                extension.setIsSent(data.getIsSent());
            } else {
                extension.setIsSent(Boolean.valueOf(false));
            }
            if (data.getNoAnsSmsTry() != null) {
                extension.setNoAnsSmsTry(data.getNoAnsSmsTry());
            } else {
                extension.setNoAnsSmsTry(Integer.valueOf(0));
            }
            extension.setWavFilename(data.getWavFilename());
            extension.setConfirmationWavFile(data.getConfirmationWavFile());
            extension.setDialNumber(data.getDialNumber());
            extension.setNoOfRetry(data.getNoOfRetry());
            extension.setNoAnsSmsTry(data.getNoAnsSmsTry());
            extension.setRetryIntervalInMs(data.getRetryIntervalInMs());
            if (data.getCodeBlueSentSmsConfig().equalsIgnoreCase("Disable")) {
                extension.setCodeBlueSentSmsConfig(Integer.valueOf(0));
            } else if (data.getCodeBlueSentSmsConfig().equalsIgnoreCase("Always")) {
                extension.setCodeBlueSentSmsConfig(Integer.valueOf(1));
            } else {
                extension.setCodeBlueSentSmsConfig(Integer.valueOf(2));
            }
            extension.setSmsText(data.getSmsText());
            extension.setSmsNumber(data.getSmsNumber());
            extension.setRetryVoiceMessage(data.getRetryVoiceMessage());
            extension.setConfigEmailId(data.getConfigEmailId());
            if (data.getRecord() != null) {
                extension.setRecord(data.getRecord());
            } else {
                extension.setRecord(Boolean.valueOf(false));
            }
            extension.setUrl(data.getUrl());
            this.extensionsRepository.save((Object)extension);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Code Blue Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Code Blue");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateDataForCodeBlueManager(CodeBlueModelCreate data) {
        logger.debug("create new code blue: {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional ext = this.extensionsRepository.findByExtension(data.getExtension());
            if (!ext.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Code Blue Extension not found with extension " + data.getExtension());
                returnValue.setMessageDetail("Please enter different Code Blue");
                return returnValue;
            }
            Extension extension = (Extension)ext.get();
            extension.setData(data.getData());
            extension.setWavFilename(data.getWavFilename());
            extension.setConfirmationWavFile(data.getConfirmationWavFile());
            extension.setDialNumber(data.getDialNumber());
            extension.setNoOfRetry(data.getNoOfRetry());
            extension.setNoAnsSmsTry(data.getNoAnsSmsTry());
            extension.setRetryIntervalInMs(data.getRetryIntervalInMs());
            if (data.getCodeBlueSentSmsConfig() != null && data.getCodeBlueSentSmsConfig().equalsIgnoreCase("Disable")) {
                extension.setCodeBlueSentSmsConfig(Integer.valueOf(0));
            } else if (data.getCodeBlueSentSmsConfig() != null && data.getCodeBlueSentSmsConfig().equalsIgnoreCase("Always")) {
                extension.setCodeBlueSentSmsConfig(Integer.valueOf(1));
            } else {
                extension.setCodeBlueSentSmsConfig(Integer.valueOf(2));
            }
            extension.setSmsText(data.getSmsText());
            extension.setSmsNumber(data.getSmsNumber());
            extension.setRetryVoiceMessage(data.getRetryVoiceMessage());
            extension.setConfigEmailId(data.getConfigEmailId());
            if (data.getRecord() != null) {
                extension.setRecord(data.getRecord());
            } else {
                extension.setRecord(Boolean.valueOf(false));
            }
            extension.setUrl(data.getUrl());
            this.extensionsRepository.save((Object)extension);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Code blue Extension Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to update Code blue extension");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getCodeBlue(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CodeBlueNewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.extensionsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.extensionsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion1(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<CodeBlueModelCreate> entityToModelConversion1(List<Extension> list) {
        ArrayList<CodeBlueModelCreate> addValue = new ArrayList<CodeBlueModelCreate>();
        for (Extension data : list) {
            if (data == null) continue;
            CodeBlueModelCreate extension = new CodeBlueModelCreate();
            extension.setId(data.getId() != null ? data.getId() : null);
            extension.setData(data.getData() != null ? data.getData() : null);
            extension.setExtension(data.getExtension() != null ? data.getExtension() : null);
            extension.setExtensionType(data.getExtensionType() != null ? data.getExtensionType() : null);
            extension.setWavFilename(data.getWavFilename() != null ? data.getWavFilename() : null);
            extension.setDialNumber(data.getDialNumber() != null ? data.getDialNumber() : null);
            extension.setSmsText(data.getSmsText() != null ? data.getSmsText() : null);
            extension.setSmsNumber(data.getSmsNumber() != null ? data.getSmsNumber() : null);
            extension.setIsSent(data.getIsSent() != null ? data.getIsSent() : null);
            extension.setUrl(data.getUrl() != null ? data.getUrl() : null);
            extension.setNoOfRetry(data.getNoOfRetry() != null ? data.getNoOfRetry() : null);
            extension.setRetryIntervalInMs(data.getRetryIntervalInMs() != null ? data.getRetryIntervalInMs() : null);
            if (data.getCodeBlueSentSmsConfig() != null && data.getCodeBlueSentSmsConfig() == 0) {
                extension.setCodeBlueSentSmsConfig("Disable");
            } else if (data.getCodeBlueSentSmsConfig() != null && data.getCodeBlueSentSmsConfig() == 1) {
                extension.setCodeBlueSentSmsConfig("Always");
            } else {
                extension.setCodeBlueSentSmsConfig("No Answer");
            }
            extension.setConfirmationWavFile(data.getConfirmationWavFile() != null ? data.getConfirmationWavFile() : null);
            extension.setRecord(data.getRecord() != null ? data.getRecord() : null);
            extension.setRetryVoiceMessage(data.getRetryVoiceMessage() != null ? data.getRetryVoiceMessage() : null);
            extension.setNoAnsSmsTry(data.getNoAnsSmsTry() != null ? data.getNoAnsSmsTry() : null);
            extension.setConfigEmailId(data.getConfigEmailId() != null ? data.getConfigEmailId() : null);
            addValue.add(extension);
        }
        return addValue;
    }

    public RequestResponse createDataForSwitchACD(SwitchAcdExtensionCreate data) {
        logger.debug("create new switch acd: {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional ext = this.extensionsRepository.findByExtension(data.getExtension());
            if (ext.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Extension is already present");
                returnValue.setMessageDetail("Please enter different Extension");
                return returnValue;
            }
            List extensionList = this.extensionsRepository.findByData(data.getData());
            if (!extensionList.isEmpty()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Extension " + ((Extension)extensionList.get(0)).getExtension() + " already exists with Queue");
                return returnValue;
            }
            Extension extension = new Extension();
            extension.setExtension(data.getExtension());
            extension.setExtensionType("switchacd");
            extension.setData(data.getData());
            extension.setStrategy(data.getStrategy());
            this.extensionsRepository.save((Object)extension);
            DidMapping didMapping = new DidMapping();
            didMapping.setExtNumber(data.getExtension());
            this.didMappingRepository.save((Object)didMapping);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Switch ACD Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Switch ACD");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateDataForSwitchACD(SwitchAcdExtensionCreate data) {
        logger.debug("update switch ACD : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional extension = this.extensionsRepository.findByExtension(data.getExtension());
            Optional didMapping = this.didMappingRepository.findByExtNumber(data.getExtension());
            if (!extension.isPresent() && !didMapping.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Record not found");
                return returnValue;
            }
            List existingDataExtensions = this.extensionsRepository.findByData(data.getData());
            for (Extension e : existingDataExtensions) {
                if (e.getExtension().equals(((Extension)extension.get()).getExtension())) continue;
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Extension " + e.getExtension() + " already exists with Queue");
                return returnValue;
            }
            ((Extension)extension.get()).setData(data.getData());
            ((Extension)extension.get()).setStrategy(data.getStrategy());
            ((Extension)extension.get()).setDSun(Integer.valueOf(Boolean.TRUE.equals(data.getIsSun()) ? 1 : 0));
            ((Extension)extension.get()).setDMon(Integer.valueOf(Boolean.TRUE.equals(data.getIsMon()) ? 2 : 0));
            ((Extension)extension.get()).setDTue(Integer.valueOf(Boolean.TRUE.equals(data.getIsTue()) ? 3 : 0));
            ((Extension)extension.get()).setDWed(Integer.valueOf(Boolean.TRUE.equals(data.getIsWed()) ? 4 : 0));
            ((Extension)extension.get()).setDThu(Integer.valueOf(Boolean.TRUE.equals(data.getIsThu()) ? 5 : 0));
            ((Extension)extension.get()).setDFri(Integer.valueOf(Boolean.TRUE.equals(data.getIsFri()) ? 6 : 0));
            ((Extension)extension.get()).setDSat(Integer.valueOf(Boolean.TRUE.equals(data.getIsSat()) ? 7 : 0));
            ((Extension)extension.get()).setChimePath(data.getChimePath());
            ((Extension)extension.get()).setChimeInterval(data.getChimeInterval());
            if (data.getIsExtensionBasedAcd() != null) {
                ((Extension)extension.get()).setIsExtensionBasedAcd(data.getIsExtensionBasedAcd());
            } else {
                ((Extension)extension.get()).setIsExtensionBasedAcd(Boolean.valueOf(false));
            }
            ((Extension)extension.get()).setFromTime(DateFormatUtility.stringToLocalTime((String)data.getFromTime()));
            ((Extension)extension.get()).setDayInboundCos(data.getDayInboundCos());
            ((Extension)extension.get()).setNightInboundCos(data.getNightInboundCos());
            ((Extension)extension.get()).setDayOutboundCos(data.getDayOutboundCos());
            ((Extension)extension.get()).setNightOutboundCos(data.getNightOutboundCos());
            ((Extension)extension.get()).setNonworkingApp(data.getNonworkingApp());
            ((Extension)extension.get()).setNonworkingData(data.getNonworkingData());
            ((Extension)extension.get()).setOverrideMoh(data.getOverrideMoh());
            ((Extension)extension.get()).setFailOver(data.getFailOver());
            ((Extension)extension.get()).setRingTime(data.getRingTime());
            ((Extension)extension.get()).setToTime(DateFormatUtility.stringToLocalTime((String)data.getToTime()));
            ((Extension)extension.get()).setAutoLift(Boolean.valueOf(Boolean.TRUE.equals(data.getAutoLift())));
            ((Extension)extension.get()).setTimezone(data.getTimezone());
            ((DidMapping)didMapping.get()).setDidNumber(data.getDidNumber());
            this.extensionsRepository.save(extension.get());
            this.didMappingRepository.save(didMapping.get());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Switch ACD Updated Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Update");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllByFilterForSwitchACD(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = SwitchACDViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.switchACDViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.switchACDViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionForSwitchACD(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<SwitchAcdExtensionCreate> entityToModelConversionForSwitchACD(List<SwitchACDView> actionCodeList) {
        ArrayList<SwitchAcdExtensionCreate> addValue = new ArrayList<SwitchAcdExtensionCreate>();
        for (SwitchACDView row : actionCodeList) {
            SwitchAcdExtensionCreate data = new SwitchAcdExtensionCreate();
            data.setExtension(row.getExtension());
            if (row.getDSun() != null && row.getDSun() != 0) {
                data.setIsSun(Boolean.valueOf(true));
            } else {
                data.setIsSun(Boolean.valueOf(false));
            }
            if (row.getDMon() != null && row.getDMon() != 0) {
                data.setIsMon(Boolean.valueOf(true));
            } else {
                data.setIsMon(Boolean.valueOf(false));
            }
            if (row.getDTue() != null && row.getDTue() != 0) {
                data.setIsTue(Boolean.valueOf(true));
            } else {
                data.setIsTue(Boolean.valueOf(false));
            }
            if (row.getDWed() != null && row.getDWed() != 0) {
                data.setIsWed(Boolean.valueOf(true));
            } else {
                data.setIsWed(Boolean.valueOf(false));
            }
            if (row.getDThu() != null && row.getDThu() != 0) {
                data.setIsThu(Boolean.valueOf(true));
            } else {
                data.setIsThu(Boolean.valueOf(false));
            }
            if (row.getDFri() != null && row.getDFri() != 0) {
                data.setIsFri(Boolean.valueOf(true));
            } else {
                data.setIsFri(Boolean.valueOf(false));
            }
            if (row.getDSat() != null && row.getDSat() != 0) {
                data.setIsSat(Boolean.valueOf(true));
            } else {
                data.setIsSat(Boolean.valueOf(false));
            }
            data.setFromTime(DateFormatUtility.localTimeToString((LocalTime)row.getFromTime()));
            data.setToTime(DateFormatUtility.localTimeToString((LocalTime)row.getToTime()));
            data.setTimezone(row.getTimezone());
            data.setNonworkingApp(row.getNonworkingApp());
            data.setNonworkingData(row.getNonworkingData());
            data.setDayInboundCos(row.getDayInboundCos());
            data.setNightInboundCos(row.getNightInboundCos());
            data.setDayOutboundCos(row.getDayOutboundCos());
            data.setNightOutboundCos(row.getNightOutboundCos());
            data.setOverrideMoh(row.getOverrideMoh());
            data.setChimePath(row.getChimePath());
            data.setChimeInterval(row.getChimeInterval());
            data.setAutoLift(row.getAutoLift());
            data.setDidNumber(row.getDidNumber());
            data.setFailOver(row.getFailOver());
            data.setIsExtensionBasedAcd(row.getIsExtensionBasedAcd());
            data.setRingTime(row.getRingTime());
            data.setStrategy(row.getStrategy());
            data.setData(row.getData());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse associatedQueueWithAgent(String queue) {
        logger.debug("queue: {} ", (Object)queue);
        RequestResponse returnValue = new RequestResponse();
        ArrayList<TiersModel> addValue = new ArrayList<TiersModel>();
        List tiers = this.tiersRepository.findByQueue(queue);
        Set validExtensions = this.extensionsRepository.findAll().stream().map(Extension::getExtension).collect(Collectors.toSet());
        for (Tiers row : tiers) {
            Optional extensionOptional;
            if (!validExtensions.contains(row.getAgent())) continue;
            TiersModel data = new TiersModel();
            data.setId(row.getId());
            data.setAgent(row.getAgent());
            Optional agentOptional = this.agentRepository.findByName(row.getAgent());
            if (agentOptional.isPresent()) {
                data.setContact(((Agent)agentOptional.get()).getContact());
            }
            if ((extensionOptional = this.extensionsRepository.findByExtension(row.getAgent())).isPresent()) {
                data.setRecord(((Extension)extensionOptional.get()).getRecord());
            }
            data.setLevel(row.getLevel());
            data.setQueue(row.getQueue());
            data.setPosition(row.getPosition());
            addValue.add(data);
        }
        returnValue.setData(addValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse nonAssociatedQueueWithoutAgent(String queue) {
        logger.debug("queue: {} ", (Object)queue);
        RequestResponse returnValue = new RequestResponse();
        ArrayList<TiersModel> addValue = new ArrayList<TiersModel>();
        List extensions = this.extensionsRepository.findByExtensionType("phone");
        List tiersList = this.tiersRepository.findAll();
        if (!extensions.isEmpty()) {
            for (Extension ext : extensions) {
                List user;
                boolean found = false;
                for (Tiers tiers : tiersList) {
                    if (tiers.getQueue() == null || tiers.getQueue().equalsIgnoreCase(queue) || !tiers.getQueue().equalsIgnoreCase(ext.getData())) continue;
                    found = true;
                    break;
                }
                if (found || (user = this.userRepository.findByContactNo(ext.getExtension())).isEmpty()) continue;
                TiersModel data = new TiersModel();
                data.setAgent(((User)user.get(0)).getUsername());
                addValue.add(data);
            }
        }
        returnValue.setData(addValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK " + addValue.size());
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse associatedToNonAssociatedQueueWithAgent(@RequestBody InputIdModel data) {
        logger.debug("id: {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer row : data.getIntId()) {
            Optional tiers = this.tiersRepository.findById(row);
            ((Tiers)tiers.get()).setQueue("");
            this.tiersRepository.save(tiers.get());
        }
        returnValue.setData(addValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getLDAP() {
        List list = (List)this.directoryListRepository.findAll();
        ArrayList<DirectoryListModel> addValue = new ArrayList<DirectoryListModel>();
        RequestResponse returnValue = new RequestResponse();
        for (DirectoryList row : list) {
            DirectoryListModel data = new DirectoryListModel();
            data.setContactName(row.getContactName());
            data.setContactNo(row.getContactNo());
            data.setEmailId(row.getEmailId());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

