/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.campaign.service;

import com.coraltele.db.coralapps.callcenter.entity.Campaign;
import com.coraltele.db.coralapps.callcenter.repository.CampaignRepository;
import com.coraltele.db.coralapps.callcenter.repository.QueueRepository;
import com.coraltele.db.coralapps.callcenter.specification.CampaignSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.campaign.model.CampaignModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CampaignService {
    private static final Logger logger = LogManager.getLogger(CampaignService.class);
    @Autowired
    CampaignRepository campaignRepository;
    @Autowired
    QueueRepository queueRepository;
    @Autowired
    UserRepository userRepository;

    public RequestResponse getAllCampaignByFilterForCampaignAgainstQueue(SearchRequest searchRequestData, Long queue) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CampaignSpecification.generateFilters((SearchRequest)searchRequestData, (Long)queue);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.campaignRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.campaignRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.getAll(page.getContent(), queue));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<CampaignModel> getAll(List<Campaign> campaignList, Long queue) {
        Optional queueId = this.queueRepository.findById(Integer.valueOf(queue.intValue()));
        ArrayList<CampaignModel> addValue = new ArrayList<CampaignModel>();
        for (Campaign campaign : campaignList) {
            if (!queueId.isPresent()) continue;
            CampaignModel data = new CampaignModel();
            data.setId(campaign.getId());
            data.setAutoAttendantId(campaign.getAutoAttendantId());
            data.setBusyCause(campaign.getBusyCause());
            data.setBusyInterval(campaign.getBusyInterval());
            data.setCallLoad(campaign.getCallLoad());
            data.setCampaignType(campaign.getCampaignType());
            data.setCopiedFrom(campaign.getCopiedFrom());
            data.setDescription(campaign.getDescription());
            data.setFromDate(campaign.getFromDate());
            data.setFromTime(campaign.getFromTime());
            data.setGatewayId(campaign.getGatewayId());
            data.setHoldingTime(campaign.getHoldingTime());
            data.setIsDisabled(campaign.getIsDisabled());
            data.setLastDialOut(campaign.getLastDialOut());
            data.setLastdailOut(campaign.getLastdailOut());
            data.setNoAnswerCause(campaign.getNoAnswerCause());
            data.setNotReachableCause(campaign.getNotReachableCause());
            data.setNotReachableInterval(campaign.getNotReachableInterval());
            data.setNoAnswerInterval(campaign.getNoAnswerInterval());
            data.setNotificationLevel1(campaign.getNotificationLevel1());
            data.setNotificationLevel2(campaign.getNotificationLevel2());
            data.setNotificationLevel3(campaign.getNotificationLevel3());
            data.setPromoSmsText(campaign.getPromoSmsText());
            data.setQueue(campaign.getQueue());
            data.setScriptPath(data.getScriptPath());
            data.setShortCode(campaign.getShortCode());
            data.setThirdPartyUrl(data.getThirdPartyUrl());
            data.setToDate(campaign.getToDate());
            data.setToTime(campaign.getToTime());
            data.setTotalTry(campaign.getTotalTry());
            data.setDescription(campaign.getDescription());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse createData(CampaignModel data, Principal principal) {
        logger.debug("create new Campaign : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional user = this.userRepository.findByUsername(principal.getName());
        try {
            Campaign campaign = new Campaign();
            if (data.getQueue() == null) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Queue is not selected");
                returnValue.setMessageDetail("Please Select the Queue");
                logger.info(returnValue.getMessage());
            } else {
                Optional description = this.campaignRepository.findByDescription(data.getDescription());
                if (description.isPresent()) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Campaign is Already Present");
                    returnValue.setMessageDetail("Please Enter Different Campaign Name");
                    logger.info(returnValue.getMessage());
                } else {
                    campaign.setAutoAttendantId(data.getAutoAttendantId());
                    campaign.setBusyCause(data.getBusyCause());
                    campaign.setBusyInterval(Integer.valueOf(data.getBusyInterval() != null ? data.getBusyInterval() : 0));
                    campaign.setCallLoad(data.getCallLoad());
                    campaign.setCampaignType(data.getCampaignType());
                    campaign.setCopiedFrom(Integer.valueOf(data.getCopiedFrom() != null ? data.getCopiedFrom() : 0));
                    campaign.setCreatedBy(Long.valueOf(((User)user.get()).getId().intValue()));
                    campaign.setCreatedOn(LocalDateTime.now());
                    campaign.setDescription(data.getDescription());
                    campaign.setFromDate(data.getFromDate());
                    campaign.setFromTime(data.getFromTime());
                    campaign.setGatewayId(data.getGatewayId());
                    campaign.setHoldingTime(Integer.valueOf(data.getHoldingTime() != null ? data.getHoldingTime() : 0));
                    campaign.setIsDisabled(Boolean.valueOf(data.getIsDisabled() != null ? data.getIsDisabled() : false));
                    campaign.setLastDialOut(data.getLastDialOut());
                    campaign.setLastdailOut(data.getLastdailOut());
                    campaign.setNoAnswerCause(data.getNoAnswerCause());
                    campaign.setNoAnswerInterval(Integer.valueOf(data.getNoAnswerInterval() != null ? data.getNoAnswerInterval() : 0));
                    campaign.setNotReachableCause(data.getNotReachableCause());
                    campaign.setNotReachableInterval(Integer.valueOf(data.getNotReachableInterval() != null ? data.getNotReachableInterval() : 0));
                    campaign.setNotificationLevel1(data.getNotificationLevel1());
                    campaign.setNotificationLevel2(data.getNotificationLevel2());
                    campaign.setNotificationLevel3(data.getNotificationLevel3());
                    campaign.setPromoSmsText(data.getPromoSmsText());
                    campaign.setQueue(data.getQueue());
                    campaign.setScriptPath(data.getScriptPath());
                    campaign.setShortCode(data.getShortCode());
                    campaign.setThirdPartyUrl(data.getThirdPartyUrl());
                    campaign.setToDate(data.getToDate());
                    campaign.setToTime(data.getToTime());
                    campaign.setTotalTry(data.getTotalTry());
                    this.campaignRepository.save((Object)campaign);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("OK");
                    returnValue.setMessageDetail("Campaign Created Successfully");
                    logger.info(returnValue.getMessage());
                }
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Campaign");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(CampaignModel data) {
        logger.debug("Update Campaign {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional campaign = this.campaignRepository.findById(data.getId());
        if (!campaign.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Campaign Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getAutoAttendantId() != null) {
            ((Campaign)campaign.get()).setAutoAttendantId(data.getAutoAttendantId());
        }
        if (data.getBusyCause() != null) {
            ((Campaign)campaign.get()).setBusyCause(data.getBusyCause());
        }
        if (data.getBusyInterval() != null) {
            ((Campaign)campaign.get()).setBusyInterval(data.getBusyInterval());
        }
        if (data.getCallLoad() != null) {
            ((Campaign)campaign.get()).setCallLoad(data.getCallLoad());
        }
        if (data.getCampaignType() != null) {
            ((Campaign)campaign.get()).setCampaignType(data.getCampaignType());
        }
        if (data.getCopiedFrom() != null) {
            ((Campaign)campaign.get()).setCopiedFrom(data.getCopiedFrom());
        }
        if (data.getDescription() != null) {
            ((Campaign)campaign.get()).setDescription(data.getDescription());
        }
        if (data.getFromDate() != null) {
            ((Campaign)campaign.get()).setFromDate(data.getFromDate());
        }
        if (data.getFromTime() != null) {
            ((Campaign)campaign.get()).setFromTime(data.getFromTime());
        }
        if (data.getGatewayId() != null) {
            ((Campaign)campaign.get()).setGatewayId(data.getGatewayId());
        }
        if (data.getHoldingTime() != null) {
            ((Campaign)campaign.get()).setHoldingTime(data.getHoldingTime());
        }
        if (data.getIsDisabled() != null) {
            ((Campaign)campaign.get()).setIsDisabled(data.getIsDisabled());
        }
        if (data.getLastDialOut() != null) {
            ((Campaign)campaign.get()).setLastDialOut(data.getLastDialOut());
        }
        if (data.getLastdailOut() != null) {
            ((Campaign)campaign.get()).setLastdailOut(data.getLastdailOut());
        }
        if (data.getNoAnswerCause() != null) {
            ((Campaign)campaign.get()).setNoAnswerCause(data.getNoAnswerCause());
        }
        if (data.getNoAnswerInterval() != null) {
            ((Campaign)campaign.get()).setNoAnswerInterval(data.getNoAnswerInterval());
        }
        if (data.getNotReachableCause() != null) {
            ((Campaign)campaign.get()).setNotReachableCause(data.getNotReachableCause());
        }
        if (data.getNotReachableInterval() != null) {
            ((Campaign)campaign.get()).setNotReachableInterval(data.getNotReachableInterval());
        }
        if (data.getNotificationLevel1() != null) {
            ((Campaign)campaign.get()).setNotificationLevel1(data.getNotificationLevel1());
        }
        if (data.getNotificationLevel2() != null) {
            ((Campaign)campaign.get()).setNotificationLevel2(data.getNotificationLevel2());
        }
        if (data.getNotificationLevel3() != null) {
            ((Campaign)campaign.get()).setNotificationLevel3(data.getNotificationLevel3());
        }
        if (data.getPromoSmsText() != null) {
            ((Campaign)campaign.get()).setPromoSmsText(data.getPromoSmsText());
        }
        if (data.getQueue() != null) {
            ((Campaign)campaign.get()).setQueue(data.getQueue());
        }
        if (data.getScriptPath() != null) {
            ((Campaign)campaign.get()).setScriptPath(data.getScriptPath());
        }
        if (data.getShortCode() != null) {
            ((Campaign)campaign.get()).setShortCode(data.getShortCode());
        }
        if (data.getThirdPartyUrl() != null) {
            ((Campaign)campaign.get()).setThirdPartyUrl(data.getThirdPartyUrl());
        }
        if (data.getToDate() != null) {
            ((Campaign)campaign.get()).setToDate(data.getToDate());
        }
        if (data.getToTime() != null) {
            ((Campaign)campaign.get()).setToTime(data.getToTime());
        }
        if (data.getTotalTry() != null) {
            ((Campaign)campaign.get()).setTotalTry(data.getTotalTry());
        }
        this.campaignRepository.save(campaign.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("campaign Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteCampaignById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional campaign = this.campaignRepository.findById(Long.valueOf(ids));
            if (campaign.isPresent()) {
                addValue.add(campaign.get());
                this.campaignRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllCampaignByFilter(SearchRequest searchRequestData, Long queue) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CampaignSpecification.generateFilters((SearchRequest)searchRequestData, (Long)queue);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.campaignRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.campaignRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<CampaignModel> entityToModelConversion(List<Campaign> campaign) {
        ArrayList<CampaignModel> addValue = new ArrayList<CampaignModel>();
        for (Campaign row : campaign) {
            CampaignModel data = new CampaignModel();
            data.setId(row.getId());
            data.setAutoAttendantId(row.getAutoAttendantId());
            data.setBusyCause(row.getBusyCause());
            data.setBusyInterval(row.getBusyInterval());
            data.setCallLoad(row.getCallLoad());
            data.setCampaignType(row.getCampaignType());
            data.setCopiedFrom(row.getCopiedFrom());
            data.setCreatedBy(row.getCreatedBy());
            data.setCreatedOn(row.getCreatedOn());
            data.setDescription(row.getDescription());
            data.setFromDate(row.getFromDate());
            data.setFromTime(row.getFromTime());
            data.setGatewayId(row.getGatewayId());
            data.setHoldingTime(row.getHoldingTime());
            data.setIsDisabled(row.getIsDisabled());
            data.setLastDialOut(row.getLastDialOut());
            data.setLastdailOut(row.getLastdailOut());
            data.setNoAnswerCause(row.getNoAnswerCause());
            data.setNoAnswerInterval(row.getNoAnswerInterval());
            data.setNotReachableCause(row.getNotReachableCause());
            data.setNotReachableInterval(row.getNotReachableInterval());
            data.setNotificationLevel1(row.getNotificationLevel1());
            data.setNotificationLevel2(row.getNotificationLevel2());
            data.setNotificationLevel3(row.getNotificationLevel3());
            data.setPromoSmsText(row.getPromoSmsText());
            data.setQueue(row.getQueue());
            data.setScriptPath(row.getScriptPath());
            data.setShortCode(row.getShortCode());
            data.setThirdPartyUrl(row.getThirdPartyUrl());
            data.setToDate(row.getToDate());
            data.setToTime(row.getToTime());
            data.setTotalTry(row.getTotalTry());
            addValue.add(data);
        }
        return addValue;
    }
}

