/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.blasterReportView.controller;

import com.coraltele.db.coralapps.callcenter.entity.view.BlasterReportView;
import com.coraltele.db.coralapps.callcenter.repository.BlasterReportViewRepository;
import com.coraltele.db.coralapps.callcenter.specification.BlasterReportViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.blasterReportView.service.BlasterReportViewService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/blasterReport"})
public class BlasterReportViewController {
    private static final Logger logger = LogManager.getLogger(BlasterReportViewController.class);
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    BlasterReportViewService blasterReportViewService;
    @Autowired
    BlasterReportViewRepository blasterReportViewRepository;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.blasterReportViewService.getAll(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for receivedCall--");
            Specification filters = BlasterReportViewSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.blasterReportViewRepository.findAll(filters, sort) : this.blasterReportViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (BlasterReportView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Blaster Report", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Blaster Report CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(BlasterReportView item, String columnName) {
        switch (columnName) {
            case "startStamp": {
                return this.checkNull((Object)item.getStartStamp());
            }
            case "callerIdNumber": {
                return this.checkNull((Object)item.getCallerIdNumber());
            }
            case "destinationNumber": {
                return this.checkNull((Object)item.getDestinationNumber());
            }
            case "duration": {
                return this.checkNull((Object)item.getDuration());
            }
            case "billSec": {
                return this.checkNull((Object)item.getBillSec());
            }
            case "hangupCause": {
                return this.checkNull((Object)item.getHangupCause());
            }
            case "digitsDialed": {
                return this.checkNull((Object)item.getDigitsDialed());
            }
        }
        return "";
    }

    private String formatNullableDate(Long epochMillis) {
        return epochMillis != null ? DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)epochMillis)) : "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    static {
        columnMappings.put("startStamp", "Start Stamp");
        columnMappings.put("callerIdNumber", "Caller Id Number");
        columnMappings.put("destinationNumber", "Destination Number");
        columnMappings.put("duration", "Duration");
        columnMappings.put("billSec", "Bill Sec");
        columnMappings.put("hangupCause", "Hangup Cause");
        columnMappings.put("digitsDialed", "Digits Dialed");
    }
}

