/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlrpc.client.AsyncCallback;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.springframework.stereotype.Service;

@Service
public class TelephonyCommand {
    private static final Logger logger = LogManager.getLogger(TelephonyCommand.class);
    private String callServerFile = "/etc/coraltelecom/callserver.manager.conf";
    private XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
    private XmlRpcClient client = new XmlRpcClient();
    String xmlrpcServerIp;
    String xmlrpcServerPort;
    String xmlrpcServerUsername;
    String xmlrpcServerPWD;

    public TelephonyCommand() throws IOException {
        FileInputStream input = null;
        Properties prop = new Properties();
        try {
            input = new FileInputStream(this.callServerFile);
            prop.load(input);
            File file = new File(this.callServerFile);
            if (file.exists()) {
                this.xmlrpcServerIp = prop.getProperty("xmlrpcserverip");
                if (this.xmlrpcServerIp == null || this.xmlrpcServerIp.equals("")) {
                    this.xmlrpcServerIp = "127.0.0.1";
                }
                this.xmlrpcServerPort = prop.getProperty("xmlrpcserverport");
                if (this.xmlrpcServerPort == null || this.xmlrpcServerPort.equals("")) {
                    this.xmlrpcServerPort = "8089";
                }
                this.xmlrpcServerUsername = prop.getProperty("xmlrpcserverusername");
                if (this.xmlrpcServerUsername == null || this.xmlrpcServerUsername.equals("")) {
                    this.xmlrpcServerUsername = "freeswitch";
                }
                this.xmlrpcServerPWD = prop.getProperty("xmlrpcserverpwd");
                if (this.xmlrpcServerPWD == null || this.xmlrpcServerPWD.equals("")) {
                    this.xmlrpcServerPWD = "works";
                }
            } else {
                this.xmlrpcServerIp = "127.0.0.1";
                this.xmlrpcServerPort = "8089";
                this.xmlrpcServerUsername = "freeswitch";
                this.xmlrpcServerPWD = "works";
            }
            this.config.setServerURL(new URL("http://" + this.xmlrpcServerIp + ":" + this.xmlrpcServerPort + "/RPC2"));
            this.config.setBasicUserName(this.xmlrpcServerUsername);
            this.config.setBasicPassword(this.xmlrpcServerPWD);
            this.client.setConfig((XmlRpcClientConfig)this.config);
        }
        catch (MalformedURLException ex) {
            logger.error("Error in XmlRPCClient() {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public synchronized void executeCommand(String arg0, String arg1, String arg2) {
        try {
            if (arg0.isEmpty()) {
                arg0 = "freeswitch.api";
            }
            logger.info("arg1 : {}, command : {}", (Object)arg1, (Object)arg2);
            if (!arg1.isEmpty() && !arg2.isEmpty()) {
                if (this.client != null) {
                    String resp = (String)this.client.execute(arg0, new Object[]{arg1, arg2});
                    logger.info(resp);
                } else {
                    logger.error("Unable to create Xml Rpc Client");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in executeCommand() {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public synchronized RequestResponse executeCommandAndReturnStatus(String arg0, String arg1, String arg2) {
        RequestResponse returnValue = new RequestResponse();
        try {
            if (arg0.isEmpty()) {
                arg0 = "freeswitch.api";
            }
            String testResponse = (String)this.client.execute("freeswitch.api", new Object[]{"bgapi", "status"});
            logger.info("freeSwitch status : {}", (Object)testResponse);
            logger.info("arg1 : {}, command : {}", (Object)arg1, (Object)arg2);
            logger.info("\n");
            if (!arg1.isEmpty() && !arg2.isEmpty()) {
                if (this.client != null) {
                    String response = (String)this.client.execute(arg0, new Object[]{arg1, arg2});
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage(" Client Executed ");
                    returnValue.setMessageDetail(response);
                    logger.info(response);
                } else {
                    returnValue.setStatus(Constants.Error.XML_RPcCLIENT_ERROR);
                    returnValue.setMessage(" Unable to create Xml Rpc Client");
                    logger.info("Unable to create Xml Rpc Client");
                }
            }
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.COMMAND_EXECUTION_ERROR);
            returnValue.setMessage("Failed");
            returnValue.setMessageDetail("Error in executeCommand()");
            logger.error("Error in executeCommand() {}", (Object)ex.getMessage(), (Object)ex);
        }
        return returnValue;
    }

    public synchronized RequestResponse executeCommandAsync(String arg0, String arg1, String arg2) {
        RequestResponse returnValue = new RequestResponse();
        try {
            if (arg0.isEmpty()) {
                arg0 = "freeswitch.api";
            }
            logger.info("arg1 : {}, command : {}", (Object)arg1, (Object)arg2);
            logger.info("\n");
            if (!arg1.isEmpty() && !arg2.isEmpty()) {
                if (this.client != null) {
                    this.client.executeAsync(arg0, new Object[]{arg1, arg2}, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                } else {
                    returnValue.setStatus(Constants.Error.XML_RPcCLIENT_ERROR);
                    logger.error("Unable to create Xml Rpc Client");
                }
            }
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.COMMAND_EXECUTION_ERROR);
            logger.error("Error in executeCommand() {}", (Object)ex.getMessage(), (Object)ex);
        }
        return returnValue;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

