/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.system;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/system/v2/extensions"})
@RestController
public class ExtensionSystemController {
    @Autowired
    private ExtensionsService extensionsService;

    @PostMapping(value={"/updateHSS/{extensionNumber}"})
    public ResponseEntity<RequestResponse> updateHSS(@PathVariable(value="extensionNumber") String extensionNumber) {
        RequestResponse returnValue = this.extensionsService.updateHSS(extensionNumber);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @DeleteMapping(value={"/updateHSS/{extensionNumber}"})
    public ResponseEntity<RequestResponse> deleteHSS(@PathVariable(value="extensionNumber") String extensionNumber) {
        RequestResponse returnValue = this.extensionsService.deleteHSS(extensionNumber);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/ec"})
    public ResponseEntity<RequestResponse> getAllParticipants() {
        RequestResponse returnValue = this.extensionsService.getExtensionTypeEC();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

