/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userToken.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.user.userToken.model.UserTokenModel;
import com.coraltele.service.user.userToken.service.UserTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/userToken"})
@RestController
public class UserTokenController {
    @Autowired
    UserTokenService userTokenService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody UserTokenModel data, Authentication authentication) {
        RequestResponse returnValue = this.userTokenService.createData(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/verification"})
    public ResponseEntity<RequestResponse> verify() {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Above Token is valid");
        returnValue.setMessageDetail("Verified Successfully");
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

