/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userStatusMaster.service;

import com.coraltele.db.users.main.entity.UserStatusMaster;
import com.coraltele.db.users.main.repository.UserStatusMasterRepository;
import com.coraltele.db.users.main.specification.UserStatusMasterSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.user.userStatusMaster.model.RoleStatusModel;
import com.coraltele.service.user.userStatusMaster.model.UserStatusMasterModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class UserStatusMasterService {
    private static final Logger logger = LogManager.getLogger(UserStatusMasterService.class);
    @Autowired
    UserStatusMasterRepository userStatusMasterRepository;

    public RequestResponse createStatus(UserStatusMasterModel data, Principal principal) {
        logger.debug("create new user status : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            UserStatusMaster userStatusMaster = new UserStatusMaster();
            userStatusMaster.setCreatedBy(principal.getName());
            userStatusMaster.setCreatedOn(LocalDateTime.now());
            userStatusMaster.setDescription(data.getDescription());
            userStatusMaster.setRoleId(data.getRoleId());
            if (this.userStatusMasterRepository.existsByDescription(data.getDescription())) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Error");
                returnValue.setMessageDetail("Status already exists");
                logger.error(returnValue.getMessageDetail());
            } else {
                this.userStatusMasterRepository.save((Object)userStatusMaster);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("UserStatus Created Successfully");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create UserStatus");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(UserStatusMasterModel data, Principal principal) {
        logger.debug("Update status {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional userStatusMaster = this.userStatusMasterRepository.findById((Object)data.getId());
        if (!userStatusMaster.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Status Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getDescription() != null) {
            ((UserStatusMaster)userStatusMaster.get()).setDescription(data.getDescription());
        }
        if (data.getRoleId() != null) {
            ((UserStatusMaster)userStatusMaster.get()).setRoleId(data.getRoleId());
        }
        ((UserStatusMaster)userStatusMaster.get()).setUpdatedBy(principal.getName());
        ((UserStatusMaster)userStatusMaster.get()).setUpdatedOn(LocalDateTime.now());
        this.userStatusMasterRepository.save(userStatusMaster.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("UserStatusMaster Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional userStatusMaster = this.userStatusMasterRepository.findById((Object)ids);
            if (userStatusMaster.isPresent()) {
                addValue.add(userStatusMaster.get());
                this.userStatusMasterRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getByRole(RoleStatusModel role) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<RoleStatusModel> addValue = new ArrayList<RoleStatusModel>();
        List userStatusMasters = this.userStatusMasterRepository.findByRoleId(role.getRoleId());
        if (!userStatusMasters.isEmpty()) {
            for (UserStatusMaster status : userStatusMasters) {
                RoleStatusModel data = new RoleStatusModel();
                data.setRoleId(status.getRoleId());
                data.setId(status.getId());
                data.setDescription(status.getDescription());
                addValue.add(data);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setData(addValue);
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
        returnValue.setMessage("Unable to return value");
        returnValue.setMessageDetail("Records not found");
        return returnValue;
    }

    public RequestResponse getAllUserStatusByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserStatusMasterSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.userStatusMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userStatusMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getStatusDropdown() {
        List list = (List)this.userStatusMasterRepository.findAll();
        ArrayList<RoleStatusModel> addValue = new ArrayList<RoleStatusModel>();
        RequestResponse returnValue = new RequestResponse();
        for (UserStatusMaster userStatus : list) {
            RoleStatusModel data = new RoleStatusModel();
            data.setId(userStatus.getId());
            data.setDescription(userStatus.getDescription());
            data.setRoleId(userStatus.getRoleId());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

