/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.queuePerformance.service;

import com.coraltele.db.telemetry.main.entity.AgentCDR;
import com.coraltele.db.telemetry.main.entity.QueuePerformance;
import com.coraltele.db.telemetry.main.repository.AgentCDRRepository;
import com.coraltele.db.telemetry.main.repository.QueuePerformanceRepository;
import com.coraltele.db.telemetry.main.specification.QueuePerformanceSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.queuePerformance.model.QueuePerformanceModel;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class QueuePerformanceService {
    private static final Logger logger = LogManager.getLogger(QueuePerformance.class);
    @Autowired
    QueuePerformanceRepository QueuePerformanceRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    @Autowired
    AgentCDRRepository agentCDRRepository;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        List queueId = null;
        if (this.userService.checkRoleTL(principal.getName())) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = QueuePerformanceSpecification.generateFilters((SearchRequest)searchRequestData, queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.QueuePerformanceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.QueuePerformanceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<QueuePerformanceModel> entityToModelConversion(List<QueuePerformance> queuePerformance) {
        ArrayList<QueuePerformanceModel> addValue = new ArrayList<QueuePerformanceModel>();
        Map avgAgentMap = this.calculateAverageNumberOfAgents();
        for (QueuePerformance row : queuePerformance) {
            QueuePerformanceModel data = new QueuePerformanceModel();
            Duration totalCustomerAgentTalkTime = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalCustomerAgentTalkTime())));
            Duration totalCustomerTime = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(row.getTotalCustomerTime())));
            data.setEpoch(row.getRecordEpoch());
            data.setRecordEpoch(this.dateFormatUtility.epochToLocalDateForLocalTimeZone(row.getRecordEpoch()));
            data.setStartDateTimeLocal(DateFormatUtility.epochToLocalDateTimeForLocalTimeZone((Long)row.getRecordEpoch()));
            data.setStartDateTimeUtc(DateFormatUtility.epochToLocalDateTimeInUTC((Long)row.getRecordEpoch()));
            data.setCallDirection(row.getCallDirection());
            data.setQueue(row.getQueue());
            data.setQueueName(row.getQueueName());
            data.setTotalAbandonedAtAgent(row.getTotalAbandonedAtAgent());
            data.setTotalAbandonedAtQueue(row.getTotalAbandonedAtQueue());
            data.setTotalConnectedWithAgent(row.getTotalConnectedWithAgent());
            data.setTotalCustomerAgentTalkTime(DateFormatUtility.findLocalTime((Long)totalCustomerAgentTalkTime.getSeconds()));
            data.setTotalCustomerTime(DateFormatUtility.findLocalTime((Long)totalCustomerTime.getSeconds()));
            data.setTotalJoined(row.getTotalJoined());
            data.setTotalNoContact(row.getTotalNoContact());
            data.setTotalWaitTime(DateFormatUtility.findLocalTime((Long)row.getTotalWaitTime()));
            data.setAnswerWaitSecond10(row.getAnswerWaitSecond10());
            data.setAnswerWaitSecond20(row.getAnswerWaitSecond20());
            data.setAnswerWaitSecond30(row.getAnswerWaitSecond30());
            data.setAnswerWaitSecond40(row.getAnswerWaitSecond40());
            data.setAnswerWaitSecond50(row.getAnswerWaitSecond50());
            data.setAnswerWaitSecond60(row.getAnswerWaitSecond60());
            data.setGreaterAnswerWaitSecond60(row.getGreaterAnswerWaitSecond60());
            data.setAbandonedWaitSecond10(row.getAbandonedWaitSecond10());
            data.setAbandonedWaitSecond20(row.getAbandonedWaitSecond20());
            data.setAbandonedWaitSecond30(row.getAbandonedWaitSecond30());
            data.setAbandonedWaitSecond40(row.getAbandonedWaitSecond40());
            data.setAbandonedWaitSecond50(row.getAbandonedWaitSecond50());
            data.setAbandonedWaitSecond60(row.getAbandonedWaitSecond60());
            data.setGreaterAbandonedWaitSecond60(row.getGreaterAbandonedWaitSecond60());
            data.setAverageAnswerWaitTime(DateFormatUtility.findLocalTime((Long)row.getAverageAnswerWaitTime()));
            data.setTotalAbandonedWaitTime(DateFormatUtility.findLocalTime((Long)row.getTotalAbandonedWaitTime()));
            data.setTotalAnswerWaitTime(DateFormatUtility.findLocalTime((Long)row.getTotalAnswerWaitTime()));
            data.setAverageAbandonedWaitTime(DateFormatUtility.findLocalTime((Long)row.getAverageAbandonedWaitTime()));
            data.setAverageTalkTime(DateFormatUtility.findLocalTime((Long)row.getAverageTalkTime()));
            data.setServicePercentage(row.getServicePercentage());
            data.setAbandonedPercentage(row.getAbandonedPercentage());
            LocalDate recordDate = Instant.ofEpochSecond(row.getRecordEpoch()).atZone(ZoneId.systemDefault()).toLocalDate();
            String key = recordDate + "|" + row.getQueue() + "|" + row.getCallDirection();
            Integer avgAgents = avgAgentMap.getOrDefault(key, 0);
            data.setAverageNumberAgent(avgAgents);
            addValue.add(data);
        }
        return addValue;
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }

    public Map<String, Integer> calculateAverageNumberOfAgents() {
        List agentCDRList = (List)this.agentCDRRepository.findAll();
        HashMap<String, Set> agentMap = new HashMap<String, Set>();
        for (AgentCDR cdr : agentCDRList) {
            if (cdr.getStartTime() == null || cdr.getQueue() == null || cdr.getCallDirection() == null || cdr.getAgentName() == null) continue;
            LocalDate date = Instant.ofEpochSecond(cdr.getStartTime()).atZone(ZoneId.systemDefault()).toLocalDate();
            String key = date + "|" + cdr.getQueue() + "|" + cdr.getCallDirection();
            agentMap.computeIfAbsent(key, k -> new HashSet()).add(cdr.getAgentName());
        }
        HashMap<String, Integer> averageAgentMap = new HashMap<String, Integer>();
        for (Map.Entry entry : agentMap.entrySet()) {
            averageAgentMap.put((String)entry.getKey(), ((Set)entry.getValue()).size());
        }
        return averageAgentMap;
    }

    public RequestResponse getDistinctNonNullQueues() {
        RequestResponse response = new RequestResponse();
        List queueResults = this.QueuePerformanceRepository.findDistinctQueueAndQueueName();
        if (queueResults.isEmpty()) {
            response.setMessage("No queues found");
            response.setData(Collections.emptyList());
            return response;
        }
        ArrayList<QueuePerformanceModel> modelList = new ArrayList<QueuePerformanceModel>();
        for (Object[] row : queueResults) {
            QueuePerformanceModel model = new QueuePerformanceModel();
            model.setQueue((String)row[0]);
            model.setQueueName((String)row[1]);
            modelList.add(model);
        }
        response.setMessage("List of distinct non-null queues with names");
        response.setData(modelList);
        return response;
    }
}

