/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.inOutgatewaySummary.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.PdfGeneratorService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="gatewayOutBoundSummaryPdf")
public class GatewayOutBoundSummaryPdf
implements PdfGeneratorService {
    private static final Logger logger = LogManager.getLogger(GatewayOutBoundSummaryPdf.class);
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final String TITLE = "Outbound Gateway Summary";
    private static final String LOGO = "/var/www/html/apple-icon.png";
    private static final String DTF = "dd-MM-yyyy hh:mm:ss a";
    @Autowired
    BillingCDRRepository repo;
    @Autowired
    PdfReportRepository pdfRepo;
    @Autowired
    PdfPageNumberEvent footer;
    private LocalDateTime now;
    private static final NumberFormat INR = NumberFormat.getCurrencyInstance(new Locale("en", "IN"));

    private String formatINR(Double amount) {
        if (amount == null) {
            return "\u20b90.00";
        }
        amount = amount / 100.0;
        return INR.format(amount);
    }

    public RequestResponse generatePdfReport(SearchRequest req, String filePath, Principal p) {
        RequestResponse res = new RequestResponse();
        this.now = LocalDateTime.now();
        this.initFooter();
        try {
            List cols = this.resolveColumns(req);
            List rows = this.fetchDB(req);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document doc = cols.size() > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)baos);
            writer.setPageEvent((PdfPageEvent)this.footer);
            doc.open();
            this.addLogoAndDocTitle(doc, req, Integer.valueOf(cols.size()));
            doc.newPage();
            this.addStyledTable(doc, cols, rows);
            doc.close();
            this.writeFile(filePath, baos.toByteArray());
            res.setStatus(Constants.Error.OK);
            res.setMessage("PDF generated");
            res.setData((Object)filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            res.setStatus(Constants.Error.ERROR);
            res.setMessage("PDF generation failed");
        }
        return res;
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)LOGO);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
            }
            img.setAlignment(1);
            logoCell.addElement((Element)img);
            PdfPCell title = new PdfPCell(new Phrase(TITLE, COURIER));
            title.setHorizontalAlignment(1);
            title.setBorder(0);
            PdfPCell dt = new PdfPCell(new Phrase("Report generated on " + this.now.format(DateTimeFormatter.ofPattern(DTF)), COURIER_SMALL));
            dt.setHorizontalAlignment(1);
            dt.setBorder(0);
            table.addCell(logoCell);
            table.addCell(title);
            table.addCell(dt);
            document.add((Element)table);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addStyledTable(Document doc, List<String> cols, List<Object[]> rows) throws Exception {
        PdfPTable t = new PdfPTable(cols.size());
        t.setWidthPercentage(100.0f);
        BaseColor headerBlue = new BaseColor(2, 111, 194);
        BaseColor altGrey = new BaseColor(230, 230, 230);
        for (String c : cols) {
            PdfPCell h = new PdfPCell(new Phrase(this.mapCol(c), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
            h.setHorizontalAlignment(1);
            h.setVerticalAlignment(5);
            h.setBackgroundColor(headerBlue);
            h.setBorder(0);
            h.setPadding(8.0f);
            t.addCell(h);
        }
        t.setHeaderRows(1);
        if (rows == null || rows.isEmpty()) {
            PdfPCell cell = new PdfPCell(new Phrase("No Records Found"));
            cell.setColspan(cols.size());
            cell.setHorizontalAlignment(1);
            cell.setBorder(0);
            t.addCell(cell);
        } else {
            int rowIndex = 0;
            for (Object[] r : rows) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("coralGateway", this.safe(r[0]));
                m.put("intercomCall", this.safe(r[1]));
                m.put("intercomCost", this.formatINR(Double.valueOf(this.toD(r[2]))));
                m.put("localCall", this.safe(r[3]));
                m.put("localCost", this.formatINR(Double.valueOf(this.toD(r[4]))));
                m.put("stdCall", this.safe(r[5]));
                m.put("stdCost", this.formatINR(Double.valueOf(this.toD(r[6]))));
                m.put("isdCall", this.safe(r[7]));
                m.put("isdCost", this.formatINR(Double.valueOf(this.toD(r[8]))));
                m.put("totalCall", this.safe(r[9]));
                m.put("totalCost", this.formatINR(Double.valueOf(this.toD(r[10]))));
                BaseColor bg = rowIndex % 2 == 0 ? BaseColor.WHITE : altGrey;
                for (String c : cols) {
                    PdfPCell cell = new PdfPCell(new Phrase((String)m.get(c)));
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.setBackgroundColor(bg);
                    cell.setBorder(0);
                    cell.setPadding(6.0f);
                    t.addCell(cell);
                }
                ++rowIndex;
            }
        }
        doc.add((Element)t);
    }

    private String safe(Object v) {
        return v == null ? "" : v.toString();
    }

    private double toD(Object o) {
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    private List<String> resolveColumns(SearchRequest r) {
        if (r.getColumnNames() == null || r.getColumnNames().isEmpty()) {
            return Arrays.asList("coralGateway", "intercomCall", "intercomCost", "localCall", "localCost", "stdCall", "stdCost", "isdCall", "isdCost", "totalCall", "totalCost");
        }
        return r.getColumnNames();
    }

    private String mapCol(String k) {
        switch (k) {
            case "coralGateway": {
                return "Outbound Gateway";
            }
            case "intercomCall": {
                return "Intercom Calls";
            }
            case "intercomCost": {
                return "Intercom Cost";
            }
            case "localCall": {
                return "Local Calls";
            }
            case "localCost": {
                return "Local Cost";
            }
            case "stdCall": {
                return "STD Calls";
            }
            case "stdCost": {
                return "STD Cost";
            }
            case "isdCall": {
                return "ISD Calls";
            }
            case "isdCost": {
                return "ISD Cost";
            }
            case "totalCall": {
                return "Total Calls";
            }
            case "totalCost": {
                return "Total Cost";
            }
        }
        return k;
    }

    private void initFooter() {
        try {
            this.footer.initialize(LOGO, TITLE, DTF, this.now);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeFile(String path, byte[] data) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(path);){
            fos.write(data);
        }
    }

    private List<Object[]> fetchDB(SearchRequest request) {
        String fromDate = null;
        String toDate = null;
        String gw = null;
        if (request.getAdvancedFilters() != null) {
            for (AdvanceFilter f : request.getAdvancedFilters()) {
                if ("callDate".equalsIgnoreCase(f.getFieldName())) {
                    if ("from".equalsIgnoreCase(f.getDirection())) {
                        fromDate = f.getValue();
                    }
                    if ("to".equalsIgnoreCase(f.getDirection())) {
                        toDate = f.getValue();
                    }
                }
                if (!"coralGateway".equalsIgnoreCase(f.getFieldName())) continue;
                gw = f.getValue();
            }
        }
        LocalDate from = this.parseDate(fromDate);
        LocalDate to = this.parseDate(toDate);
        return "desc".equalsIgnoreCase(request.getSortDirection()) ? this.repo.fetchDesc(from, to, gw, Integer.MAX_VALUE, 0) : this.repo.fetchAsc(from, to, gw, Integer.MAX_VALUE, 0);
    }

    private LocalDate parseDate(String date) {
        return date == null || date.trim().isEmpty() ? null : LocalDate.parse(date);
    }

    public void createPdfReportRecord(String id, SearchRequest d, String fp) {
        try {
            PdfReportFilters f = new PdfReportFilters();
            f.setId(id);
            f.setReportName(TITLE);
            f.setPdfLocation(fp);
            f.setCreatedOnDate(this.now);
            f.setStatus("InProgress");
            f.setFilterParameters(new ObjectMapper().writeValueAsString((Object)d));
            this.pdfRepo.save((Object)f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

