/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.deviceModel.service;

import com.coraltele.db.telemetry.main.entity.DeviceModel;
import com.coraltele.db.telemetry.main.repository.DeviceModelRepository;
import com.coraltele.db.telemetry.main.specification.DeviceModelSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.deviceModel.model.DeviceDataModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DeviceModelService {
    private static final Logger logger = LogManager.getLogger(DeviceModelService.class);
    @Autowired
    DeviceModelRepository deviceModelRepository;

    public RequestResponse createData(DeviceDataModel data) {
        logger.info("Create new deviceModel : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            DeviceModel record = new DeviceModel();
            record.setFormCode(data.getFormCode());
            record.setOui(data.getOui());
            record.setProductClass(data.getProductClass());
            record.setManufacturer(data.getManufacturer());
            this.deviceModelRepository.save((Object)record);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("New data Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create data");
            returnValue.setMessageDetail("Contact With administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(DeviceDataModel data) {
        logger.info("Update data {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional deviceData = this.deviceModelRepository.findById((Object)data.getId());
        if (!deviceData.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("data Not Found");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        if (data.getFormCode() != null) {
            ((DeviceModel)deviceData.get()).setFormCode(data.getFormCode());
        }
        if (data.getOui() != null) {
            ((DeviceModel)deviceData.get()).setOui(data.getOui());
        }
        if (data.getProductClass() != null) {
            ((DeviceModel)deviceData.get()).setProductClass(data.getProductClass());
        }
        if (data.getManufacturer() != null) {
            ((DeviceModel)deviceData.get()).setManufacturer(data.getManufacturer());
        }
        this.deviceModelRepository.save(deviceData.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("data Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional deviceData = this.deviceModelRepository.findById((Object)ids);
            if (deviceData.isPresent()) {
                addValue.add(deviceData.get());
                this.deviceModelRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.deviceModelRepository.findAll();
        ArrayList<DeviceDataModel> addValue = new ArrayList<DeviceDataModel>();
        RequestResponse returnValue = new RequestResponse();
        for (DeviceModel deviceModel : list) {
            DeviceDataModel data = new DeviceDataModel();
            data.setId(deviceModel.getId());
            data.setFormCode(deviceModel.getFormCode());
            data.setProductClass(deviceModel.getProductClass());
            data.setOui(deviceModel.getOui());
            data.setManufacturer(deviceModel.getManufacturer());
            data.setUuid(deviceModel.getUuid());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DeviceModelSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.deviceModelRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.deviceModelRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

