/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.coralnms.locationType.service;

import com.coraltele.db.telemetry.coralnms.entity.LocationType;
import com.coraltele.db.telemetry.coralnms.repository.LocationTypeRepository;
import com.coraltele.db.telemetry.coralnms.specification.LocationTypeSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.coralnms.locationType.model.LocationTypeModel;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class LocationTypeService {
    private static final Logger logger = LogManager.getLogger(LocationTypeService.class);
    @Autowired
    LocationTypeRepository locationTypeRepository;

    public RequestResponse createData(LocationTypeModel data) {
        logger.debug("Create New LocationType : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            LocationType locationType = new LocationType();
            locationType.setName(data.getName());
            locationType.setZoomLevel(data.getZoomLevel());
            this.locationTypeRepository.save((Object)locationType);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("LocationType Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create LocationType");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(LocationTypeModel data) {
        logger.debug("Update LocationType {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional locationType = this.locationTypeRepository.findById((Object)data.getId());
        if (!locationType.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("LocationType Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getName() != null) {
            ((LocationType)locationType.get()).setName(data.getName());
        }
        if (data.getZoomLevel() != 0) {
            ((LocationType)locationType.get()).setZoomLevel(data.getZoomLevel());
        }
        this.locationTypeRepository.save(locationType.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("LocationType Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteLocationTypeById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (String ids : data.getStringId()) {
            Optional locationType = this.locationTypeRepository.findById((Object)ids);
            if (locationType.isPresent()) {
                addValue.add(locationType.get());
                this.locationTypeRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllLocationTypeByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = LocationTypeSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.locationTypeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.locationTypeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

