/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.didmapping.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.didmapping.model.DidMappingModel;
import com.coraltele.service.pbx.didmapping.service.DidMappingService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/didMapping"})
@RestController
public class DidMappingController {
    @Autowired
    private DidMappingService didMappingService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> addDidMapping(@RequestBody DidMappingModel data) {
        RequestResponse returnValue = this.didMappingService.createDidMapping(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{id}"})
    public ResponseEntity<RequestResponse> getDidMappingById(@PathVariable(value="id") int id) {
        RequestResponse returnValue = this.didMappingService.getById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllDidMapping(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.didMappingService.getDidMappingByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PutMapping(value={"update/{id}"})
    public ResponseEntity<RequestResponse> updateDidMapping(HttpServletRequest request, @PathVariable(value="id") int id, @RequestBody DidMappingModel data, Authentication authentication) {
        RequestResponse returnValue = this.didMappingService.updateDidMapping(request, id, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"delete/{id}"})
    public ResponseEntity<RequestResponse> delete(@PathVariable(value="id") String id) {
        RequestResponse returnValue = this.didMappingService.deleteDidMapping(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

