/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.disposition.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.disposition.model.DispositionCreateModel;
import com.coraltele.service.coralApps.callcenter.disposition.service.DispositionService;
import java.io.IOException;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/disposition"})
@RestController
public class DispositionController {
    private static final Logger logger = LogManager.getLogger(DispositionController.class);
    @Autowired
    DispositionService dispositionService;

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllDisposition() {
        RequestResponse returnValue = this.dispositionService.getAllDisposition();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/getAgentForm"})
    public ResponseEntity<RequestResponse> getAgentFile() throws IOException {
        RequestResponse returnValue = this.dispositionService.getAgentFile();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/getInboundForm"})
    public ResponseEntity<RequestResponse> getInboundForm() throws IOException {
        RequestResponse returnValue = this.dispositionService.getInboundForm();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody DispositionCreateModel data, Principal principal) {
        RequestResponse returnValue = this.dispositionService.createDataInDisposition(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody DispositionCreateModel data) {
        RequestResponse returnValue = this.dispositionService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.dispositionService.deleteAgentById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.dispositionService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

