CREATE OR REPLACE VIEW public.v_userrole
 AS
 SELECT DISTINCT a.username,
    a.role
   FROM ( SELECT a_1.username,
            b.shortcode AS role
           FROM m_user a_1
             CROSS JOIN m_role b
             LEFT JOIN m_userrole c ON a_1.id = c."user"
             LEFT JOIN m_role d ON c.role = d.id
          WHERE b.shortcode::text <> 'ROLE_ADMIN'::text AND d.shortcode::text = 'ROLE_ADMIN'::text AND b.shortcode::text <> 'ROLE_AGENT'::text AND b.shortcode::text <> 'ROLE_ENGINEER'::text
        UNION ALL
         SELECT b.username,
            c.shortcode AS role
           FROM m_userrole a_1
             JOIN m_user b ON a_1."user" = b.id
             JOIN m_role c ON a_1.role = c.id
        UNION ALL
         SELECT a_1.username,
            b.shortcode AS role
           FROM m_user a_1
             CROSS JOIN m_role b
             LEFT JOIN m_userrole c ON a_1.id = c."user"
             LEFT JOIN m_role d ON c.role = d.id
          WHERE b.shortcode::text ~~ '%SPACS%'::text AND b.shortcode::text <> 'ROLE_SPACSSUPERADMIN'::text AND (d.shortcode::text = ANY (ARRAY['ROLE_SPACSSUPERADMIN'::text, 'ROLE_SPACSADMIN'::text]))
        UNION ALL
         SELECT a_1.username,
            b.shortcode AS role
           FROM m_user a_1
             CROSS JOIN m_role b
             JOIN m_userrole c ON a_1.id = c."user"
             JOIN m_role d ON c.role = d.id
          WHERE b.shortcode::text = 'ROLE_SPACSENDUSER'::text AND d.shortcode::text <> 'ROLE_SPACSENDUSER'::text AND d.shortcode::text ~~ '%SPACS%'::text
        UNION ALL
         SELECT a_1.username,
            b.shortcode AS role
           FROM m_user a_1
             CROSS JOIN m_role b
             LEFT JOIN m_userrole c ON a_1.id = c."user"
             LEFT JOIN m_role d ON c.role = d.id
          WHERE b.shortcode::text = 'ROLE_PBXADMIN'::text AND (d.shortcode::text = ANY (ARRAY['ROLE_SPACSSUPERADMIN'::text, 'ROLE_SPACSADMIN'::text, 'ROLE_USERS'::text]))
        UNION ALL
         SELECT a_1.username,
            b.shortcode AS role
           FROM m_user a_1
             CROSS JOIN m_role b
             LEFT JOIN m_userrole c ON a_1.id = c."user"
             LEFT JOIN m_role d ON c.role = d.id
          WHERE b.shortcode::text = 'ROLE_SYSTEMADMIN'::text AND (d.shortcode::text = ANY (ARRAY['ROLE_SPACSSUPERADMIN'::text, 'ROLE_USERS'::text]))
        UNION ALL
         SELECT a_1.username,
            b.shortcode AS role
           FROM m_user a_1
             CROSS JOIN m_role b
             LEFT JOIN m_agentlist c ON a_1.id = c.username
          WHERE b.shortcode::text = 'ROLE_USERS'::text AND COALESCE(c.username, 0) = 1) a;