/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.controller;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.entity.VoiceLogger;
import com.coraltele.db.billing.main.repository.FaxRepository;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.billing.main.repository.VoiceLoggerRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.IVRUtility;
import com.coraltele.helper.JwtUtil;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.billing.main.epVoicePicker.service.EpVoicePickerService;
import com.coraltele.service.billing.main.voiceLogger.service.VoiceLoggerService;
import com.coraltele.service.coralApps.callcenter.leadSummaryInternalView.service.LeadSummaryViewService;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.service.ConferenceMeetingService;
import com.coraltele.service.pbx.distortionFile.service.DistortionFileService;
import com.coraltele.service.pbx.videoRecording.service.VideoRecordingService;
import com.coraltele.service.telemetry.main.agentCDR.service.AgentCDRService;
import com.coraltele.service.telemetry.main.customerCDR.service.CustomerCDRService;
import com.coraltele.service.telemetry.main.lastNAgentCDR.service.LastNAgentCDRService;
import com.coraltele.service.telemetry.main.paCDR.service.PaCdrService;
import com.coraltele.service.uc.service.VoicemailService;
import com.coraltele.service.user.model.AuthenticationRequestModel;
import com.coraltele.service.user.model.ChangePasswordModel;
import com.coraltele.service.user.model.GenerateOtpModel;
import com.coraltele.service.user.service.UserAuthenticationService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RequestMapping(value={"/app/v2/auth"})
@RestController
public class UserAuthenticationController {
    private static final Logger logger = LogManager.getLogger(UserAuthenticationController.class);
    private static final String CONTROLLER_NAME = "UserAuthentication";
    String message;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private UserAuthenticationService userAuthenticationService;
    @Autowired
    private VideoRecordingService videoRecordingsService;
    @Autowired
    private VoicemailService voicemailService;
    @Autowired
    FaxRepository faxRepository;
    @Autowired
    IVRUtility iVRUtility;
    @Autowired
    EpVoicePickerService voicePicker;
    @Autowired
    CustomerCDRService customerCDRService;
    @Autowired
    LastNAgentCDRService lastNAgentCDRService;
    @Autowired
    PaCdrService paCdrService;
    @Autowired
    DistortionFileService distortionFileService;
    @Autowired
    PdfReportRepository pdfReportRepository;
    @Autowired
    LeadSummaryViewService leadSummaryViewService;
    @Autowired
    AgentCDRService agentCDRService;
    @Autowired
    VoiceLoggerService voiceLoggerService;
    @Autowired
    ConferenceMeetingService conferenceService;
    @Autowired
    VoiceLoggerRepository voiceLoggerRepository;

    @PostMapping(value={"/login"})
    public ResponseEntity<RequestResponse> loginUser(@RequestBody AuthenticationRequestModel jwtRequest, HttpServletRequest request) throws Exception {
        RequestResponse returnValue = this.userAuthenticationService.login(jwtRequest, Integer.valueOf(1), request);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/login2"})
    public ResponseEntity<RequestResponse> login2(@RequestBody AuthenticationRequestModel jwtRequest, HttpServletRequest request) throws Exception {
        RequestResponse returnValue = this.userAuthenticationService.login(jwtRequest, Integer.valueOf(2), request);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/changePassword"})
    public ResponseEntity<RequestResponse> changePassword(@RequestBody ChangePasswordModel data) {
        RequestResponse returnValue = this.userAuthenticationService.updatePassword(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/videoRecordingStream/{id}"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> playMedia(@PathVariable(value="id") Integer id, @RequestHeader(value="Range", required=false) String rangeHeader) {
        try {
            String fileName;
            String filePathString = fileName = this.videoRecordingsService.findFile(id);
            Path filePath = Paths.get(filePathString, new String[0]);
            Long fileSize = Files.size(filePath);
            byte[] buffer = new byte[1024];
            HttpHeaders responseHeaders = new HttpHeaders();
            if (rangeHeader == null) {
                responseHeaders.add("Content-Type", "video/mp4");
                responseHeaders.add("Content-Length", fileSize.toString());
                StreamingResponseBody responseStream = os -> {
                    long pos;
                    RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                    file.seek(pos);
                    for (pos = 0L; pos < fileSize - 1L; pos += (long)buffer.length) {
                        file.read(buffer);
                        os.write(buffer);
                    }
                    os.flush();
                    file.close();
                };
                return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            String[] ranges = rangeHeader.split("-");
            Long rangeStart = Long.parseLong(ranges[0].substring(6));
            Long rangeEnd = ranges.length > 1 ? Long.valueOf(Long.parseLong(ranges[1])) : Long.valueOf(fileSize - 1L);
            if (fileSize < rangeEnd) {
                rangeEnd = fileSize - 1L;
            }
            String contentLength = String.valueOf(rangeEnd - rangeStart + 1L);
            responseHeaders.add("Content-Type", "video/mp4");
            responseHeaders.add("Content-Length", contentLength);
            responseHeaders.add("Accept-Ranges", "bytes");
            responseHeaders.add("Content-Range", "bytes " + rangeStart + "-" + rangeEnd + "/" + fileSize);
            Long _rangeEnd = rangeEnd;
            StreamingResponseBody responseStream = os -> {
                long pos;
                RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                file.seek(pos);
                for (pos = rangeStart.longValue(); pos < _rangeEnd; pos += (long)buffer.length) {
                    file.read(buffer);
                    os.write(buffer);
                }
                os.flush();
                file.close();
            };
            return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.PARTIAL_CONTENT);
        }
        catch (FileNotFoundException e) {
            logger.error("Unable to find file at this id {} ", (Object)id, (Object)e);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IOException e) {
            logger.error("Unable to transfer file at this id {} ", (Object)id, (Object)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/ucStream/{userName}/{id}"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> playUcMedia(@PathVariable(value="userName") String userName, @PathVariable(value="id") String id, @RequestHeader(value="Range", required=false) String rangeHeader) {
        try {
            String fileName = this.voicemailService.getFile(userName, id);
            if (fileName != null) {
                String filePathString = fileName;
                Path filePath = Paths.get(filePathString, new String[0]);
                Long fileSize = Files.size(filePath);
                byte[] buffer = new byte[4024];
                HttpHeaders responseHeaders = new HttpHeaders();
                if (rangeHeader == null) {
                    responseHeaders.add("Content-Type", "audio/mp3");
                    responseHeaders.add("Content-Length", fileSize.toString());
                    StreamingResponseBody responseStream = os -> {
                        long pos;
                        RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                        file.seek(pos);
                        for (pos = 0L; pos < fileSize - 1L; pos += (long)buffer.length) {
                            file.read(buffer);
                            os.write(buffer);
                        }
                        os.flush();
                        file.close();
                    };
                    return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.OK);
                }
                String[] ranges = rangeHeader.split("-");
                Long rangeStart = Long.parseLong(ranges[0].substring(6));
                Long rangeEnd = ranges.length > 1 ? Long.valueOf(Long.parseLong(ranges[1])) : Long.valueOf(fileSize - 1L);
                if (fileSize < rangeEnd) {
                    rangeEnd = fileSize - 1L;
                }
                String contentLength = String.valueOf(rangeEnd - rangeStart + 1L);
                responseHeaders.add("Content-Type", "audio/mp3");
                responseHeaders.add("Content-Length", contentLength);
                responseHeaders.add("Accept-Ranges", "bytes");
                responseHeaders.add("Content-Range", "bytes " + rangeStart + "-" + rangeEnd + "/" + fileSize);
                Long _rangeEnd = rangeEnd;
                StreamingResponseBody responseStream = os -> {
                    long pos;
                    RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                    file.seek(pos);
                    for (pos = rangeStart.longValue(); pos < _rangeEnd; pos += (long)buffer.length) {
                        file.read(buffer);
                        os.write(buffer);
                    }
                    os.flush();
                    file.close();
                };
                return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.PARTIAL_CONTENT);
            }
            logger.error("Null data found at this id {} ", (Object)id);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (FileNotFoundException e) {
            logger.error("Unable to find file at this id {} ", (Object)id, (Object)e);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IOException e) {
            logger.error("Unable to transfer file at this id {} ", (Object)id, (Object)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/faxDownload"})
    public ResponseEntity<?> downloadFax(@RequestParam(value="path") String fileName) {
        RequestResponse returnValue = new RequestResponse();
        Resource resource = null;
        try {
            resource = this.iVRUtility.sourceToDownload(fileName);
            this.message = MessageFormat.format(" FAX: Image Processed Successfully. {0}", fileName);
            logger.info(this.message);
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Image Not Found");
            returnValue.setMessageDetail("Image Not found Which You Want To Download");
            this.message = MessageFormat.format("{1}, Image Not found Which You Want To Download : {0}", CONTROLLER_NAME, fileName);
            logger.error(this.message, (Throwable)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        if (resource == null) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Resource Not Found");
            returnValue.setMessageDetail("Resource Not found Which You Want To Download");
            this.message = MessageFormat.format("{1}, Resource Not found Which You Want To Download : {0}", CONTROLLER_NAME, fileName);
            logger.error(this.message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        String headerValue = "attachment; filename=\"" + resource.getFilename();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.valueOf((String)"image/tiff")).header("Content-Disposition", new String[]{headerValue})).body((Object)resource);
    }

    @GetMapping(value={"/downloadMp3"})
    public ResponseEntity<?> downloadMp3(@RequestParam(value="path") String filename) {
        RequestResponse returnValue = new RequestResponse();
        Resource resource = null;
        try {
            String encodedFilePath = URLEncoder.encode(filename, StandardCharsets.UTF_8.name());
            String decodedFilePath = URLDecoder.decode(encodedFilePath, StandardCharsets.UTF_8.name());
            resource = this.iVRUtility.sourceToDownload(decodedFilePath);
            String message = "MP3 File Processed Successfully: " + decodedFilePath;
            logger.info(message);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Found: " + filename);
            String errorMessage = "File Not found: " + filename;
            logger.error(errorMessage, (Throwable)e);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        if (resource == null) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Resource Not Found");
            returnValue.setMessageDetail("Resource Not Found: " + filename);
            String errorMessage = "Resource Not found: " + filename;
            logger.error(errorMessage);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        List voiceLoggers = this.voiceLoggerRepository.findByRecordFilename(filename);
        String responseFilename = this.voiceLoggerService.sanitize(filename);
        if (!voiceLoggers.isEmpty()) {
            VoiceLogger voiceLogger = (VoiceLogger)voiceLoggers.get(0);
            responseFilename = this.voiceLoggerService.generateArchiveFilename(voiceLogger, Boolean.valueOf(false));
        }
        String encodedFilename = "";
        try {
            encodedFilename = URLEncoder.encode(responseFilename, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            encodedFilename = responseFilename;
        }
        String headerValue = "attachment; filename=\"" + responseFilename + "\"; filename*=UTF-8''" + encodedFilename;
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{headerValue})).header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).body((Object)resource);
    }

    @GetMapping(value={"/epVoicePicker/{id}"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> playVoicePicker(@PathVariable(value="id") Integer id, @RequestHeader(value="Range", required=false) String rangeHeader) {
        try {
            String path = this.voicePicker.getFile(id);
            if (path != null) {
                String filePathString = path;
                Path filePath = Paths.get(path, new String[0]);
                Long fileSize = Files.size(filePath);
                byte[] buffer = new byte[4024];
                HttpHeaders responseHeaders = new HttpHeaders();
                if (rangeHeader == null) {
                    responseHeaders.add("Content-Type", "audio/mp3");
                    responseHeaders.add("Content-Length", fileSize.toString());
                    StreamingResponseBody responseStream = os -> {
                        long pos;
                        RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                        file.seek(pos);
                        for (pos = 0L; pos < fileSize - 1L; pos += (long)buffer.length) {
                            file.read(buffer);
                            os.write(buffer);
                        }
                        os.flush();
                        file.close();
                    };
                    return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.OK);
                }
                String[] ranges = rangeHeader.split("-");
                Long rangeStart = Long.parseLong(ranges[0].substring(6));
                Long rangeEnd = ranges.length > 1 ? Long.valueOf(Long.parseLong(ranges[1])) : Long.valueOf(fileSize - 1L);
                if (fileSize < rangeEnd) {
                    rangeEnd = fileSize - 1L;
                }
                String contentLength = String.valueOf(rangeEnd - rangeStart + 1L);
                responseHeaders.add("Content-Type", "audio/mp3");
                responseHeaders.add("Content-Length", contentLength);
                responseHeaders.add("Accept-Ranges", "bytes");
                responseHeaders.add("Content-Range", "bytes " + rangeStart + "-" + rangeEnd + "/" + fileSize);
                Long _rangeEnd = rangeEnd;
                StreamingResponseBody responseStream = os -> {
                    long pos;
                    RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                    file.seek(pos);
                    for (pos = rangeStart.longValue(); pos < _rangeEnd; pos += (long)buffer.length) {
                        file.read(buffer);
                        os.write(buffer);
                    }
                    os.flush();
                    file.close();
                };
                return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.PARTIAL_CONTENT);
            }
            logger.error("Null data found at this id {} ");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (FileNotFoundException e) {
            logger.error("Unable to find file at this id {} ", (Throwable)e);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IOException e) {
            logger.error("Unable to transfer file at this id {} ", (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/{searchFile}/{id}"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> playRecordingCustomerCDR(@PathVariable(value="searchFile") String searchFile, @PathVariable(value="id") String id, @RequestHeader(value="Range", required=false) String rangeHeader) {
        try {
            String path = null;
            if (searchFile.equals("customerCdr")) {
                path = this.customerCDRService.getFile(id);
            } else if (searchFile.equals("paCdr")) {
                path = this.paCdrService.getFile(id);
            } else if (searchFile.equals("distortionFile")) {
                path = this.distortionFileService.getFile(Integer.valueOf(id));
            } else if (searchFile.equals("agentCdr")) {
                path = this.agentCDRService.getFile(id);
            }
            if (path != null) {
                String contentType;
                String filePathString = path;
                Path filePath = Paths.get(path, new String[0]);
                Long fileSize = Files.size(filePath);
                byte[] buffer = new byte[8192];
                HttpHeaders responseHeaders = new HttpHeaders();
                if (path.toLowerCase().endsWith(".wav")) {
                    contentType = "audio/wav";
                } else if (path.toLowerCase().endsWith(".mp3")) {
                    contentType = "audio/mp3";
                } else {
                    logger.error("Unsupported file format at this id {}: {}", (Object)id, (Object)path);
                    return new ResponseEntity(HttpStatus.BAD_REQUEST);
                }
                if (rangeHeader == null) {
                    responseHeaders.add("Content-Type", contentType);
                    responseHeaders.add("Content-Length", fileSize.toString());
                    StreamingResponseBody responseStream = os -> {
                        int bytesRead;
                        long pos;
                        RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                        file.seek(pos);
                        for (pos = 0L; pos < fileSize - 1L; pos += (long)bytesRead) {
                            bytesRead = file.read(buffer);
                            os.write(buffer, 0, bytesRead);
                        }
                        os.flush();
                        file.close();
                    };
                    return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.OK);
                }
                String[] ranges = rangeHeader.split("-");
                Long rangeStart = Long.parseLong(ranges[0].substring(6));
                Long rangeEnd = ranges.length > 1 ? Long.valueOf(Long.parseLong(ranges[1])) : Long.valueOf(fileSize - 1L);
                if (fileSize < rangeEnd) {
                    rangeEnd = fileSize - 1L;
                }
                String contentLength = String.valueOf(rangeEnd - rangeStart + 1L);
                responseHeaders.add("Content-Type", contentType);
                responseHeaders.add("Content-Length", contentLength);
                responseHeaders.add("Accept-Ranges", "bytes");
                responseHeaders.add("Content-Range", "bytes " + rangeStart + "-" + rangeEnd + "/" + fileSize);
                Long _rangeEnd = rangeEnd;
                StreamingResponseBody responseStream = os -> {
                    int bytesRead;
                    long pos;
                    RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                    file.seek(pos);
                    for (pos = rangeStart.longValue(); pos < _rangeEnd; pos += (long)bytesRead) {
                        bytesRead = file.read(buffer);
                        os.write(buffer, 0, bytesRead);
                    }
                    os.flush();
                    file.close();
                };
                return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.PARTIAL_CONTENT);
            }
            logger.error("Null data found at this id {} ");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (FileNotFoundException e) {
            logger.error("Unable to find file at this id {} ", (Throwable)e);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IOException e) {
            logger.error("Unable to transfer file at this id {} ", (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/lastNAgentCdr/{uuid}"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> playRecordingLastNAgentCDR(@PathVariable(value="uuid") String uuid, @RequestHeader(value="Range", required=false) String rangeHeader) {
        try {
            String path = this.lastNAgentCDRService.getFile(uuid);
            if (path != null) {
                String contentType;
                String filePathString = path;
                Path filePath = Paths.get(path, new String[0]);
                Long fileSize = Files.size(filePath);
                byte[] buffer = new byte[8192];
                HttpHeaders responseHeaders = new HttpHeaders();
                if (path.toLowerCase().endsWith(".wav")) {
                    contentType = "audio/wav";
                } else if (path.toLowerCase().endsWith(".mp3")) {
                    contentType = "audio/mp3";
                } else {
                    logger.error("Unsupported file format at this id {}: {}", (Object)uuid, (Object)path);
                    return new ResponseEntity(HttpStatus.BAD_REQUEST);
                }
                if (rangeHeader == null) {
                    responseHeaders.add("Content-Type", contentType);
                    responseHeaders.add("Content-Length", fileSize.toString());
                    StreamingResponseBody responseStream = os -> {
                        int bytesRead;
                        long pos;
                        RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                        file.seek(pos);
                        for (pos = 0L; pos < fileSize - 1L; pos += (long)bytesRead) {
                            bytesRead = file.read(buffer);
                            os.write(buffer, 0, bytesRead);
                        }
                        os.flush();
                        file.close();
                    };
                    return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.OK);
                }
                String[] ranges = rangeHeader.split("-");
                Long rangeStart = Long.parseLong(ranges[0].substring(6));
                Long rangeEnd = ranges.length > 1 ? Long.valueOf(Long.parseLong(ranges[1])) : Long.valueOf(fileSize - 1L);
                if (fileSize < rangeEnd) {
                    rangeEnd = fileSize - 1L;
                }
                String contentLength = String.valueOf(rangeEnd - rangeStart + 1L);
                responseHeaders.add("Content-Type", contentType);
                responseHeaders.add("Content-Length", contentLength);
                responseHeaders.add("Accept-Ranges", "bytes");
                responseHeaders.add("Content-Range", "bytes " + rangeStart + "-" + rangeEnd + "/" + fileSize);
                Long _rangeEnd = rangeEnd;
                StreamingResponseBody responseStream = os -> {
                    int bytesRead;
                    long pos;
                    RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                    file.seek(pos);
                    for (pos = rangeStart.longValue(); pos < _rangeEnd; pos += (long)bytesRead) {
                        bytesRead = file.read(buffer);
                        os.write(buffer, 0, bytesRead);
                    }
                    os.flush();
                    file.close();
                };
                return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.PARTIAL_CONTENT);
            }
            logger.error("Null data found at this id {} ");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (FileNotFoundException e) {
            logger.error("Unable to find file at this id {} ", (Throwable)e);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IOException e) {
            logger.error("Unable to transfer file at this id {} ", (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/downloadRecordingFile/{searchFile}/{uuid}"})
    public ResponseEntity<Resource> downloadRecordingLastNAgentCDR(@PathVariable(value="searchFile") String searchFile, @PathVariable(value="uuid") String uuid) {
        try {
            String path = null;
            if (searchFile.equals("customerCdr")) {
                path = this.customerCDRService.getFile(uuid);
            } else if (searchFile.equals("paCdr")) {
                path = this.paCdrService.getFile(uuid);
            } else if (searchFile.equals("lastAgentCdr")) {
                path = this.lastNAgentCDRService.getFile(uuid);
            } else if (searchFile.equals("agentCdr")) {
                path = this.agentCDRService.getFile(uuid);
            }
            if (path != null) {
                Path filePath = Paths.get(path, new String[0]);
                FileSystemResource resource = new FileSystemResource(filePath.toFile());
                if (resource.exists()) {
                    HttpHeaders headers = new HttpHeaders();
                    headers.add("Content-Disposition", "attachment; filename=\"" + resource.getFilename() + "\"");
                    headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
                    headers.add("Pragma", "no-cache");
                    headers.add("Expires", "0");
                    return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(resource.contentLength()).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
                }
                logger.error("File not found at this path: {}", (Object)path);
                return ResponseEntity.notFound().build();
            }
            logger.error("Null data found at this id {} ", (Object)uuid);
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            logger.error("Error occurred while downloading file: {}", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/playFile"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> playDirectFile(@RequestParam(value="fileName") String file, @RequestHeader(value="Range", required=false) String rangeHeader) {
        try {
            long rangeEnd;
            String contentType;
            String encodedFilePath = URLEncoder.encode(file, StandardCharsets.UTF_8.name());
            String decodedFilePath = URLDecoder.decode(encodedFilePath, StandardCharsets.UTF_8.name());
            Path filePath = Paths.get(decodedFilePath, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                logger.error("File not found: {}", (Object)decodedFilePath);
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            Long fileSize = Files.size(filePath);
            if (decodedFilePath.toLowerCase().endsWith(".wav")) {
                contentType = "audio/wav";
            } else if (decodedFilePath.toLowerCase().endsWith(".mp3")) {
                contentType = "audio/mp3";
            } else {
                logger.error("Unsupported file format: {}", (Object)decodedFilePath);
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.add("Content-Type", contentType);
            if (rangeHeader == null) {
                responseHeaders.add("Content-Length", fileSize.toString());
                StreamingResponseBody responseStream = os -> {
                    try (RandomAccessFile fileReader = new RandomAccessFile(decodedFilePath, "r");){
                        int bytesRead;
                        byte[] buffer = new byte[8192];
                        while ((bytesRead = fileReader.read(buffer)) != -1) {
                            os.write(buffer, 0, bytesRead);
                        }
                        os.flush();
                    }
                };
                return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            String[] ranges = rangeHeader.split("-");
            long rangeStart = Long.parseLong(ranges[0].substring(6));
            long l = rangeEnd = ranges.length > 1 ? Long.parseLong(ranges[1]) : fileSize - 1L;
            if (rangeEnd >= fileSize) {
                rangeEnd = fileSize - 1L;
            }
            responseHeaders.add("Accept-Ranges", "bytes");
            responseHeaders.add("Content-Range", "bytes " + rangeStart + "-" + rangeEnd + "/" + fileSize);
            responseHeaders.add("Content-Length", String.valueOf(rangeEnd - rangeStart + 1L));
            long _rangeEnd = rangeEnd;
            StreamingResponseBody responseStream = os -> {
                try (RandomAccessFile fileReader = new RandomAccessFile(decodedFilePath, "r");){
                    int bytesRead;
                    fileReader.seek(rangeStart);
                    byte[] buffer = new byte[8192];
                    for (long bytesLeft = _rangeEnd - rangeStart + 1L; bytesLeft > 0L && (bytesRead = fileReader.read(buffer, 0, (int)Math.min((long)buffer.length, bytesLeft))) != -1; bytesLeft -= (long)bytesRead) {
                        os.write(buffer, 0, bytesRead);
                    }
                    os.flush();
                }
            };
            return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.PARTIAL_CONTENT);
        }
        catch (IOException e) {
            logger.error("Error accessing file: {}", (Object)file, (Object)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/download/tar/{id}"})
    public ResponseEntity<Resource> downloadFile(@PathVariable String id, @RequestHeader HttpHeaders headers) {
        try {
            Optional tarFileOptional = this.pdfReportRepository.findById((Object)id);
            if (tarFileOptional.isPresent()) {
                String path = ((PdfReportFilters)tarFileOptional.get()).getPdfLocation();
                Path filePath = Paths.get(path.trim(), new String[0]);
                UrlResource resource = new UrlResource(filePath.toUri());
                if (!resource.exists()) {
                    return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
                }
                long fileSize = Files.size(filePath);
                List ranges = headers.getRange();
                if (ranges.isEmpty()) {
                    return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + resource.getFilename() + "\""})).header("Content-Length", new String[]{String.valueOf(fileSize)})).body((Object)resource);
                }
                HttpRange range = (HttpRange)ranges.get(0);
                long start = range.getRangeStart(fileSize);
                long end = range.getRangeEnd(fileSize);
                byte[] data = Files.readAllBytes(filePath.subpath((int)start, (int)end + 1));
                return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.PARTIAL_CONTENT).header("Content-Disposition", new String[]{"attachment; filename=\"" + resource.getFilename() + "\""})).header("Content-Range", new String[]{"bytes " + start + "-" + end + "/" + fileSize})).header("Content-Length", new String[]{String.valueOf(data.length)})).body((Object)resource);
            }
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/downloadCSVFile/{uuid}"})
    public ResponseEntity<Resource> downloadRecordingFile(@PathVariable(value="uuid") String uuid) {
        try {
            String path = null;
            path = this.leadSummaryViewService.getFile(uuid);
            if (path != null) {
                Path filePath = Paths.get(path, new String[0]);
                FileSystemResource resource = new FileSystemResource(filePath.toFile());
                if (resource.exists()) {
                    HttpHeaders headers = new HttpHeaders();
                    headers.add("Content-Disposition", "attachment; filename=\"" + resource.getFilename() + "\"");
                    headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
                    headers.add("Pragma", "no-cache");
                    headers.add("Expires", "0");
                    return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(resource.contentLength()).contentType(MediaType.parseMediaType((String)"text/csv")).body((Object)resource);
                }
                logger.error("File not found at this path: {}", (Object)path);
                return ResponseEntity.notFound().build();
            }
            logger.error("Null data found at this id {} ", (Object)uuid);
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            logger.error("Error occurred while downloading file: {}", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/download/defaultTar"})
    public ResponseEntity<byte[]> downloadTarByFilePath(@RequestParam(value="filePath") String tarFilePath) {
        File file = new File(tarFilePath);
        if (file.exists()) {
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
                headers.setContentDispositionFormData("attachment", file.getName());
                Path path = Paths.get(tarFilePath, new String[0]);
                byte[] data = Files.readAllBytes(path);
                return new ResponseEntity((Object)data, (MultiValueMap)headers, HttpStatus.OK);
            }
            catch (IOException e) {
                e.printStackTrace();
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/mediaCenter/play/{language}/{fileName}"})
    public ResponseEntity<Resource> playAudioFile(@PathVariable(value="language") String language, @PathVariable(value="fileName") String fileName) {
        String pathToFile = "/usr/local/freeswitch/sounds/" + language + "/" + fileName;
        Path filePath = Paths.get(pathToFile, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0]) || !Files.isReadable(filePath)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
        }
        try {
            UrlResource resource = new UrlResource(filePath.toUri());
            return ResponseEntity.ok().contentType(MediaTypeFactory.getMediaType((Resource)resource).orElse(MediaType.APPLICATION_OCTET_STREAM)).body((Object)resource);
        }
        catch (MalformedURLException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GetMapping(value={"/voiceLogger/play/{id}"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> playVoicePickerAudioAndVideo(@PathVariable(value="id") String id, @RequestHeader(value="Range", required=false) String rangeHeader) {
        try {
            String contentType;
            String path = this.voiceLoggerService.getFile(id);
            String recordingFileType = this.voiceLoggerService.getRecordingFileType(id);
            if (path == null) {
                logger.error("File path not found for id {}", (Object)id);
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            if (recordingFileType == null) {
                logger.error("Recording file type is null for id {}", (Object)id);
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            String filePathString = path;
            Path filePath = Paths.get(path, new String[0]);
            Long fileSize = Files.size(filePath);
            byte[] buffer = new byte[4024];
            HttpHeaders responseHeaders = new HttpHeaders();
            if ("audio".equalsIgnoreCase(recordingFileType)) {
                if (filePathString.endsWith(".mp3")) {
                    contentType = "audio/mp3";
                } else {
                    if (!filePathString.endsWith(".wav")) {
                        logger.error("Unsupported audio format for file id {}", (Object)id);
                        return new ResponseEntity(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
                    }
                    contentType = "audio/wav";
                }
            } else {
                if (!"video".equalsIgnoreCase(recordingFileType)) {
                    logger.error("Invalid recording file type for id {}", (Object)id);
                    return new ResponseEntity(HttpStatus.BAD_REQUEST);
                }
                if (!filePathString.endsWith(".mp4")) {
                    logger.error("Unsupported video format for file id {}", (Object)id);
                    return new ResponseEntity(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
                }
                contentType = "video/mp4";
            }
            if (rangeHeader == null) {
                responseHeaders.add("Content-Type", contentType);
                responseHeaders.add("Content-Length", fileSize.toString());
                StreamingResponseBody responseStream = os -> {
                    long pos;
                    RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                    file.seek(pos);
                    for (pos = 0L; pos < fileSize - 1L; pos += (long)buffer.length) {
                        file.read(buffer);
                        os.write(buffer);
                    }
                    os.flush();
                    file.close();
                };
                return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            String[] ranges = rangeHeader.split("-");
            Long rangeStart = Long.parseLong(ranges[0].substring(6));
            Long rangeEnd = ranges.length > 1 ? Long.valueOf(Long.parseLong(ranges[1])) : Long.valueOf(fileSize - 1L);
            if (fileSize < rangeEnd) {
                rangeEnd = fileSize - 1L;
            }
            String contentLength = String.valueOf(rangeEnd - rangeStart + 1L);
            responseHeaders.add("Content-Type", contentType);
            responseHeaders.add("Content-Length", contentLength);
            responseHeaders.add("Accept-Ranges", "bytes");
            responseHeaders.add("Content-Range", "bytes " + rangeStart + "-" + rangeEnd + "/" + fileSize);
            Long _rangeEnd = rangeEnd;
            StreamingResponseBody responseStream = os -> {
                long pos;
                RandomAccessFile file = new RandomAccessFile(filePathString, "r");
                file.seek(pos);
                for (pos = rangeStart.longValue(); pos < _rangeEnd; pos += (long)buffer.length) {
                    file.read(buffer);
                    os.write(buffer);
                }
                os.flush();
                file.close();
            };
            return new ResponseEntity((Object)responseStream, (MultiValueMap)responseHeaders, HttpStatus.PARTIAL_CONTENT);
        }
        catch (FileNotFoundException e) {
            logger.error("Unable to find file for id {}", (Object)id, (Object)e);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (IOException e) {
            logger.error("Unable to transfer file for id {}", (Object)id, (Object)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/upload"})
    public ResponseEntity<RequestResponse> uploadFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="deviceId", required=true) String deviceId, @RequestParam(value="username", required=false) String username) {
        RequestResponse requestResponse = new RequestResponse();
        if (file.isEmpty()) {
            requestResponse.setStatus(Constants.Error.BAD_INPUT_DATA);
            requestResponse.setMessage("File is empty");
            requestResponse.setMessageDetail("No file was uploaded");
            return ResponseEntity.badRequest().body((Object)requestResponse);
        }
        if (!StringUtils.hasLength((String)username)) {
            username = "unknown";
        }
        try {
            String originalFilename;
            LocalDate now = LocalDate.now();
            String year = String.valueOf(now.getYear());
            String month = String.format("%02d", now.getMonthValue());
            String day = String.format("%02d", now.getDayOfMonth());
            Path baseDir = Paths.get("/var/log/coralswitch/softswitch/PPDR-client/", year, month, day);
            if (!Files.exists(baseDir, new LinkOption[0])) {
                Files.createDirectories(baseDir, new FileAttribute[0]);
            }
            String fileExtension = (originalFilename = file.getOriginalFilename()) != null && originalFilename.contains(".") ? originalFilename.substring(originalFilename.lastIndexOf(46)) : "";
            long currentEpoch = Instant.now().getEpochSecond();
            String newFileName = String.format("%s.%s.%d%s", deviceId, username, currentEpoch, fileExtension);
            Path filePath = baseDir.resolve(newFileName);
            try (InputStream inputStream = file.getInputStream();){
                Files.copy(inputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
            }
            requestResponse.setStatus(Constants.Error.OK);
            requestResponse.setMessage("File uploaded");
            requestResponse.setMessageDetail("File uploaded and data saved successfully");
            requestResponse.setData(null);
            return ResponseEntity.ok((Object)requestResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
            requestResponse.setStatus(Constants.Error.ERROR);
            requestResponse.setMessage("Error uploading file");
            requestResponse.setMessageDetail(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)requestResponse);
        }
    }

    @GetMapping(value={"/download"})
    public ResponseEntity<Resource> downloadFile(@RequestParam(value="filePath") String filePath) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            UrlResource resource = new UrlResource(path.toUri());
            if (!resource.exists()) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            String contentType = "application/octet-stream";
            String fileName = path.getFileName().toString();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + fileName + "\""})).body((Object)resource);
        }
        catch (MalformedURLException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(null);
        }
    }

    @PostMapping(value={"/floor/requestPTT"})
    public ResponseEntity<RequestResponse> requestPtt(HttpServletRequest request) throws Exception {
        RequestResponse returnValue = this.conferenceService.requestPtt(request, "requestPTT");
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/floor/releasePTT"})
    public ResponseEntity<RequestResponse> releasePtt(HttpServletRequest request) throws Exception {
        RequestResponse returnValue = this.conferenceService.requestPtt(request, "releasePTT");
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/generateOtp"})
    public ResponseEntity<RequestResponse> generateOtp(@RequestBody GenerateOtpModel data) {
        RequestResponse returnValue = this.userAuthenticationService.generateOTP(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/loginByOtp"})
    public ResponseEntity<RequestResponse> loginUserByOtp(@RequestBody GenerateOtpModel data, HttpServletRequest request) throws Exception {
        RequestResponse returnValue = this.userAuthenticationService.loginByNumberAndOtp(data, request);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

