/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.severity.service;

import com.coraltele.db.telemetry.main.entity.Severity;
import com.coraltele.db.telemetry.main.repository.SeverityRepository;
import com.coraltele.db.telemetry.main.specification.SeveritySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.severity.model.SeverityModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class SeverityService {
    private static final Logger logger = LogManager.getLogger(SeverityService.class);
    @Autowired
    SeverityRepository severityRepository;

    public RequestResponse createData(SeverityModel data) {
        logger.debug("Create new Severity : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Severity severity = new Severity();
            severity.setColor(data.getColor());
            severity.setSeverityLevel(data.getSeverityLevel());
            severity.setSeverityName(data.getSeverityName());
            this.severityRepository.save((Object)severity);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Severity Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create Severity");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(SeverityModel data) {
        logger.debug("Update Severity {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional severity = this.severityRepository.findById(data.getId());
        if (!severity.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Severity Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getColor() != null) {
            ((Severity)severity.get()).setColor(data.getColor());
        }
        if (data.getSeverityLevel() != null) {
            ((Severity)severity.get()).setSeverityLevel(data.getSeverityLevel());
        }
        if (data.getSeverityName() != null) {
            ((Severity)severity.get()).setSeverityName(data.getSeverityName());
        }
        this.severityRepository.save(severity.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Severity Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteSeverityById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (String ids : data.getStringId()) {
            Optional severity = this.severityRepository.findById(ids);
            if (severity.isPresent()) {
                addValue.add(severity.get());
                this.severityRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllSeverityByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = SeveritySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.severityRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.severityRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = this.severityRepository.findAll();
        ArrayList<SeverityModel> addValue = new ArrayList<SeverityModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Severity severity : list) {
            SeverityModel data = new SeverityModel();
            data.setColor(severity.getColor());
            data.setId(severity.getId());
            data.setSeverityLevel(severity.getSeverityLevel());
            data.setSeverityName(severity.getSeverityName());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

