/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.lastNAgentCDR.controller;

import com.coraltele.db.telemetry.main.entity.LastNAgentCDR;
import com.coraltele.db.telemetry.main.repository.LastNAgentCDRRepository;
import com.coraltele.db.telemetry.main.specification.LastNAgentCDRSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.lastNAgentCDR.service.LastNAgentCDRService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/lastAgentCdr"})
@RestController
public class LastNAgentCDRController {
    private static final Logger logger = LogManager.getLogger(LastNAgentCDRController.class);
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    @Autowired
    LastNAgentCDRService lastNAgentCDRService;
    @Autowired
    LastNAgentCDRRepository lastNAgentCDRRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.lastNAgentCDRService.getAllByFilter(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for login-logout user status--");
            Specification filters = LastNAgentCDRSpecification.generateFilters((SearchRequest)searchRequestData, (Principal)principal);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.lastNAgentCDRRepository.findAll(filters, sort) : this.lastNAgentCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (LastNAgentCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for login-logout user status", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading login-logout user status CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(LastNAgentCDR item, String columnName) {
        switch (columnName) {
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "campaignName": {
                return this.checkNull((Object)item.getCampaignName());
            }
            case "agentTalkedTo": {
                return this.checkNull((Object)item.getAgentTalkedTo());
            }
            case "startTime": {
                return this.checkNull(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getStartTime()));
            }
            case "talkDuration": {
                return this.checkNull((Object)item.getTalkDuration());
            }
            case "agentName": {
                return this.checkNull((Object)item.getAgentName());
            }
            case "fullName": {
                return this.checkNull((Object)item.getFullName());
            }
            case "leadName": {
                return this.checkNull((Object)item.getLeadName());
            }
            case "answerTime": {
                return this.checkNull(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getAnswerTime()));
            }
            case "second10": {
                return this.checkNull((Object)item.getSecond10());
            }
            case "second20": {
                return this.checkNull((Object)item.getSecond20());
            }
            case "second30": {
                return this.checkNull((Object)item.getSecond30());
            }
            case "second40": {
                return this.checkNull((Object)item.getSecond40());
            }
            case "second50": {
                return this.checkNull((Object)item.getSecond50());
            }
            case "second60": {
                return this.checkNull((Object)item.getSecond60());
            }
            case "recordingFile": {
                return this.checkNull((Object)item.getRecordingFile());
            }
            case "callDirection": {
                return this.checkNull((Object)item.getCallDirection());
            }
            case "isMissed": {
                return this.checkNull((Object)item.getIsMissed());
            }
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "recordType": {
                return this.checkNull((Object)item.getRecordType());
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    static {
        columnMappings.put("queueName", "Queue Name");
        columnMappings.put("campaignName", "Campaign Name");
        columnMappings.put("agentTalkedTo", "Customer Number");
        columnMappings.put("startTime", "Start Time");
        columnMappings.put("talkDuration", "Duration");
        columnMappings.put("agentName", "Agent id");
        columnMappings.put("fullName", "Agent Name");
        columnMappings.put("answerTime", "Answer Time");
        columnMappings.put("leadName", "Lead Name");
        columnMappings.put("second10", "Second 10");
        columnMappings.put("second20", "Second 20");
        columnMappings.put("second30", "Second 30");
        columnMappings.put("second40", "Second 40");
        columnMappings.put("second50", "Second 50");
        columnMappings.put("second60", "Second 60");
        columnMappings.put("recordingFile", "Recording File");
        columnMappings.put("callDirection", "call Direction");
        columnMappings.put("isMissed", "Missed Call");
        columnMappings.put("queue", "Queue Id");
        columnMappings.put("recordType", "Record Type");
    }
}

