/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.discoveryIp.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.telemetry.main.discoveryIp.model.DiscoveryIpModel;
import com.coraltele.service.telemetry.main.discoveryIp.model.IpListModel;
import com.coraltele.service.telemetry.main.discoveryIp.service.DiscoveryIpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/discoverIp"})
@RestController
public class DiscoveryIpController {
    @Autowired
    private DiscoveryIpService discoveryService;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getDiscoveryIpByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.discoveryService.getDiscoveryIpByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateIsFalse(@RequestBody IpListModel dto) {
        RequestResponse returnValue = this.discoveryService.updateIsFalse(dto.getIpList());
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody DiscoveryIpModel data) {
        RequestResponse returnValue = this.discoveryService.createData(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

