/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.customerCDR.controller;

import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.db.telemetry.main.entity.CustomerCDR;
import com.coraltele.db.telemetry.main.entity.view.LastAbandonedView;
import com.coraltele.db.telemetry.main.repository.CustomerCDRRepository;
import com.coraltele.db.telemetry.main.repository.LastAbandonedViewRepository;
import com.coraltele.db.telemetry.main.specification.CustomerCDRSpecification;
import com.coraltele.db.telemetry.main.specification.CustomerCDRSpecificationNew;
import com.coraltele.db.telemetry.main.specification.LastAbandonedRecordsSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResultModel;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.customerCDR.service.CustomerCDRService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/customerCDR"})
@RestController
public class CustomerCDRController {
    private static final Logger logger = LogManager.getLogger(CustomerCDRController.class);
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    CustomerCDRService customerCDRService;
    @Autowired
    CustomerCDRRepository customerCDRRepository;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    LastAbandonedViewRepository lastAbandonedViewRepository;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    @Autowired
    AgentRepository agentRepository;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> columnMappingsFoCallerCallData;
    private static final ConcurrentHashMap<String, String> columnMappingsLastAbandonedRecords;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.customerCDRService.getAllByFilter(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllCustomer(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.customerCDRService.getAllByFilterForQueueTimeInterval(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for Customer-CDR--");
            boolean teamLeaderUser = false;
            if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = CustomerCDRSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.customerCDRRepository.findAll(filters, sort) : this.customerCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (CustomerCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for login-logout user status", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading login-logout user status CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(CustomerCDR item, String columnName) {
        switch (columnName) {
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "queueStrategy": {
                return this.checkNull((Object)item.getQueueStrategy());
            }
            case "queueType": {
                return this.checkNull((Object)item.getQueueType());
            }
            case "callDirection": {
                return this.checkNull((Object)item.getCallDirection());
            }
            case "answeredBy": {
                return this.checkNull((Object)item.getAnsweredBy());
            }
            case "answeredByName": {
                return this.checkNull((Object)item.getAnsweredByName());
            }
            case "agentTalkedTo": {
                return this.checkNull((Object)item.getAgentTalkedTo());
            }
            case "customerName": {
                return this.checkNull((Object)item.getCustomerName());
            }
            case "startTime": {
                return this.formatNullableDate(item.getStartTime());
            }
            case "endTime": {
                return this.formatNullableDate(item.getEndTime());
            }
            case "answerTime": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getAnswerTime());
            }
            case "waitTime": {
                return this.checkNull((Object)item.getWaitTime());
            }
            case "status": {
                return this.checkNull((Object)item.getStatus());
            }
            case "agentTalkTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getAgentTalkTime()));
            }
            case "callType": {
                return this.checkNull((Object)item.getCallType());
            }
            case "pulse": {
                return this.checkNull((Object)item.getPulse());
            }
            case "transferType": {
                return this.checkNull((Object)item.getTransferType());
            }
            case "transferBy": {
                return this.checkNull((Object)item.getTransferBy());
            }
            case "transferTo": {
                return this.checkNull((Object)item.getTransferTo());
            }
            case "transferStatus": {
                return this.checkNull((Object)item.getTransferStatus());
            }
            case "cost": {
                return this.checkNull((Object)item.getCost());
            }
            case "mos": {
                if (item.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                    return 4.3;
                }
                return item.getMos();
            }
        }
        return null;
    }

    private String formatNullableDate(Long epochMillis) {
        return epochMillis != null ? DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)epochMillis)) : "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/callerCall/list"})
    public ResponseEntity<RequestResponse> getAllByFilterForCallerCallDataAnalysis(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.customerCDRService.getAllByFilterForCallerCallDataAnalysis(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/callerCall/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForCallerCall(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for Caller-Call-Data-");
            boolean teamLeaderUser = false;
            if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = CustomerCDRSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.customerCDRRepository.findAll(filters, sort) : this.customerCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappingsFoCallerCallData.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (CustomerCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValueForCallerCall(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Caller-Call-Data", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Caller-Call-Data CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValueForCallerCall(CustomerCDR item, String columnName) {
        switch (columnName) {
            case "agentTalkedTo": {
                return this.checkNull((Object)item.getAgentTalkedTo());
            }
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "startTime": {
                return this.formatNullableDate(item.getStartTime());
            }
            case "endTime": {
                return this.formatNullableDate(item.getEndTime());
            }
            case "answerTime": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getAnswerTime());
            }
            case "agentTalkTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getAgentTalkTime()));
            }
            case "recordingFile": {
                return this.checkNull((Object)item.getRecordingFile());
            }
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "ccAgent": {
                return this.checkNull((Object)item.getCcAgent());
            }
            case "callDirection": {
                return this.checkNull((Object)item.getCallDirection());
            }
            case "duration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTimeForInteger((Integer)item.getDuration()));
            }
            case "agentFullName": {
                return this.checkNull((Object)item.getAgentFullName());
            }
            case "campaign": {
                return this.checkNull((Object)item.getCampaign());
            }
            case "hangupCause": {
                return this.checkNull((Object)item.getHangupCause());
            }
            case "status": {
                return this.checkNull((Object)item.getStatus());
            }
            case "mos": {
                BigDecimal mos = item.getMos();
                if (mos == null || mos.compareTo(BigDecimal.ZERO) == 0) {
                    return "4.3";
                }
                return this.checkNull((Object)mos);
            }
        }
        return null;
    }

    @PostMapping(value={"/lastAbandoned/list"})
    public ResponseEntity<RequestResponse> getAllByFilterForLastAbandonedRecords(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.customerCDRService.getAllByFilterForLastAbandonedRecords(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/lastAbandoned/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForLastAbandonedRecords(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for Last Abandoned Records-");
            boolean teamLeaderUser = false;
            if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = LastAbandonedRecordsSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.lastAbandonedViewRepository.findAll(filters, sort) : this.lastAbandonedViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappingsLastAbandonedRecords.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (LastAbandonedView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValueForLastAbandonedRecords(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Last Abandoned Records", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Last Abandoned Records CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValueForLastAbandonedRecords(LastAbandonedView item, String columnName) {
        switch (columnName) {
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "startTime": {
                return this.formatNullableDate(item.getStartTime());
            }
            case "campaign": {
                return this.checkNull((Object)item.getCampaign());
            }
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "callId": {
                return this.checkNull((Object)item.getCallId());
            }
            case "customerNumber": {
                return this.checkNull((Object)item.getCustomerNumber());
            }
            case "hangupCause": {
                return this.checkNull((Object)item.getHangupCause());
            }
            case "duration": {
                return this.checkNull((Object)item.getDuration());
            }
            case "ccAgent": {
                return this.checkNull((Object)item.getCcAgent());
            }
            case "destinationName": {
                if (StringUtils.hasText((String)item.getCcAgent())) {
                    Optional agentOptional = this.agentRepository.findByName(item.getCcAgent());
                    if (agentOptional.isPresent()) {
                        return this.checkNull((Object)((Agent)agentOptional.get()).getAgentFullName());
                    }
                    return this.checkNull((Object)"");
                }
                return this.checkNull((Object)"");
            }
        }
        return null;
    }

    @PostMapping(value={"/callerCall/downloadCSV1"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForCallerCall1(@RequestBody SearchResultModel searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for Caller-Call-Data-");
            Specification filters = CustomerCDRSpecificationNew.buildSpecification((SearchResultModel)searchRequestData);
            List filteredData = this.customerCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getSelectedColumns());
                List displayNames = searchRequestData.getSelectedColumns().stream().map(columnName -> columnMappingsFoCallerCallData.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (CustomerCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getSelectedColumns()) {
                        values.add(this.getColumnValueForCallerCall(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Caller-Call-Data", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Caller-Call-Data CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping(value={"/queues"})
    public ResponseEntity<RequestResponse> getQueues() {
        RequestResponse returnValue = this.customerCDRService.getQueueOfCustomerCDR();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/agents"})
    public ResponseEntity<RequestResponse> getAgents() {
        RequestResponse returnValue = this.customerCDRService.getDistinctCcAgentList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/queuesAnswered"})
    public ResponseEntity<RequestResponse> getQueuesAnswered() {
        RequestResponse returnValue = this.customerCDRService.getQueueOfCustomerCDRAnswered();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/agentsAnswered"})
    public ResponseEntity<RequestResponse> getAgentsAnswered() {
        RequestResponse returnValue = this.customerCDRService.getDistinctCcAgentListAnswered();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    static {
        columnMappings.put("queue", "Acd Number");
        columnMappings.put("queueStrategy", "ACD Strategy");
        columnMappings.put("queueType", "QUEUE TYPE");
        columnMappings.put("callDirection", "CALL FROM");
        columnMappings.put("answeredBy", "Answered Operator Extension");
        columnMappings.put("answeredByName", "Answered Operator Name");
        columnMappings.put("agentTalkedTo", "CALLER NUMBER");
        columnMappings.put("customerName", "Caller Name");
        columnMappings.put("startTime", "Start Time");
        columnMappings.put("answerTime", "Answer Time");
        columnMappings.put("waitTime", "Wait Time");
        columnMappings.put("status", "Status");
        columnMappings.put("agentTalkTime", "Talk Time");
        columnMappings.put("callType", "Call Type");
        columnMappings.put("pulse", "Pulse");
        columnMappings.put("transferType", "Transfer Type");
        columnMappings.put("transferBy", "Transferred By");
        columnMappings.put("transferTo", "Transferred To");
        columnMappings.put("transferStatus", "Transfer Status");
        columnMappings.put("cost", "Call Cost");
        columnMappings.put("endTime", "Call End Time");
        columnMappings.put("mos", "MOS");
        columnMappingsFoCallerCallData = new ConcurrentHashMap();
        columnMappingsFoCallerCallData.put("queue", "Queue");
        columnMappingsFoCallerCallData.put("agentTalkedTo", "Caller ID");
        columnMappingsFoCallerCallData.put("startTime", "Start Stamp");
        columnMappingsFoCallerCallData.put("answerTime", "Answer Stamp");
        columnMappingsFoCallerCallData.put("endTime", "End Stamp");
        columnMappingsFoCallerCallData.put("recordingFile", "Recording File");
        columnMappingsFoCallerCallData.put("queueName", "Queue Name");
        columnMappingsFoCallerCallData.put("ccAgent", "Agent ID");
        columnMappingsFoCallerCallData.put("callDirection", "Direction");
        columnMappingsFoCallerCallData.put("duration", "Duration");
        columnMappingsFoCallerCallData.put("agentFullName", "Agent Name");
        columnMappingsFoCallerCallData.put("agentTalkTime", "Talk Time");
        columnMappingsFoCallerCallData.put("campaign", "Campaign Name");
        columnMappingsFoCallerCallData.put("hangupCause", "Hangup Cause");
        columnMappingsFoCallerCallData.put("status", "Call Status");
        columnMappingsFoCallerCallData.put("mos", "MOS");
        columnMappingsLastAbandonedRecords = new ConcurrentHashMap();
        columnMappingsLastAbandonedRecords.put("queue", "Queue");
        columnMappingsLastAbandonedRecords.put("campaign", "Campaign");
        columnMappingsLastAbandonedRecords.put("queueName", "Queue Name");
        columnMappingsLastAbandonedRecords.put("callId", "Caller id");
        columnMappingsLastAbandonedRecords.put("customerNumber", "Destination");
        columnMappingsLastAbandonedRecords.put("startTime", "Start Stamp");
        columnMappingsLastAbandonedRecords.put("hangupCause", "Hangup cause");
        columnMappingsLastAbandonedRecords.put("duration", "Duration");
        columnMappingsLastAbandonedRecords.put("ccAgent", "Agent");
        columnMappingsLastAbandonedRecords.put("destinationName", "Agent FullName");
    }
}

