/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.coralnms.category.service;

import com.coraltele.db.telemetry.coralnms.entity.Category;
import com.coraltele.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.db.telemetry.coralnms.specification.CategorySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.coralnms.category.model.CategoryModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CategoryService {
    private static final Logger logger = LogManager.getLogger(CategoryService.class);
    @Autowired
    CategoryRepository categoryRepository;

    public RequestResponse createData(CategoryModel data) {
        logger.debug("create new Category : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Category category = new Category();
            category.setCode(data.getCode());
            category.setDescription(data.getDescription());
            category.setManagementURL(data.getManagementURL());
            if (data.getManagementURL() == null || data.getManagementURL().equals("")) {
                category.setHasManagementInterface(Boolean.valueOf(false));
            } else {
                category.setHasManagementInterface(Boolean.valueOf(true));
            }
            category.setHasSelfDashboard(data.getHasSelfDashboard());
            category.setHeight(data.getHeight());
            category.setImageName(data.getImageName());
            category.setWidth(data.getWidth());
            category.setEmailId(data.getEmailId());
            category.setMobileNo(data.getMobileNo());
            category.setSendEmail(data.getSendEmail());
            category.setSendSMS(data.getSendSMS());
            category.setSvgIcon(data.getSvgIcon());
            category.setProductClass(data.getProductClass());
            this.categoryRepository.save((Object)category);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("category created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create category");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(CategoryModel data) {
        logger.debug("Update category {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional category = this.categoryRepository.findById(data.getId());
        if (!category.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("category not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCode() != null) {
            ((Category)category.get()).setCode(data.getCode());
        }
        if (data.getDescription() != null) {
            ((Category)category.get()).setDescription(data.getDescription());
        }
        if (data.getHeight() != null) {
            ((Category)category.get()).setHeight(data.getHeight());
        }
        if (data.getImageName() != null) {
            ((Category)category.get()).setImageName(data.getImageName());
        }
        if (data.getManagementURL() != null) {
            ((Category)category.get()).setManagementURL(data.getManagementURL());
        }
        if (data.getHasManagementInterface() != null) {
            ((Category)category.get()).setHasManagementInterface(data.getHasManagementInterface());
        }
        if (data.getHasSelfDashboard() != null) {
            ((Category)category.get()).setHasSelfDashboard(data.getHasSelfDashboard());
        }
        if (data.getWidth() != null) {
            ((Category)category.get()).setWidth(data.getWidth());
        }
        if (data.getEmailId() != null) {
            ((Category)category.get()).setEmailId(data.getEmailId());
        }
        if (data.getMobileNo() != null) {
            ((Category)category.get()).setMobileNo(data.getMobileNo());
        }
        if (data.getSendEmail() != null) {
            ((Category)category.get()).setSendEmail(data.getSendEmail());
        }
        if (data.getSendSMS() != null) {
            ((Category)category.get()).setSendSMS(data.getSendSMS());
        }
        if (data.getSvgIcon() != null) {
            ((Category)category.get()).setSvgIcon(data.getSvgIcon());
        }
        if (data.getProductClass() != null) {
            ((Category)category.get()).setProductClass(data.getProductClass());
        }
        this.categoryRepository.save(category.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("category Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteCategoryById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional category = this.categoryRepository.findById(Integer.valueOf(ids));
            if (category.isPresent()) {
                addValue.add(category.get());
                this.categoryRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("records has been deleted");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllCategoryByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CategorySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.categoryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.categoryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = this.categoryRepository.findAll();
        ArrayList<CategoryModel> addValue = new ArrayList<CategoryModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Category category : list) {
            CategoryModel data = new CategoryModel();
            data.setId(category.getId());
            data.setCode(category.getCode());
            data.setDescription(category.getDescription());
            data.setHasManagementInterface(category.getHasManagementInterface());
            data.setHasSelfDashboard(category.getHasSelfDashboard());
            data.setHeight(category.getHeight());
            data.setImageName(category.getImageName());
            data.setManagementURL(category.getManagementURL());
            data.setWidth(category.getWidth());
            data.setEmailId(category.getEmailId());
            data.setMobileNo(category.getMobileNo());
            data.setSendEmail(category.getSendEmail());
            data.setSendSMS(category.getSendSMS());
            data.setSvgIcon(category.getSvgIcon());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getById(Integer id) {
        RequestResponse returnValue = new RequestResponse();
        Optional category = this.categoryRepository.findById(id);
        if (category.isPresent()) {
            CategoryModel data = new CategoryModel();
            data.setId(((Category)category.get()).getId());
            data.setCode(((Category)category.get()).getCode());
            data.setDescription(((Category)category.get()).getDescription());
            data.setHasManagementInterface(((Category)category.get()).getHasManagementInterface());
            data.setHasSelfDashboard(((Category)category.get()).getHasSelfDashboard());
            data.setHeight(((Category)category.get()).getHeight());
            data.setImageName(((Category)category.get()).getImageName());
            data.setManagementURL(((Category)category.get()).getManagementURL());
            data.setWidth(((Category)category.get()).getWidth());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setData((Object)data);
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
        returnValue.setMessage("Unable to return value");
        returnValue.setMessageDetail("Records not found");
        return returnValue;
    }
}

