/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.extGroupMaster.service;

import com.coraltele.db.telephony.pbx.entity.ExtGroupMaster;
import com.coraltele.db.telephony.pbx.repository.ExtGroupMasterRepository;
import com.coraltele.db.telephony.pbx.specification.ExtGroupSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.extGroupMaster.model.ExtGroupModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ExtGroupMasterService {
    private static final Logger logger = LogManager.getLogger(ExtGroupMasterService.class);
    @Autowired
    ExtGroupMasterRepository extGroupMasterRepository;

    public RequestResponse createExtGroup(ExtGroupModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            ExtGroupMaster extGroupMaster = new ExtGroupMaster();
            extGroupMaster.setGroupCode(data.getGroupCode());
            extGroupMaster.setGroupName(data.getGroupName());
            this.extGroupMasterRepository.save((Object)extGroupMaster);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Data created successfully");
            logger.info("Extension group created.");
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Data created successfully");
            logger.error("Extension group created.,," + e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateById(ExtGroupModel data) {
        logger.debug("Update Extension Group {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional extGroup = this.extGroupMasterRepository.findById(data.getId());
        if (!extGroup.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Extension Group Not Found");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        if (data.getGroupCode() != null) {
            ((ExtGroupMaster)extGroup.get()).setGroupCode(data.getGroupCode());
        }
        if (data.getGroupName() != null) {
            ((ExtGroupMaster)extGroup.get()).setGroupName(data.getGroupName());
        }
        this.extGroupMasterRepository.save(extGroup.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Extension Group Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteExtGroup(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional extGroup = this.extGroupMasterRepository.findById(ids);
            if (extGroup.isPresent()) {
                addValue.add(extGroup.get());
                this.extGroupMasterRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.extGroupMasterRepository.findAll();
        ArrayList<ExtGroupModel> addValue = new ArrayList<ExtGroupModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ExtGroupMaster extGroup : list) {
            ExtGroupModel data = new ExtGroupModel();
            data.setGroupCode(extGroup.getGroupCode());
            data.setGroupName(extGroup.getGroupName());
            data.setId(extGroup.getId());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getFilterList(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtGroupSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.extGroupMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.extGroupMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

