/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.configJson.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.configJson.service.ConfigJsonService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/configJson"})
@RestController
public class ConfigJsonController {
    @Autowired
    ConfigJsonService configJsonService;

    @PostMapping(value={"create"})
    public ResponseEntity<RequestResponse> createFile(@RequestBody Object config) throws Exception {
        RequestResponse returnValue = this.configJsonService.saveConfig(config);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/getConfigFile"})
    public ResponseEntity<RequestResponse> getConfigJsonFile() throws IOException {
        RequestResponse returnValue = this.configJsonService.getConfigJsonFile();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/saveGeometryData"})
    public ResponseEntity<RequestResponse> createGeometryJson(@RequestBody Object config) throws Exception {
        RequestResponse returnValue = this.configJsonService.saveGeometryData(config);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/getGeometryData"})
    public ResponseEntity<RequestResponse> getGeometryJson() throws IOException {
        RequestResponse returnValue = this.configJsonService.getGeometryData();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

