/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.conferenceSettings.service;

import com.coraltele.db.telephony.pbx.entity.ConferenceSettings;
import com.coraltele.db.telephony.pbx.repository.ConferenceSettingsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.conferenceSettings.model.ConferenceSettingsModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConferenceSettingsService {
    private static final Logger logger = LogManager.getLogger(ConferenceSettingsService.class);
    @Autowired
    ConferenceSettingsRepository conferenceSettingsRepository;

    public RequestResponse createOrUpdateData(ConferenceSettingsModel data, Principal principal) {
        logger.debug("Create or Update ConferenceSettings : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            List list = this.conferenceSettingsRepository.findAll();
            if (list.isEmpty()) {
                ConferenceSettings conferenceSettings = new ConferenceSettings();
                conferenceSettings.setAuthenticationRetry(data.getAuthenticationRetry());
                conferenceSettings.setBeepInterval(data.getBeepInterval());
                conferenceSettings.setCreatedOn(LocalDateTime.now());
                conferenceSettings.setCoralConfGreetingsPath("ivr/default.wav");
                conferenceSettings.setCreatedBy(principal.getName());
                conferenceSettings.setMaxParticipants(data.getMaxParticipants());
                conferenceSettings.setModifiedBy(data.getModifiedBy());
                conferenceSettings.setModifiedOn(data.getModifiedOn());
                conferenceSettings.setRetryCount(data.getRetryCount());
                conferenceSettings.setRetryDelay(data.getRetryDelay());
                conferenceSettings.setRptt(Integer.valueOf(data.getRptt() != false ? 1 : 0));
                conferenceSettings.setVoiceRecognition(Integer.valueOf(data.getVoiceRecognition() != false ? 1 : 0));
                conferenceSettings.setNameAnnouncementRequired(Integer.valueOf(data.getNameAnnouncementRequired() != false ? 1 : 0));
                conferenceSettings.setPasswordRequired(Integer.valueOf(data.getPasswordRequired() != false ? 1 : 0));
                conferenceSettings.setRecording(Integer.valueOf(data.getRecording() != false ? 1 : 0));
                if (data.getConferenceType().equalsIgnoreCase("a")) {
                    conferenceSettings.setConferenceType("a");
                } else {
                    conferenceSettings.setConferenceType("v");
                }
                if (data.getMeetingType() != null) {
                    if (data.getMeetingType().equals("Dial Assisted")) {
                        conferenceSettings.setDialerAssisted(Integer.valueOf(1));
                    } else {
                        conferenceSettings.setDialerAssisted(Integer.valueOf(0));
                    }
                    if (data.getMeetingType().equals("Meet Me Conference")) {
                        conferenceSettings.setMeetMeConference(Integer.valueOf(1));
                    } else {
                        conferenceSettings.setMeetMeConference(Integer.valueOf(0));
                    }
                }
                this.conferenceSettingsRepository.save((Object)conferenceSettings);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("ConferenceSettings Created Successfully");
                logger.info(returnValue.getMessage());
            } else {
                Optional settings = this.conferenceSettingsRepository.findById((Object)data.getId());
                if (data.getBeepInterval() != null) {
                    ((ConferenceSettings)settings.get()).setBeepInterval(data.getBeepInterval());
                }
                if (data.getConferenceType() != null) {
                    if (data.getConferenceType().equals("a")) {
                        ((ConferenceSettings)settings.get()).setConferenceType("a");
                    } else {
                        ((ConferenceSettings)settings.get()).setConferenceType("v");
                    }
                }
                if (data.getCoralConfGreetingsPath() != null) {
                    ((ConferenceSettings)settings.get()).setCoralConfGreetingsPath(data.getCoralConfGreetingsPath());
                }
                if (data.getMeetingType() != null) {
                    if (data.getMeetingType().equals("Dial Assisted")) {
                        ((ConferenceSettings)settings.get()).setDialerAssisted(Integer.valueOf(1));
                    } else {
                        ((ConferenceSettings)settings.get()).setDialerAssisted(Integer.valueOf(0));
                    }
                    if (data.getMeetingType().equals("Meet Me Conference")) {
                        ((ConferenceSettings)settings.get()).setMeetMeConference(Integer.valueOf(1));
                    } else {
                        ((ConferenceSettings)settings.get()).setMeetMeConference(Integer.valueOf(0));
                    }
                }
                if (data.getMaxParticipants() != null) {
                    ((ConferenceSettings)settings.get()).setMaxParticipants(data.getMaxParticipants());
                }
                if (data.getNameAnnouncementRequired() != null) {
                    ((ConferenceSettings)settings.get()).setNameAnnouncementRequired(Integer.valueOf(data.getNameAnnouncementRequired() != false ? 1 : 0));
                }
                if (data.getRetryCount() != null) {
                    ((ConferenceSettings)settings.get()).setRetryCount(data.getRetryCount());
                }
                if (data.getRetryDelay() != null) {
                    ((ConferenceSettings)settings.get()).setRetryDelay(data.getRetryDelay());
                }
                if (data.getVoiceRecognition() != null) {
                    ((ConferenceSettings)settings.get()).setVoiceRecognition(Integer.valueOf(data.getVoiceRecognition() != false ? 1 : 0));
                }
                if (data.getRptt() != null) {
                    ((ConferenceSettings)settings.get()).setRptt(Integer.valueOf(data.getRptt() != false ? 1 : 0));
                }
                if (data.getPasswordRequired() != null) {
                    ((ConferenceSettings)settings.get()).setPasswordRequired(Integer.valueOf(data.getPasswordRequired() != false ? 1 : 0));
                }
                if (data.getRecording() != null) {
                    ((ConferenceSettings)settings.get()).setRecording(Integer.valueOf(data.getRecording() != false ? 1 : 0));
                }
                if (data.getAuthenticationRetry() != null) {
                    ((ConferenceSettings)settings.get()).setAuthenticationRetry(data.getAuthenticationRetry());
                }
                ((ConferenceSettings)settings.get()).setModifiedBy(principal.getName());
                ((ConferenceSettings)settings.get()).setModifiedOn(LocalDateTime.now());
                ((ConferenceSettings)settings.get()).setCoralConfGreetingsPath("ivr/default.wav");
                this.conferenceSettingsRepository.save(settings.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("ConferenceSettings Updated Successfully");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create ConferenceSettings");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = this.conferenceSettingsRepository.findAll();
        ArrayList<ConferenceSettingsModel> addValue = new ArrayList<ConferenceSettingsModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ConferenceSettings conferenceSettings : list) {
            ConferenceSettingsModel data = new ConferenceSettingsModel();
            data.setBeepInterval(conferenceSettings.getBeepInterval());
            data.setCreatedOn(conferenceSettings.getCreatedOn());
            data.setCoralConfGreetingsPath(conferenceSettings.getCoralConfGreetingsPath());
            data.setCreatedBy(conferenceSettings.getCreatedBy());
            data.setId(conferenceSettings.getId());
            data.setMaxParticipants(conferenceSettings.getMaxParticipants());
            data.setModifiedBy(conferenceSettings.getModifiedBy());
            data.setModifiedOn(conferenceSettings.getModifiedOn());
            data.setRecording(Boolean.valueOf(conferenceSettings.getRecording() != 0));
            data.setRetryCount(conferenceSettings.getRetryCount());
            data.setRetryDelay(conferenceSettings.getRetryDelay());
            data.setRptt(Boolean.valueOf(conferenceSettings.getRptt() != 0));
            data.setVoiceRecognition(Boolean.valueOf(conferenceSettings.getVoiceRecognition() != 0));
            data.setNameAnnouncementRequired(Boolean.valueOf(conferenceSettings.getNameAnnouncementRequired() != 0));
            data.setPasswordRequired(Boolean.valueOf(conferenceSettings.getPasswordRequired() != 0));
            data.setAuthenticationRetry(conferenceSettings.getAuthenticationRetry());
            if (conferenceSettings.getMeetMeConference().equals(1)) {
                data.setMeetingType("Meet Me Conference");
            } else if (conferenceSettings.getDialerAssisted().equals(1)) {
                data.setMeetingType("Dial Assisted");
            }
            if (conferenceSettings.getConferenceType().equals("a")) {
                data.setConferenceType("a");
            } else {
                data.setConferenceType("v");
            }
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

