/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.queueTL.service;

import com.coraltele.db.coralapps.callcenter.entity.QueueTL;
import com.coraltele.db.coralapps.callcenter.repository.QueueTLRepository;
import com.coraltele.db.coralapps.callcenter.specification.QueueTLSpecification;
import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.entity.Tiers;
import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.db.coralapps.main.repository.TiersRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.view.TeamLeadUsers;
import com.coraltele.db.users.main.repository.TeamLeadUsersRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queue.service.QueueService;
import com.coraltele.service.coralApps.callcenter.queueTL.model.QueueTLInstanceModel;
import com.coraltele.service.coralApps.callcenter.queueTL.model.QueueTLModel;
import com.coraltele.service.coralApps.callcenter.queueTL.model.TeamLeadUserModel;
import com.coraltele.service.coralApps.main.service.TiersService;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class QueueTLService {
    private static final Logger logger = LogManager.getLogger(QueueTLService.class);
    @Autowired
    QueueTLRepository queueTLRepository;
    @Autowired
    TeamLeadUsersRepository teamLeadUsersRepository;
    @Autowired
    QueueService queueService;
    @Autowired
    UserService userService;
    @Autowired
    TiersRepository tiersRepository;
    @Autowired
    TiersService tiersService;
    @Autowired
    UserRepository userRepository;
    @Autowired
    AgentRepository agentRepository;

    public RequestResponse create(QueueTLModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        for (Integer queue : data.getQueue()) {
            boolean checkAssociation = this.checkQueueAssociationOnCreate(queue, data.getTeamLeaderId());
            if (!checkAssociation) continue;
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Selected queue already Associated");
            returnValue.setMessageDetail("Error for queue:" + queue + ",TL:" + data.getTeamLeaderId());
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        try {
            for (Integer queue : data.getQueue()) {
                QueueTL queueTL = new QueueTL();
                queueTL.setCreatedOn(LocalDateTime.now());
                queueTL.setCreatedBy(principal.getName());
                queueTL.setQueue(queue);
                queueTL.setTeamLeaderId(data.getTeamLeaderId());
                List agentList = this.tiersService.getAgentListByQueueId(queue);
                if (!agentList.isEmpty()) {
                    for (String agentName : agentList) {
                        Optional agentData;
                        Optional userData = this.userRepository.findByUsername(agentName);
                        if (userData.isPresent()) {
                            ((User)userData.get()).setReportingHead(data.getTeamLeaderId());
                            this.userRepository.save(userData.get());
                        }
                        if (!(agentData = this.agentRepository.findByName(agentName)).isPresent()) continue;
                        ((Agent)agentData.get()).setReportingHead(data.getTeamLeaderId());
                        this.agentRepository.save(agentData.get());
                    }
                }
                this.queueTLRepository.save((Object)queueTL);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage(" Registered new data");
            returnValue.setMessageDetail("Data created successfully ");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create new data");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateById(QueueTLModel data, Principal principal) {
        logger.debug("Update queueTL for: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional queueTL = this.queueTLRepository.findById((Object)data.getId());
        if (!queueTL.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("selected data not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (this.checkQueueAssociationOnUpdate(data, (QueueTL)queueTL.get())) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Selected queue already Associated");
            returnValue.setMessageDetail("Error for queue:" + data.getQueueData() + ",TL:" + data.getTeamLeaderId());
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        if (data.getQueue() != null) {
            ((QueueTL)queueTL.get()).setQueue(data.getQueueData());
        }
        if (data.getTeamLeaderId() != null) {
            ((QueueTL)queueTL.get()).setTeamLeaderId(data.getTeamLeaderId());
        }
        ((QueueTL)queueTL.get()).setUpdatedBy(principal.getName());
        ((QueueTL)queueTL.get()).setUpdatedOn(LocalDateTime.now());
        List agentList = this.tiersService.getAgentListByQueueId(data.getQueueData());
        if (!agentList.isEmpty()) {
            for (String agentName : agentList) {
                Optional agentData;
                Optional userData = this.userRepository.findByUsername(agentName);
                if (userData.isPresent()) {
                    ((User)userData.get()).setReportingHead(data.getTeamLeaderId());
                    this.userRepository.save(userData.get());
                }
                if (!(agentData = this.agentRepository.findByName(agentName)).isPresent()) continue;
                ((Agent)agentData.get()).setReportingHead(data.getTeamLeaderId());
                this.agentRepository.save(agentData.get());
            }
        }
        this.queueTLRepository.save(queueTL.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("queueTL updated successfully");
        logger.info("QueueTL updated successfully");
        return returnValue;
    }

    public RequestResponse deleteQueueTL(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional queueTL = this.queueTLRepository.findById((Object)ids);
            if (queueTL.isPresent()) {
                addValue.add(queueTL.get());
                List agentList = this.tiersService.getAgentListByQueueId(((QueueTL)queueTL.get()).getQueue());
                if (!agentList.isEmpty()) {
                    for (String agentName : agentList) {
                        Optional agentData;
                        Optional userData = this.userRepository.findByUsername(agentName);
                        if (userData.isPresent()) {
                            ((User)userData.get()).setReportingHead("");
                            this.userRepository.save(userData.get());
                        }
                        if (!(agentData = this.agentRepository.findByName(agentName)).isPresent()) continue;
                        ((Agent)agentData.get()).setReportingHead("");
                        this.agentRepository.save(agentData.get());
                    }
                }
                this.queueTLRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<QueueTLModel> addValue = new ArrayList<QueueTLModel>();
        List list = this.queueTLRepository.findAll();
        ArrayList<Integer> queue = new ArrayList<Integer>();
        if (list != null && !list.isEmpty()) {
            for (QueueTL queueTL : list) {
                QueueTLModel data = new QueueTLModel();
                queue.add(queueTL.getQueue());
                data.setId(queueTL.getId());
                data.setQueue(queue);
                data.setTeamLeaderId(queueTL.getTeamLeaderId());
                addValue.add(data);
            }
            logger.info("queue TeamLeader list");
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("list of participants");
            returnValue.setData(addValue);
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Empty list of queueTL!");
            returnValue.setData(addValue);
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getQueueTL(Integer queueTLId) {
        RequestResponse returnValue = new RequestResponse();
        Optional data = this.queueTLRepository.findById((Object)queueTLId);
        ArrayList<Integer> queue = new ArrayList<Integer>();
        if (data.isPresent()) {
            QueueTLModel result = new QueueTLModel();
            queue.add(((QueueTL)data.get()).getQueue());
            result.setId(((QueueTL)data.get()).getId());
            result.setQueue(queue);
            result.setTeamLeaderId(((QueueTL)data.get()).getTeamLeaderId());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("data retrieved successfully");
            returnValue.setData((Object)result);
            logger.info("data get successfully of queueTL");
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("unable to find data");
            logger.info("data notpresent of selected queueTL:{}", (Object)queueTLId);
        }
        return returnValue;
    }

    public RequestResponse getAllTeamLead() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<TeamLeadUserModel> addValue = new ArrayList<TeamLeadUserModel>();
        List list = this.teamLeadUsersRepository.findAll();
        if (list != null && !list.isEmpty()) {
            for (TeamLeadUsers teamLeadUsers : list) {
                TeamLeadUserModel data = new TeamLeadUserModel();
                data.setId(teamLeadUsers.getId());
                data.setUserName(teamLeadUsers.getUserName());
                data.setDescription(teamLeadUsers.getDescription());
                addValue.add(data);
            }
            logger.info("TeamLeader list");
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("list of users");
            returnValue.setData(addValue);
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Empty list of team leader!");
            returnValue.setData(addValue);
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getList(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = QueueTLSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.queueTLRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.queueTLRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        logger.info("filter list returned!");
        return returnValue;
    }

    public List<QueueTLInstanceModel> entityToModelConversion(List<QueueTL> queueTL) {
        ArrayList<QueueTLInstanceModel> addValue = new ArrayList<QueueTLInstanceModel>();
        String queueDescription = "";
        for (QueueTL row : queueTL) {
            if (row.getQueue() != null) {
                queueDescription = this.queueService.getQueueDescription(row.getQueue());
            }
            QueueTLInstanceModel data = new QueueTLInstanceModel();
            data.setId(row.getId());
            data.setQueueDescription(queueDescription);
            data.setQueueId(row.getQueue());
            data.setTeamLeaderId(row.getTeamLeaderId());
            addValue.add(data);
        }
        return addValue;
    }

    private boolean checkQueueAssociationOnCreate(Integer queue, String teamLeaderId) {
        List teamLeaderList = this.queueTLRepository.findByTeamLeaderId(teamLeaderId);
        if (!teamLeaderList.isEmpty()) {
            for (QueueTL queueTL : teamLeaderList) {
                if (!queue.equals(queueTL.getQueue())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkQueueAssociationOnUpdate(QueueTLModel data, QueueTL queueTL) {
        List queueTLList;
        if (!data.getQueueData().equals(queueTL.getQueue()) && !(queueTLList = this.queueTLRepository.findByTeamLeaderId(queueTL.getTeamLeaderId())).isEmpty()) {
            for (QueueTL queueTLData : queueTLList) {
                if (!queueTLData.getQueue().equals(data.getQueueData())) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getQueueListByTeamLeader(String teamLeader) {
        ArrayList<String> result = new ArrayList<String>();
        List queueList = this.queueTLRepository.findByTeamLeaderId(teamLeader);
        if (!queueList.isEmpty()) {
            for (QueueTL queueTl : queueList) {
                result.add(this.queueService.getSystemName(queueTl.getQueue()));
            }
        }
        return result;
    }

    public List<Integer> getQueueListByTeamLeaderInt(String teamLeader) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List queueList = this.queueTLRepository.findByTeamLeaderId(teamLeader);
        if (queueList != null && !queueList.isEmpty()) {
            for (QueueTL queueTl : queueList) {
                String systemName;
                if (queueTl == null || queueTl.getQueue() == null || (systemName = this.queueService.getSystemName(queueTl.getQueue())) == null || systemName.isEmpty()) continue;
                try {
                    result.add(Integer.parseInt(systemName));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public List<String> getAgentListByTL(String teamLeader) {
        ArrayList<String> agentList = new ArrayList<String>();
        List queueList = this.queueTLRepository.findByTeamLeaderId(teamLeader);
        if (!queueList.isEmpty()) {
            for (QueueTL queueTl : queueList) {
                List tiersData;
                String systemName = this.queueService.getSystemName(queueTl.getQueue());
                if (systemName == null || !StringUtils.hasText((String)systemName) || (tiersData = this.tiersRepository.findByQueue(systemName)).isEmpty()) continue;
                for (Tiers tiers : tiersData) {
                    agentList.add(tiers.getAgent());
                }
            }
        }
        return agentList;
    }
}

