/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.notification.service;

import com.coraltele.db.billing.main.entity.Notification;
import com.coraltele.db.billing.main.repository.BroadcastMessageDetailRepository;
import com.coraltele.db.billing.main.repository.NotificationRepository;
import com.coraltele.db.telephony.uc.entity.CustomerAccount;
import com.coraltele.db.telephony.uc.repository.CustomerAccountRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationService {
    private static final Logger logger = LogManager.getLogger(NotificationService.class);
    @Autowired
    NotificationRepository notificationRepository;
    @Autowired
    BroadcastMessageDetailRepository broadcastMessageDetailRepository;
    @Autowired
    CustomerAccountRepository customerAccountRepository;

    public RequestResponse createNotification(List<Integer> destinationUser, String loggedUser) {
        logger.debug("Data For Notification {} {}", destinationUser, (Object)loggedUser);
        RequestResponse returnValue = new RequestResponse();
        int maxId = this.broadcastMessageDetailRepository.getMaxId();
        destinationUser.forEach(toUser -> {
            Notification notification = Notification.builder().messageId(Long.valueOf(maxId)).messageType("6").notificationMessage("Broadcast Message Has Been Received From " + loggedUser).loginId(((CustomerAccount)this.customerAccountRepository.findById(toUser).get()).getProfileId()).fromUser(loggedUser).fromUserName(((CustomerAccount)this.customerAccountRepository.findByProfileId(loggedUser).get()).getFirstName()).toUser(((CustomerAccount)this.customerAccountRepository.findById(toUser).get()).getProfileId()).toUserName(((CustomerAccount)this.customerAccountRepository.findById(toUser).get()).getFirstName()).createdOn(LocalDateTime.now()).isMessageNotified(Boolean.valueOf(false)).isMessageRead(Boolean.valueOf(false)).build();
            this.notificationRepository.save((Object)notification);
        });
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Notification Has Been Updated With New Records ");
        logger.info("Records In Notification Has Been Created");
        return returnValue;
    }

    public RequestResponse bulkUpdateNotification(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<Notification> addValue = new ArrayList<Notification>();
        logger.info("list of message updated {}", (Object)data.getId());
        for (Long row : data.getId()) {
            Optional currentRecord = this.notificationRepository.findById(Integer.valueOf(row.intValue()));
            if (!currentRecord.isPresent()) continue;
            Notification dataToSave = (Notification)currentRecord.get();
            dataToSave.setIsMessageRead(Boolean.valueOf(true));
            addValue.add(dataToSave);
        }
        this.notificationRepository.saveAll(addValue);
        returnValue.setMessage("Message Read");
        returnValue.setMessageDetail("successfully updated");
        logger.info(returnValue.getMessage(), (Object)returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse deleteNotification(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional notification = this.notificationRepository.findById(Integer.valueOf(ids.intValue()));
            if (notification.isPresent()) {
                addValue.add(notification.get());
                this.notificationRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("message deleted");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

