/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userToken.service;

import com.coraltele.db.users.main.entity.UserToken;
import com.coraltele.db.users.main.repository.UserTokenRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.user.userToken.model.UserTokenModel;
import java.time.LocalDateTime;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class UserTokenService {
    private static final Logger logger = LogManager.getLogger(UserTokenService.class);
    @Autowired
    UserTokenRepository userTokenRepository;

    public RequestResponse createData(UserTokenModel data, Authentication authentication) {
        logger.debug("create new user token : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        long epochTime = System.currentTimeMillis() / 1000L;
        long validTill = epochTime + 30L;
        try {
            String guidWithToken = this.generateGuidWithToken();
            UserToken userToken = new UserToken();
            userToken.setCreatedBy(data.getCreatedBy());
            userToken.setCreatedOn(LocalDateTime.now());
            userToken.setJwtAuthKey(guidWithToken);
            userToken.setJwtTokenGeneratedTime(Long.valueOf(epochTime));
            userToken.setJwtTokenValidTill(Long.valueOf(validTill));
            userToken.setUsername(authentication.getName());
            userToken.setTokenType(data.getTokenType());
            this.userTokenRepository.save((Object)userToken);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("User Token Created Successfully");
            returnValue.setData((Object)guidWithToken);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create User Token");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public String generateGuidWithToken() {
        UUID uuid = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        String guidWithToken = uuid.toString() + "-JWT-" + uuid2.toString();
        return guidWithToken;
    }
}

