/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.sendNotification.service;

import com.coraltele.db.telemetry.main.entity.EventNotify;
import com.coraltele.db.telemetry.main.repository.EventNotifyRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.service.telemetry.main.sendNotification.model.EventNotificationModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventNotifyService {
    private static final Logger logger = LogManager.getLogger(EventNotifyService.class);
    @Autowired
    EventNotifyRepository eventNotifyRepository;

    public RequestResponse getList(Principal principal) {
        RequestResponse response = new RequestResponse();
        try {
            String loggedInUser = principal.getName();
            List eventNotifyList = this.eventNotifyRepository.findByReadByUserFalseAndEventDestination(loggedInUser);
            ArrayList<EventNotificationModel> responseData = new ArrayList<EventNotificationModel>();
            ObjectMapper objectMapper = new ObjectMapper();
            for (EventNotify event : eventNotifyList) {
                EventNotificationModel responseModel = new EventNotificationModel();
                responseModel.setId(Integer.valueOf(event.getId() != null ? event.getId() : 0));
                responseModel.setEventId(Integer.valueOf(event.getEventId() != null ? event.getEventId() : 0));
                responseModel.setEventUUID(event.getEventUUID() != null ? event.getEventUUID() : "N/A");
                responseModel.setEventMessage(event.getEventMessage() != null ? event.getEventMessage() : "No message available");
                responseModel.setEventSeverity(Integer.valueOf(event.getEventSeverity() != null ? event.getEventSeverity() : 0));
                responseModel.setEventEpoch(Long.valueOf(event.getEventEpoch() != null ? event.getEventEpoch() : 0L));
                responseModel.setEventSource(event.getEventSource() != null ? event.getEventSource() : "Unknown source");
                responseModel.setEventDestination(event.getEventDestination() != null ? event.getEventDestination() : "Unknown destination");
                responseModel.setReadByUser(Boolean.valueOf(event.getReadByUser() != null ? event.getReadByUser() : false));
                String eventData = event.getEventData();
                if (eventData != null && !eventData.isEmpty()) {
                    try {
                        Object parsedData = objectMapper.readValue(eventData, Object.class);
                        responseModel.setEventData(parsedData);
                    }
                    catch (Exception e) {
                        logger.error("Error parsing eventData for event ID {}: {}", (Object)event.getId(), (Object)e.getMessage());
                        responseModel.setEventData((Object)"Invalid event data format");
                    }
                } else {
                    responseModel.setEventData((Object)"No event data available");
                }
                responseData.add(responseModel);
            }
            if (responseData.isEmpty()) {
                response.setStatus(Constants.Error.OK);
                response.setMessage("No unread events found");
                response.setMessageDetail("No unread events found for the user: " + loggedInUser);
            } else {
                response.setStatus(Constants.Error.OK);
                response.setMessage("OK");
                response.setMessageDetail("List retrieved successfully");
                response.setData(responseData);
            }
        }
        catch (Exception e) {
            logger.error("Error while fetching unread events for user: {}", (Object)principal.getName(), (Object)e);
            response.setStatus(Constants.Error.UNKNOWN_ERROR);
            response.setMessage("Error retrieving events");
            response.setMessageDetail("An unexpected error occurred. Please try again later.");
        }
        return response;
    }

    public RequestResponse updateReadStatusByIds(InputIdModel inputIdModel) {
        RequestResponse response = new RequestResponse();
        try {
            List listOfIds = inputIdModel.getIntId();
            List eventNotifies = (List)this.eventNotifyRepository.findAllById((Iterable)listOfIds);
            if (eventNotifies.isEmpty()) {
                response.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                response.setMessage("No records found");
                response.setMessageDetail("No EventNotify records found");
                return response;
            }
            for (EventNotify event : eventNotifies) {
                event.setReadByUser(Boolean.valueOf(true));
            }
            this.eventNotifyRepository.saveAll((Iterable)eventNotifies);
            response.setStatus(Constants.Error.OK);
            response.setMessage("Update successful");
            response.setMessageDetail("The readByUser status has been updated for the provided IDs");
        }
        catch (Exception e) {
            response.setStatus(Constants.Error.UNKNOWN_ERROR);
            response.setMessage("Error updating readByUser status");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }
}

