/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.routeCoordinate.service;

import com.coraltele.db.telemetry.main.entity.Route;
import com.coraltele.db.telemetry.main.entity.RouteCoordinate;
import com.coraltele.db.telemetry.main.repository.RouteCoordinateRepository;
import com.coraltele.db.telemetry.main.repository.RouteRepository;
import com.coraltele.db.telemetry.main.specification.RouteCoordinateSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.routeCoordinate.model.RouteCoordinateModel;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class RouteCoordinateService {
    private static final Logger logger = LogManager.getLogger(RouteCoordinateService.class);
    @Autowired
    private RouteCoordinateRepository routeCoordinateRepository;
    @Autowired
    RouteRepository routeRepository;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = RouteCoordinateSpecification.generateFilters((SearchRequest)searchRequestData, (Principal)principal);
        Sort sort = null;
        if ("asc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if ("desc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "id" : searchRequestData.getSortBy()}).descending();
        }
        List filteredData = sort == null ? this.routeCoordinateRepository.findAll(filters) : this.routeCoordinateRepository.findAll(filters, sort);
        long totalRecords = filteredData.size();
        List responseData = this.entityToModelConversion(filteredData);
        SearchResponse searchResponse = new SearchResponse();
        searchResponse.setCurrentPageData((Object)responseData);
        searchResponse.setTotalRecords(totalRecords);
        returnValue.setData((Object)searchResponse);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<RouteCoordinateModel> entityToModelConversion(List<RouteCoordinate> routes) {
        ArrayList<RouteCoordinateModel> addValue = new ArrayList<RouteCoordinateModel>();
        for (RouteCoordinate row : routes) {
            RouteCoordinateModel data = new RouteCoordinateModel();
            data.setUuid(row.getUuid());
            data.setCreatedBy(row.getCreatedBy());
            if (row.getCreatedOn() != null) {
                data.setCreatedOn(DateFormatUtility.epochToLocalDateTime((Long)row.getCreatedOn()));
            }
            data.setDeviceId(row.getDeviceId());
            data.setExtension(row.getExtension());
            data.setGpsAccuracy(row.getGpsAccuracy());
            data.setId(row.getId());
            data.setLongitude(row.getLongitude());
            if (row.getEpochDate() != null) {
                data.setEpochDate(DateFormatUtility.epochToLocalDateTimeAsString((Long)row.getEpochDate()));
            }
            data.setLatitude(row.getLatitude());
            addValue.add(data);
        }
        return addValue;
    }

    public Route getRouteData(Integer id) {
        Optional route = this.routeRepository.findById((Object)id);
        if (route.isPresent()) {
            return (Route)route.get();
        }
        return null;
    }
}

