/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.queuePerformance.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.entity.AgentCDR;
import com.coraltele.db.telemetry.main.entity.QueuePerformance;
import com.coraltele.db.telemetry.main.repository.AgentCDRRepository;
import com.coraltele.db.telemetry.main.repository.QueuePerformanceRepository;
import com.coraltele.db.telemetry.main.specification.QueuePerformanceSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.background.PdfGeneratorService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.queuePerformance.service.QueuePerformanceService;
import com.coraltele.service.user.service.UserService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="queuePerformanceSummaryPdf")
public class QueuePerformancePdf
implements PdfGeneratorService {
    private static String reportFileName = "Queue Performance Summary";
    private static String reportFileNameDateFormat = "dd_MMMM_yyyy";
    private static String localDateFormat = "dd-MM-yyyy hh:mm:ss a";
    LocalDateTime currentTime = null;
    private static String logoImgPath = "/var/www/html/apple-icon.png";
    private static int noOfColumns = 0;
    private static final Logger logger = LogManager.getLogger(QueuePerformancePdf.class);
    @Autowired
    QueuePerformanceRepository queuePerformanceRepository;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    @Autowired
    PdfPageNumberEvent pageNumberEvent;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    @Autowired
    AgentCDRRepository agentCDRRepository;
    @Autowired
    QueuePerformanceService queuePerformanceService;
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    public void init(LocalDateTime currentTime) {
        try {
            this.pageNumberEvent.initialize(logoImgPath, reportFileName, localDateFormat, currentTime);
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
    }

    public RequestResponse generatePdfReport(SearchRequest searchRequestData, String filePath, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        this.currentTime = LocalDateTime.now();
        this.init(this.currentTime);
        logger.info("Start generating pdf for matched columns:");
        try {
            List queueId = null;
            if (this.userService.checkRoleTL(principal.getName())) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            noOfColumns = searchRequestData.getColumnNames().size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = noOfColumns > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            writer.setPageEvent((PdfPageEvent)this.pageNumberEvent);
            document.open();
            this.addLogoAndDocTitle(document, searchRequestData, Integer.valueOf(noOfColumns));
            if (searchRequestData.advancedFilters != null && !searchRequestData.advancedFilters.isEmpty()) {
                QueuePerformancePdf.addAdvanceFilterRequest((Document)document, (SearchRequest)searchRequestData);
            }
            document.newPage();
            this.createTable(document, noOfColumns, searchRequestData, queueId);
            document.close();
            byte[] pdfBytes = byteArrayOutputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            String filename = this.getPdfNameWithDate();
            this.savePdfToDestination(pdfBytes, filePath);
            headers.setContentDispositionFormData(filename, filename);
            headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
            logger.info("PDF generated successfully and saved to: {}", (Object)filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("File generated and saved successfully");
            returnValue.setData((Object)filePath);
            logger.info("NMS report generated and saved successfully");
            return returnValue;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("failed to download");
            logger.info("NMS report failed to download");
            return returnValue;
        }
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            logger.info("finding logo from location");
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)logoImgPath);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            }
            PdfPCell reportNameCell = new PdfPCell();
            reportNameCell.setHorizontalAlignment(1);
            reportNameCell.setBorder(0);
            Paragraph p1 = new Paragraph(reportFileName, COURIER);
            reportNameCell.addElement((Element)p1);
            PdfPCell dateTimeCell = new PdfPCell();
            dateTimeCell.setHorizontalAlignment(1);
            dateTimeCell.setBorder(0);
            String localDateString = this.currentTime.format(DateTimeFormatter.ofPattern(localDateFormat));
            Paragraph p2 = new Paragraph("Report generated on " + localDateString, COURIER_SMALL);
            dateTimeCell.addElement((Element)p2);
            table.addCell(logoCell);
            table.addCell(reportNameCell);
            table.addCell(dateTimeCell);
            document.add((Element)table);
            logger.info("successfully found logo for pdf");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void createTable(Document document, int noOfColumns, SearchRequest searchRequestData, List<String> queueId) throws DocumentException {
        try {
            logger.info("Starting creation of table for pdf");
            Specification filters = QueuePerformanceSpecification.generateFilters((SearchRequest)searchRequestData, queueId);
            Sort sort = null;
            if (searchRequestData.sortDirection.equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
            } else if (searchRequestData.sortDirection.equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
            }
            List filteredData = sort != null ? this.queuePerformanceRepository.findAll(filters, sort) : this.queuePerformanceRepository.findAll(filters);
            List allAgentCDRs = (List)this.agentCDRRepository.findAll();
            HashMap<String, Set> agentMap = new HashMap<String, Set>();
            for (AgentCDR cdr : allAgentCDRs) {
                if (cdr.getStartTime() == null || cdr.getQueue() == null || cdr.getCallDirection() == null || cdr.getAgentName() == null) continue;
                LocalDate date = Instant.ofEpochSecond(cdr.getStartTime()).atZone(ZoneId.systemDefault()).toLocalDate();
                String key = date + "|" + cdr.getQueue() + "|" + cdr.getCallDirection();
                agentMap.computeIfAbsent(key, k -> new HashSet()).add(cdr.getAgentName());
            }
            Map<String, Integer> agentCountMap = agentMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Set)e.getValue()).size()));
            PdfPTable table = new PdfPTable(searchRequestData.getColumnNames().size());
            for (String columnName : searchRequestData.getColumnNames()) {
                BaseColor lightBlue = new BaseColor(2, 111, 194);
                PdfPCell cell = new PdfPCell(new Phrase((String)columnMappings.get(columnName), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(lightBlue);
                cell.setBorder(0);
                table.addCell(cell);
            }
            table.setHeaderRows(1);
            this.getDbData(table, filteredData, searchRequestData.getColumnNames(), agentCountMap);
            document.add((Element)table);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            logger.error(e2.getMessage());
        }
    }

    private void getDbData(PdfPTable table, List<QueuePerformance> filteredData, List<String> columnNames1, Map<String, Integer> agentCountMap) {
        try {
            BaseColor lightBackground = new BaseColor(230, 230, 230);
            for (int rowIndex = 0; rowIndex < filteredData.size(); ++rowIndex) {
                QueuePerformance queuePerformance = filteredData.get(rowIndex);
                table.setWidthPercentage(100.0f);
                table.getDefaultCell().setHorizontalAlignment(1);
                table.getDefaultCell().setVerticalAlignment(5);
                table.getDefaultCell().setBorder(0);
                if (rowIndex % 2 == 0) {
                    table.getDefaultCell().setBackgroundColor(BaseColor.WHITE);
                } else {
                    table.getDefaultCell().setBackgroundColor(lightBackground);
                }
                for (String columnName : columnNames1) {
                    Duration totalCustomerAgentTalkTime = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(queuePerformance.getTotalCustomerAgentTalkTime())));
                    Duration totalCustomerTime = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(queuePerformance.getTotalCustomerTime())));
                    switch (columnName) {
                        case "queue": {
                            table.addCell(this.getCellValue(queuePerformance.getQueue()));
                            break;
                        }
                        case "queueName": {
                            table.addCell(this.getCellValue(queuePerformance.getQueueName()));
                            break;
                        }
                        case "callDirection": {
                            table.addCell(this.getCellValue(queuePerformance.getCallDirection()));
                            break;
                        }
                        case "recordEpoch": {
                            table.addCell(this.getCellValue(this.dateFormatUtility.epochToLocalDateForLocalTimeZone(queuePerformance.getRecordEpoch()).toString()));
                            break;
                        }
                        case "totalJoined": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getTotalJoined())));
                            break;
                        }
                        case "totalConnectedWithAgent": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getTotalConnectedWithAgent())));
                            break;
                        }
                        case "totalAbandonedAtQueue": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getTotalAbandonedAtQueue())));
                            break;
                        }
                        case "totalCustomerAgentTalkTime": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)totalCustomerAgentTalkTime.getSeconds()));
                            break;
                        }
                        case "totalCustomerTime": {
                            table.addCell(DateFormatUtility.findLocalTime((Long)totalCustomerTime.getSeconds()));
                            break;
                        }
                        case "totalNoContact": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getTotalNoContact())));
                            break;
                        }
                        case "totalWaitTime": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)queuePerformance.getTotalWaitTime())));
                            break;
                        }
                        case "totalAbandonedAtAgent": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getTotalAbandonedAtAgent())));
                            break;
                        }
                        case "answerWaitSecond10": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAnswerWaitSecond10())));
                            break;
                        }
                        case "answerWaitSecond20": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAnswerWaitSecond20())));
                            break;
                        }
                        case "answerWaitSecond30": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAnswerWaitSecond30())));
                            break;
                        }
                        case "answerWaitSecond40": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAnswerWaitSecond40())));
                            break;
                        }
                        case "answerWaitSecond50": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAnswerWaitSecond50())));
                            break;
                        }
                        case "answerWaitSecond60": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAnswerWaitSecond60())));
                            break;
                        }
                        case "greaterAnswerWaitSecond60": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getGreaterAbandonedWaitSecond60())));
                            break;
                        }
                        case "abandonedWaitSecond10": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAbandonedWaitSecond10())));
                            break;
                        }
                        case "abandonedWaitSecond20": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAbandonedWaitSecond20())));
                            break;
                        }
                        case "abandonedWaitSecond30": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAbandonedWaitSecond30())));
                            break;
                        }
                        case "abandonedWaitSecond40": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAbandonedWaitSecond40())));
                            break;
                        }
                        case "abandonedWaitSecond50": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAbandonedWaitSecond50())));
                            break;
                        }
                        case "abandonedWaitSecond60": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAbandonedWaitSecond60())));
                            break;
                        }
                        case "greaterAbandonedWaitSecond60": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getGreaterAbandonedWaitSecond60())));
                            break;
                        }
                        case "averageNumberAgent": {
                            String recordDate = this.dateFormatUtility.epochToLocalDateForLocalTimeZone(queuePerformance.getRecordEpoch()).toString();
                            String avgKey = recordDate + "|" + queuePerformance.getQueue() + "|" + queuePerformance.getCallDirection();
                            Integer avgAgents = agentCountMap.getOrDefault(avgKey, 0);
                            table.addCell(this.getCellValue(String.valueOf(avgAgents)));
                            break;
                        }
                        case "averageAnswerWaitTime": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)queuePerformance.getAverageAnswerWaitTime())));
                            break;
                        }
                        case "totalAbandonedWaitTime": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)queuePerformance.getTotalAbandonedWaitTime())));
                            break;
                        }
                        case "totalAnswerWaitTime": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)queuePerformance.getTotalAnswerWaitTime())));
                            break;
                        }
                        case "averageAbandonedWaitTime": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)queuePerformance.getAverageAbandonedWaitTime())));
                            break;
                        }
                        case "averageTalkTime": {
                            table.addCell(this.getCellValue(DateFormatUtility.findLocalTime((Long)queuePerformance.getAverageTalkTime())));
                            break;
                        }
                        case "servicePercentage": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getServicePercentage())));
                            break;
                        }
                        case "abandonedPercentage": {
                            table.addCell(this.getCellValue(String.valueOf(queuePerformance.getAbandonedPercentage())));
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private String getCellValue(String value) {
        return value != null && !value.isEmpty() ? value : "";
    }

    private static void leaveEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    private String getPdfNameWithDate() {
        String localDateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern(reportFileNameDateFormat));
        return reportFileName + "-" + localDateString + ".pdf";
    }

    private static void addAdvanceFilterRequest(Document document, SearchRequest searchRequestData) throws DocumentException {
        List advancedFilters = searchRequestData.getAdvancedFilters();
        if (advancedFilters != null && !advancedFilters.isEmpty()) {
            Paragraph advancedFilterParagraph = new Paragraph();
            Font boldFont = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
            for (AdvanceFilter advanceFilter : advancedFilters) {
                advancedFilterParagraph.setFont(boldFont);
                if ("from".equals(advanceFilter.getDirection())) {
                    advancedFilterParagraph.add("Record on the basis of " + (String)columnMappings.get(advanceFilter.getFieldName()) + ": From " + advanceFilter.getValue());
                    continue;
                }
                if (!"to".equals(advanceFilter.getDirection())) continue;
                advancedFilterParagraph.add(" to " + advanceFilter.getValue());
                advancedFilterParagraph.add((Element)new Paragraph(""));
            }
            document.add((Element)advancedFilterParagraph);
        }
    }

    private void savePdfToDestination(byte[] pdfBytes, String destinationPath) {
        try (FileOutputStream fos = new FileOutputStream(destinationPath);){
            fos.write(pdfBytes);
            logger.info("PDF saved to: {}", (Object)destinationPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Failed to save PDF to: {}", (Object)destinationPath);
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String filePath) {
        try {
            PdfReportFilters pdfReportFilters = new PdfReportFilters();
            ObjectMapper objectMapper = new ObjectMapper();
            pdfReportFilters.setId(id);
            pdfReportFilters.setReportName(reportFileName);
            pdfReportFilters.setFilterParameters(objectMapper.writeValueAsString((Object)data));
            pdfReportFilters.setCreatedOnDate(this.currentTime);
            pdfReportFilters.setPdfLocation(filePath);
            pdfReportFilters.setStatus("InProgress");
            this.pdfReportRepository.save((Object)pdfReportFilters);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }

    static {
        columnMappings.put("queue", "Queue ID");
        columnMappings.put("queueName", "Queue Name");
        columnMappings.put("callDirection", "Call Direction");
        columnMappings.put("recordEpoch", "Record DateTime");
        columnMappings.put("totalJoined", "Total Call Offered");
        columnMappings.put("totalConnectedWithAgent", "Total Call Answered");
        columnMappings.put("totalAbandonedAtQueue", "ABD At ACD");
        columnMappings.put("totalCustomerAgentTalkTime", "Total Talk Time");
        columnMappings.put("totalCustomerTime", "Total Customer Time");
        columnMappings.put("totalNoContact", "Total No Answered");
        columnMappings.put("totalWaitTime", "Total Wait Time");
        columnMappings.put("totalAbandonedAtAgent", "ABD At Agent");
        columnMappings.put("answerWaitSecond10", "Ans Wait 10 Second");
        columnMappings.put("answerWaitSecond20", "Ans Wait 20 Second");
        columnMappings.put("answerWaitSecond30", "Ans Wait 30 Second");
        columnMappings.put("answerWaitSecond40", "Ans Wait 40 Second");
        columnMappings.put("answerWaitSecond50", "Ans Wait 50 Second");
        columnMappings.put("answerWaitSecond60", "Ans Wait 60 Second");
        columnMappings.put("greaterAnswerWaitSecond60", "Ans Wait >60 Second");
        columnMappings.put("abandonedWaitSecond10", "ABD Wait 10 Second");
        columnMappings.put("abandonedWaitSecond20", "ABD Wait 20 Second");
        columnMappings.put("abandonedWaitSecond30", "ABD Wait 30 Second");
        columnMappings.put("abandonedWaitSecond40", "ABD Wait 40 Second");
        columnMappings.put("abandonedWaitSecond50", "ABD Wait 50 Second");
        columnMappings.put("abandonedWaitSecond60", "ABD Wait 60 Second");
        columnMappings.put("greaterAbandonedWaitSecond60", "ABD Wait >60 Second");
        columnMappings.put("averageNumberAgent", "Avg No of Agent");
        columnMappings.put("averageAnswerWaitTime", "Avg Ans Wait Time");
        columnMappings.put("totalAbandonedWaitTime", "Total ABD Wait Time");
        columnMappings.put("totalAnswerWaitTime", "Total Ans Wait Time");
        columnMappings.put("averageAbandonedWaitTime", "Avg ABD Wait Time");
        columnMappings.put("averageTalkTime", "Avg Talk Time");
        columnMappings.put("servicePercentage", "Service %");
        columnMappings.put("abandonedPercentage", "Abandoned %");
    }
}

