/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.extensionDetailIn.service;

import com.coraltele.db.telemetry.main.entity.view.BillingCdrOutgoingView;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.db.telemetry.main.repository.BillingCdrIncomingSummaryViewRepository;
import com.coraltele.db.telemetry.main.repository.BillingCdrIncomingViewRepository;
import com.coraltele.db.telemetry.main.repository.BillingCdrOutgoingViewRepository;
import com.coraltele.db.telemetry.main.specification.BillingCdrIncomingSpecification;
import com.coraltele.db.telemetry.main.specification.BillingCdrIncomingSummarySpecification;
import com.coraltele.db.telemetry.main.specification.BillingCdrOutgoingViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.extensionDetailIn.model.ExtensionDetailOutboundModel;
import com.coraltele.service.telemetry.main.extensionDetailIn.model.ExtensionSummaryModel;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ExtensionDetailInService {
    private static final Logger logger = LogManager.getLogger(ExtensionDetailInService.class);
    @Autowired
    BillingCdrIncomingViewRepository billingCdrIncomingViewRepository;
    @Autowired
    BillingCdrIncomingSummarySpecification billingCdrIncomingSummarySpecification;
    @Autowired
    BillingCdrIncomingSpecification billingCdrIncomingSpecification;
    @Autowired
    BillingCdrIncomingSummaryViewRepository billingCdrIncomingSummaryViewRepository;
    @Autowired
    BillingCDRRepository billingCdrRepository;
    @Autowired
    BillingCdrOutgoingViewSpecification BillingCdrSpecification;
    @Autowired
    BillingCdrOutgoingViewRepository viewRpository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = BillingCdrOutgoingViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "callerIdNumber" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "callerIdNumber" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.viewRpository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.viewRpository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ExtensionDetailOutboundModel> entityToModelConversion(List<BillingCdrOutgoingView> report) {
        ArrayList<ExtensionDetailOutboundModel> responseList = new ArrayList<ExtensionDetailOutboundModel>();
        for (BillingCdrOutgoingView row : report) {
            ExtensionDetailOutboundModel data = new ExtensionDetailOutboundModel();
            data.setCallerIdNumber(row.getCallerIdNumber());
            data.setDestinationNumber(row.getDestinationNumber());
            data.setDatetimeIst(row.getDatetimeIst());
            data.setCallType(row.getCallType());
            data.setCoralCallDirection(row.getCoralCallDirection());
            data.setTalkDuration(DateFormatUtility.findLocalTime((Long)row.getTalkDuration()));
            data.setPulse(row.getPulse());
            data.setCost(this.formatAmount(row.getCost()));
            responseList.add(data);
        }
        return responseList;
    }

    public RequestResponse getExtensionSummary(SearchRequest request) {
        List<Object> pageRows;
        int totalPages;
        List allRows;
        String sortDir;
        String sortBy;
        String fromDate = null;
        String toDate = null;
        String extension = null;
        if (request.getAdvancedFilters() != null) {
            for (AdvanceFilter f : request.getAdvancedFilters()) {
                if ("callDate".equalsIgnoreCase(f.getFieldName())) {
                    if ("from".equalsIgnoreCase(f.getDirection())) {
                        fromDate = f.getValue();
                    }
                    if ("to".equalsIgnoreCase(f.getDirection())) {
                        toDate = f.getValue();
                    }
                }
                if (!"extension".equalsIgnoreCase(f.getFieldName())) continue;
                extension = f.getValue();
            }
        }
        LocalDate from = this.parseDate(fromDate);
        LocalDate to = this.parseDate(toDate);
        int pageSize = request.getPageSize() != null && request.getPageSize() > 0 ? request.getPageSize() : 50;
        int page = request.getCurrentPage() != null && request.getCurrentPage() >= 0 ? request.getCurrentPage() : 0;
        String search = request.getSearch();
        if (search != null && (search = search.trim()).isEmpty()) {
            search = null;
        }
        if ((sortBy = request.getSortBy()) == null || sortBy.trim().isEmpty()) {
            sortBy = "extension";
        }
        if ((sortDir = request.getSortDirection()) == null || sortDir.trim().isEmpty()) {
            sortDir = "asc";
        }
        long totalRecords = (allRows = this.billingCdrRepository.getExtensionSummary(from, to, extension, search, sortBy, sortDir)) != null ? (long)allRows.size() : 0L;
        int n = totalPages = pageSize == 0 ? 0 : (int)Math.ceil((double)totalRecords / (double)pageSize);
        if (allRows == null || allRows.isEmpty()) {
            pageRows = Collections.emptyList();
        } else {
            int fromIndex = Math.min(page * pageSize, allRows.size());
            int toIndex = Math.min(fromIndex + pageSize, allRows.size());
            pageRows = allRows.subList(fromIndex, toIndex);
        }
        ArrayList<ExtensionSummaryModel> result = new ArrayList<ExtensionSummaryModel>();
        for (Object[] r : pageRows) {
            ExtensionSummaryModel model = new ExtensionSummaryModel();
            model.setExtension(String.valueOf(r[0]));
            model.setTotalCall(this.toLong(r[1]));
            model.setAnswered(this.toLong(r[2]));
            model.setUnanswered(this.toLong(r[3]));
            model.setRingDuration(DateFormatUtility.findLocalTime((Long)this.toLong(r[4])));
            model.setAvgRingDuration(DateFormatUtility.findLocalTime((Long)this.toLong(r[5])));
            model.setCallDuration(DateFormatUtility.findLocalTime((Long)this.toLong(r[6])));
            model.setAvgCallDuration(DateFormatUtility.findLocalTime((Long)this.toLong(r[7])));
            result.add(model);
        }
        SearchResponse response = new SearchResponse();
        response.setCurrentPage((long)page);
        response.setPageSize((long)pageSize);
        response.setCurrentPageData(result);
        response.setTotalRecords(totalRecords);
        response.setTotalPages((long)totalPages);
        RequestResponse finalResponse = new RequestResponse();
        finalResponse.setStatus(Constants.Error.OK);
        finalResponse.setMessage("Extension summary fetched successfully");
        finalResponse.setData((Object)response);
        return finalResponse;
    }

    private LocalDate parseDate(String v) {
        try {
            return v == null || v.trim().isEmpty() ? null : LocalDate.parse(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Long toLong(Object val) {
        if (val == null) {
            return 0L;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return 0L;
    }

    private String formatAmount(Long val) {
        Long costInPaise = val != null ? val : 0L;
        double costInRupees = (double)costInPaise.longValue() / 100.0;
        return String.valueOf(costInRupees);
    }
}

