/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.billingCDR.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.billingCDR.model.DepartmentDetailsModel;
import com.coraltele.service.telemetry.main.billingCDR.service.DepartmentDetailsService;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/departmentDetails"})
@RestController
public class DepartmentDetailsController {
    private static final Logger logger = LogManager.getLogger(DepartmentDetailsController.class);
    @Autowired
    DepartmentDetailsService service;
    @Autowired
    DynamicPdfThreadService threadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    private static final Map<String, String> headers = new /* Unavailable Anonymous Inner Class!! */;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> list(@RequestBody SearchRequest req) {
        RequestResponse res = this.service.getAllByFilter(req);
        if (res.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)res);
        }
        return new ResponseEntity((Object)res, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> download(@RequestBody SearchRequest req) {
        try {
            List list = this.service.getList(req);
            StringWriter sw = new StringWriter();
            try (CSVPrinter csv = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
                ArrayList<String> hdr = new ArrayList<String>();
                for (String c : req.getColumnNames()) {
                    hdr.add(headers.getOrDefault(c, c));
                }
                csv.printRecord(hdr);
                for (DepartmentDetailsModel d : list) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    for (String c : req.getColumnNames()) {
                        row.add(this.get(d, c));
                    }
                    csv.printRecord(row);
                }
            }
            byte[] bytes = sw.toString().getBytes(StandardCharsets.UTF_8);
            HttpHeaders h = new HttpHeaders();
            h.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            h.setContentDispositionFormData("attachment", "department_details.csv");
            return new ResponseEntity((Object)bytes, (MultiValueMap)h, HttpStatus.OK);
        }
        catch (Exception ex) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object get(DepartmentDetailsModel d, String c) {
        if (d == null || c == null) {
            return "";
        }
        switch (c) {
            case "departmentCode": {
                return d.getDepartmentCode();
            }
            case "departmentName": {
                return d.getDepartmentName();
            }
            case "callerIdNumber": {
                return d.getCallerIdNumber();
            }
            case "destinationNumber": {
                return d.getDestinationNumber();
            }
            case "callType": {
                return d.getCallType();
            }
            case "coralCallDirection": {
                return d.getCoralCallDirection();
            }
            case "talkDuration": {
                return d.getTalkDuration();
            }
            case "pulse": {
                return d.getPulse();
            }
            case "cost": {
                return d.getCost();
            }
            case "startEpoch": {
                return d.getStartEpoch();
            }
        }
        return "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest req, Principal principal) {
        String folder = "/tmp/";
        String path = folder + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture future = this.threadService.startGeneratingReportAsync(reportType, id, req, path, principal);
        return future.thenApply(r -> {
            ResponseEntity pdf;
            if (r.getStatus().equals((Object)Constants.Error.OK) && (pdf = this.pdfDownloadService.getPdfFile(path)).getStatusCode().is2xxSuccessful()) {
                return ResponseEntity.ok((Object)pdf.getBody());
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"PDF FAILED");
        });
    }
}

