/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.coralnms.scada_asset.service;

import com.coraltele.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.db.telemetry.coralnms.specification.SCADAAssetSpecification;
import com.coraltele.db.telemetry.main.entity.DeviceModel;
import com.coraltele.db.telemetry.main.repository.DeviceModelRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.formJson.model.DynamicFormModel;
import com.coraltele.service.telemetry.coralnms.scada_asset.model.AssetFormResponseModel;
import com.coraltele.service.telemetry.coralnms.scada_asset.model.MediaGatewayModel;
import com.coraltele.service.telemetry.coralnms.scada_asset.model.MediaGatewayResponseModel;
import com.coraltele.service.telemetry.coralnms.scada_asset.model.SCADAAssetModel;
import com.coraltele.service.telemetry.coralnms.scada_asset.model.ServerGroupIdModel;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class SCADAAssetService {
    private static final Logger logger = LogManager.getLogger(SCADAAssetService.class);
    private static final String directoryPath = "/etc/coraltele/forms/devicemanager/data/";
    private static final String formPath = "/etc/coraltele/forms/";
    @Autowired
    private SCADAAssetRepository scadaAssetRepository;
    private final RestTemplate restTemplate;
    @Autowired
    ObjectMapper objMapper;
    @Autowired
    private DeviceModelRepository deviceModelRepository;

    public SCADAAssetService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public RequestResponse create(SCADAAssetModel data) {
        logger.debug("create new SCADAAsset : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        SCADAAsset scadaAsset = new SCADAAsset();
        try {
            scadaAsset.setNodeId(data.getNodeId());
            scadaAsset.setIpAddress(data.getIpAddress());
            scadaAsset.setNodeName(data.getNodeName());
            scadaAsset.setCategory(data.getCategory());
            scadaAsset.setOid(data.getOid());
            if (data.getStatus() != null) {
                scadaAsset.setStatus(data.getStatus().booleanValue());
            }
            scadaAsset.setSwitchIP(data.getSwitchIP());
            scadaAsset.setStackId(data.getStackId());
            scadaAsset.setSwitchPort(data.getSwitchPort());
            scadaAsset.setLocation(data.getLocation());
            scadaAsset.setSeverity(data.getSeverity());
            scadaAsset.setSeverityBackGroundColor(data.getSeverityBackGroundColor());
            scadaAsset.setSeverityForeGroundColor(data.getSeverityForeGroundColor());
            scadaAsset.setXCoordinate(data.getXCoordinate());
            scadaAsset.setYCoordinate(data.getYCoordinate());
            scadaAsset.setServerGroupId(data.getServerGroupId());
            scadaAsset.setControl(data.getControl());
            scadaAsset.setBackgroundURL(data.getBackgroundURL());
            scadaAsset.setCellId(data.getCellId());
            scadaAsset.setDeviceMessage(data.getDeviceMessage());
            scadaAsset.setLiveStatusURL(data.getLiveStatusURL());
            scadaAsset.setManagementURL(data.getManagementURL());
            scadaAsset.setUuid(UUID.randomUUID());
            scadaAsset.setMacAddress(data.getMacAddress());
            if (data.getDisableNotification().booleanValue()) {
                scadaAsset.setDisableNotification(data.getDisableNotification());
            } else {
                scadaAsset.setDisableNotification(Boolean.valueOf(false));
            }
            scadaAsset.setProductClass(data.getProductClass());
            scadaAsset.setExtensionNumber(data.getExtensionNumber());
            if (data.getSuppressAggregation() != null) {
                scadaAsset.setSuppressAggregation(data.getSuppressAggregation());
            } else {
                scadaAsset.setSuppressAggregation(Boolean.valueOf(false));
            }
            this.scadaAssetRepository.save((Object)scadaAsset);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("SCADAAsset created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create SCADAAsset");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateSCADAAsset(SCADAAssetModel data) {
        logger.debug("update the given SCADAAsset : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional scadaAsset = this.scadaAssetRepository.findById(data.getId());
            if (scadaAsset.isPresent()) {
                if (data.getNodeId() != null) {
                    ((SCADAAsset)scadaAsset.get()).setNodeId(data.getNodeId());
                }
                if (data.getIpAddress() != null) {
                    ((SCADAAsset)scadaAsset.get()).setIpAddress(data.getIpAddress());
                }
                if (data.getNodeName() != null) {
                    ((SCADAAsset)scadaAsset.get()).setNodeName(data.getNodeName());
                }
                if (data.getCategory() != null) {
                    ((SCADAAsset)scadaAsset.get()).setCategory(data.getCategory());
                }
                if (data.getOid() != null) {
                    ((SCADAAsset)scadaAsset.get()).setOid(data.getOid());
                }
                if (data.getStatus() != null) {
                    ((SCADAAsset)scadaAsset.get()).setStatus(data.getStatus().booleanValue());
                }
                if (data.getSwitchIP() != null) {
                    ((SCADAAsset)scadaAsset.get()).setSwitchIP(data.getSwitchIP());
                }
                if (data.getStackId() != null) {
                    ((SCADAAsset)scadaAsset.get()).setStackId(data.getStackId());
                }
                if (data.getSwitchPort() != null) {
                    ((SCADAAsset)scadaAsset.get()).setSwitchPort(data.getSwitchPort());
                }
                if (data.getLocation() != null) {
                    ((SCADAAsset)scadaAsset.get()).setLocation(data.getLocation());
                }
                if (data.getSeverity() != null) {
                    ((SCADAAsset)scadaAsset.get()).setSeverity(data.getSeverity());
                }
                if (data.getSeverityBackGroundColor() != null) {
                    ((SCADAAsset)scadaAsset.get()).setSeverityBackGroundColor(data.getSeverityBackGroundColor());
                }
                if (data.getSeverityForeGroundColor() != null) {
                    ((SCADAAsset)scadaAsset.get()).setSeverityForeGroundColor(data.getSeverityForeGroundColor());
                }
                if (data.getXCoordinate() != null) {
                    ((SCADAAsset)scadaAsset.get()).setXCoordinate(data.getXCoordinate());
                }
                if (data.getYCoordinate() != null) {
                    ((SCADAAsset)scadaAsset.get()).setYCoordinate(data.getYCoordinate());
                }
                ((SCADAAsset)scadaAsset.get()).setServerGroupId(data.getServerGroupId());
                if (data.getControl() != null) {
                    ((SCADAAsset)scadaAsset.get()).setControl(data.getControl());
                }
                if (data.getBackgroundURL() != null) {
                    ((SCADAAsset)scadaAsset.get()).setBackgroundURL(data.getBackgroundURL());
                }
                if (data.getCellId() != null) {
                    ((SCADAAsset)scadaAsset.get()).setCellId(data.getCellId());
                }
                if (data.getDeviceMessage() != null) {
                    ((SCADAAsset)scadaAsset.get()).setDeviceMessage(data.getDeviceMessage());
                }
                if (data.getLiveStatusURL() != null) {
                    ((SCADAAsset)scadaAsset.get()).setLiveStatusURL(data.getLiveStatusURL());
                }
                if (data.getManagementURL() != null) {
                    ((SCADAAsset)scadaAsset.get()).setManagementURL(data.getManagementURL());
                }
                if (data.getMacAddress() != null) {
                    ((SCADAAsset)scadaAsset.get()).setMacAddress(data.getMacAddress());
                }
                if (data.getDisableNotification() != null) {
                    ((SCADAAsset)scadaAsset.get()).setDisableNotification(data.getDisableNotification());
                }
                if (data.getProductClass() != null) {
                    ((SCADAAsset)scadaAsset.get()).setProductClass(data.getProductClass());
                }
                if (data.getSuppressAggregation() != null) {
                    ((SCADAAsset)scadaAsset.get()).setSuppressAggregation(data.getSuppressAggregation());
                }
                if (data.getExtensionNumber() != null) {
                    ((SCADAAsset)scadaAsset.get()).setExtensionNumber(data.getExtensionNumber());
                }
                this.scadaAssetRepository.save(scadaAsset.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("data updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("data not found you are looking for");
                logger.error(returnValue.getMessageDetail());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("ERROR");
            returnValue.setMessageDetail(" Error While Fetching Data");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllSCADAAsset() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SCADAAssetModel> addValue = new ArrayList<SCADAAssetModel>();
        List list = this.scadaAssetRepository.findAll();
        for (SCADAAsset scadaAsset : list) {
            SCADAAssetModel data = new SCADAAssetModel();
            data.setNodeId(scadaAsset.getNodeId());
            data.setIpAddress(scadaAsset.getIpAddress());
            data.setNodeName(scadaAsset.getNodeName());
            data.setCategory(scadaAsset.getCategory());
            data.setOid(scadaAsset.getOid());
            data.setStatus(Boolean.valueOf(scadaAsset.isStatus()));
            data.setSwitchIP(scadaAsset.getSwitchIP());
            data.setSwitchPort(scadaAsset.getSwitchPort());
            data.setStackId(scadaAsset.getStackId());
            data.setLocation(scadaAsset.getLocation());
            data.setSeverity(data.getSeverity());
            data.setSeverityBackGroundColor(scadaAsset.getSeverityBackGroundColor());
            data.setSeverityForeGroundColor(scadaAsset.getSeverityForeGroundColor());
            data.setXCoordinate(scadaAsset.getXCoordinate());
            data.setYCoordinate(scadaAsset.getYCoordinate());
            data.setServerGroupId(scadaAsset.getServerGroupId());
            data.setControl(scadaAsset.getControl());
            data.setBackgroundURL(scadaAsset.getBackgroundURL());
            data.setCellId(scadaAsset.getCellId());
            data.setDeviceMessage(scadaAsset.getDeviceMessage());
            data.setLiveStatusURL(scadaAsset.getLiveStatusURL());
            data.setManagementURL(scadaAsset.getManagementURL());
            data.setMacAddress(scadaAsset.getMacAddress());
            data.setDisableNotification(scadaAsset.getDisableNotification());
            data.setProductClass(scadaAsset.getProductClass());
            data.setSuppressAggregation(scadaAsset.getSuppressAggregation());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        return returnValue;
    }

    public RequestResponse getById(Long id) {
        RequestResponse returnValue = new RequestResponse();
        Optional scadaAsset = this.scadaAssetRepository.findById(id);
        if (scadaAsset.isPresent()) {
            SCADAAssetModel data = new SCADAAssetModel();
            data.setId(((SCADAAsset)scadaAsset.get()).getId());
            data.setNodeId(((SCADAAsset)scadaAsset.get()).getNodeId());
            data.setIpAddress(((SCADAAsset)scadaAsset.get()).getIpAddress());
            data.setNodeName(((SCADAAsset)scadaAsset.get()).getNodeName());
            data.setCategory(((SCADAAsset)scadaAsset.get()).getCategory());
            data.setOid(((SCADAAsset)scadaAsset.get()).getOid());
            data.setStatus(Boolean.valueOf(((SCADAAsset)scadaAsset.get()).isStatus()));
            data.setSwitchIP(((SCADAAsset)scadaAsset.get()).getSwitchIP());
            data.setSwitchPort(((SCADAAsset)scadaAsset.get()).getSwitchPort());
            data.setStackId(((SCADAAsset)scadaAsset.get()).getStackId());
            data.setLocation(((SCADAAsset)scadaAsset.get()).getLocation());
            data.setSeverity(data.getSeverity());
            data.setSeverityBackGroundColor(((SCADAAsset)scadaAsset.get()).getSeverityBackGroundColor());
            data.setSeverityForeGroundColor(((SCADAAsset)scadaAsset.get()).getSeverityForeGroundColor());
            data.setXCoordinate(((SCADAAsset)scadaAsset.get()).getXCoordinate());
            data.setYCoordinate(((SCADAAsset)scadaAsset.get()).getYCoordinate());
            data.setServerGroupId(((SCADAAsset)scadaAsset.get()).getServerGroupId());
            data.setControl(((SCADAAsset)scadaAsset.get()).getControl());
            data.setMacAddress(((SCADAAsset)scadaAsset.get()).getMacAddress());
            data.setDisableNotification(((SCADAAsset)scadaAsset.get()).getDisableNotification());
            data.setProductClass(((SCADAAsset)scadaAsset.get()).getProductClass());
            data.setSuppressAggregation(((SCADAAsset)scadaAsset.get()).getSuppressAggregation());
            data.setExtensionNumber(((SCADAAsset)scadaAsset.get()).getExtensionNumber());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setData((Object)data);
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
        returnValue.setMessage("Unable to return value");
        returnValue.setMessageDetail("Records not found");
        return returnValue;
    }

    public RequestResponse getSCADAAssetByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = SCADAAssetSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.scadaAssetRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.scadaAssetRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<SCADAAssetModel> entityToModelConversion(List<SCADAAsset> scadaAssets) {
        ArrayList<SCADAAssetModel> addValue = new ArrayList<SCADAAssetModel>();
        for (SCADAAsset row : scadaAssets) {
            SCADAAssetModel data = new SCADAAssetModel();
            data.setId(row.getId());
            data.setNodeId(row.getNodeId());
            data.setIpAddress(row.getIpAddress());
            data.setNodeName(row.getNodeName());
            data.setCategory(row.getCategory());
            data.setOid(row.getOid());
            data.setStatus(Boolean.valueOf(row.isStatus()));
            data.setSwitchIP(row.getSwitchIP());
            data.setSwitchPort(row.getSwitchPort());
            data.setStackId(row.getStackId());
            data.setLocation(row.getLocation());
            data.setSeverity(data.getSeverity());
            data.setSeverityBackGroundColor(row.getSeverityBackGroundColor());
            data.setSeverityForeGroundColor(row.getSeverityForeGroundColor());
            data.setXCoordinate(row.getXCoordinate());
            data.setYCoordinate(row.getYCoordinate());
            data.setServerGroupId(row.getServerGroupId());
            data.setControl(row.getControl());
            data.setBackgroundURL(row.getBackgroundURL());
            data.setCellId(row.getCellId());
            data.setDeviceMessage(row.getDeviceMessage());
            data.setLiveStatusURL(row.getLiveStatusURL());
            data.setManagementURL(row.getManagementURL());
            data.setMacAddress(row.getMacAddress());
            data.setDisableNotification(row.getDisableNotification());
            data.setProductClass(row.getProductClass());
            data.setExtensionNumber(row.getExtensionNumber());
            if (row.getSuppressAggregation() == null) {
                data.setSuppressAggregation(Boolean.valueOf(false));
            } else {
                data.setSuppressAggregation(row.getSuppressAggregation());
            }
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse deleteSCADAAssetById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional sCADAAsset = this.scadaAssetRepository.findById(Long.valueOf(ids));
            if (sCADAAsset.isPresent()) {
                addValue.add(sCADAAsset.get());
                this.scadaAssetRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("records has been deleted");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getServerGroupId() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ServerGroupIdModel> addValue = new ArrayList<ServerGroupIdModel>();
        List list = this.scadaAssetRepository.findAll();
        for (SCADAAsset scadaAsset : list) {
            ServerGroupIdModel data = new ServerGroupIdModel();
            data.setId(scadaAsset.getId());
            data.setServerGroupId(scadaAsset.getServerGroupId());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        return returnValue;
    }

    public RequestResponse getAllCategory(InputIdModel id) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        Optional scadaAsset = this.scadaAssetRepository.findById(id.getAssetId());
        if (scadaAsset.isPresent()) {
            String category = ((SCADAAsset)scadaAsset.get()).getCategory();
            List categoryList = this.scadaAssetRepository.findByCategory(category);
            for (SCADAAsset scadaAssets : categoryList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", scadaAssets.getId());
                map.put("category", category);
                map.put("location", scadaAssets.getLocation());
                map.put("nodeName", scadaAssets.getNodeName());
                addValue.add(map);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("list retrieved successfully");
            returnValue.setData(addValue);
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not found");
            returnValue.setMessageDetail("SCADAAsset not found");
        }
        return returnValue;
    }

    public RequestResponse getListOfAssetId() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<MediaGatewayModel> addValue = new ArrayList<MediaGatewayModel>();
        List list = this.scadaAssetRepository.findAll();
        for (SCADAAsset scadaAsset : list) {
            if (!"ICC3".equals(scadaAsset.getCategory()) && !"ICC4".equals(scadaAsset.getCategory())) continue;
            MediaGatewayModel data = new MediaGatewayModel();
            data.setId(scadaAsset.getId());
            data.setNodeName(scadaAsset.getNodeName());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        return returnValue;
    }

    public RequestResponse generateTokenAndURL(Long id, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Optional scadaAsset = this.scadaAssetRepository.findById(id);
        if (scadaAsset != null) {
            String ipAddress = ((SCADAAsset)scadaAsset.get()).getIpAddress();
            String firstUrl = "http://" + ipAddress + "/api.php?admin=token";
            logger.info("final url for first step is:{}", (Object)firstUrl);
            if (ipAddress != null) {
                try {
                    ResponseEntity response = this.restTemplate.exchange(firstUrl, HttpMethod.GET, null, MediaGatewayResponseModel.class, new Object[0]);
                    String token = ((MediaGatewayResponseModel)response.getBody()).getData();
                    logger.info("current token is:{}", (Object)token);
                    String generateToken = "http://" + ipAddress + "/validation.php?token=" + token;
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("OK");
                    returnValue.setMessageDetail("URL Generated Successfully");
                    returnValue.setData((Object)generateToken);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not found");
            returnValue.setMessageDetail("SCADAAsset not found");
        }
        return returnValue;
    }

    public RequestResponse getFormAndData(Long id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String macId = "";
            Optional record = this.scadaAssetRepository.findById(id);
            if (record.isPresent()) {
                String productClass = ((SCADAAsset)record.get()).getProductClass();
                macId = ((SCADAAsset)record.get()).getMacAddress();
                if (macId != null && StringUtils.hasText((String)macId)) {
                    if (productClass != null && StringUtils.hasText((String)productClass)) {
                        Optional productMaster = this.deviceModelRepository.findByProductClass(productClass);
                        if (productMaster.isPresent()) {
                            AssetFormResponseModel response = new AssetFormResponseModel();
                            String formCode = ((DeviceModel)productMaster.get()).getFormCode();
                            logger.info("formCode for selected data is:{}", (Object)(formCode + ".json"));
                            String filePath = formPath + formCode + ".json";
                            File file = new File(filePath);
                            if (file.exists()) {
                                String fileContent = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
                                ObjectMapper objectMapper = new ObjectMapper();
                                DynamicFormModel jsonData = (DynamicFormModel)objectMapper.readValue(fileContent, DynamicFormModel.class);
                                DynamicFormModel formResponse = new DynamicFormModel();
                                formResponse.setFormCode(formCode);
                                formResponse.setContent(jsonData.getContent());
                                formResponse.setTabs(jsonData.getTabs());
                                logger.info("form retrieved successfully");
                                response.setForm(formResponse);
                            } else {
                                logger.error("selected file not exist:{}", (Object)filePath);
                            }
                            logger.info("formData for selected id is:{}", (Object)(macId + ".json"));
                            String formDataPath = directoryPath + macId + ".json";
                            File file1 = new File(formDataPath);
                            if (file1.exists()) {
                                String fileContent = new String(Files.readAllBytes(Paths.get(formDataPath, new String[0])));
                                ObjectMapper objectMapper = new ObjectMapper();
                                Map formData = (Map)objectMapper.readValue(fileContent, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                                logger.info("form retrieved successfully");
                                response.setFormData(formData);
                            } else {
                                logger.error("selected form having no data:{}", (Object)formDataPath);
                            }
                            returnValue.setMessage("form read Successfully");
                            returnValue.setMessageDetail("formData read Successfully");
                            returnValue.setData((Object)response);
                            return returnValue;
                        }
                        DynamicFormModel form = new DynamicFormModel();
                        form.setFormCode("");
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("form not exist corresponding to productClass");
                        logger.error(returnValue.getMessage());
                    } else {
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("Invalid ProductClass assigned");
                        logger.error("Product class:{}", (Object)productClass);
                    }
                } else {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Invalid macAddress assigned");
                    logger.error("Mac Address:{}", (Object)macId);
                }
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("pass valid assetId to retrieved form");
                logger.error("Invalid assetId to retrieved form");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Something went wrong");
            returnValue.setMessageDetail("error on finding productClass from deviceModel");
            logger.error(e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse createJsonFile(Long assetId, Map<String, Object> content) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        String macId = "";
        String filePath = "";
        File directory = new File(directoryPath);
        directory.mkdirs();
        Optional scadaAsset = this.scadaAssetRepository.findById(assetId);
        if (scadaAsset.isPresent()) {
            macId = ((SCADAAsset)scadaAsset.get()).getMacAddress();
        }
        filePath = macId != null && StringUtils.hasText((String)macId) ? directoryPath + macId + ".json" : directoryPath + assetId + ".json";
        logger.info("Json created path:{}", (Object)filePath);
        File file = new File(filePath);
        if (file.exists()) {
            if (file.delete()) {
                logger.info("Existing JSON file deleted successfully: " + filePath);
            } else {
                logger.error("Failed to delete existing JSON file: " + filePath);
            }
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
            objectMapper.writeValue(file, content);
            RequestResponse status = this.updateConfiguration(assetId);
            if (status.getStatus().equals((Object)Constants.Error.OK)) {
                logger.info("JSON and config file update successfully at: " + filePath);
                logger.info("Config file success at:{},{}", (Object)returnValue.getMessage(), (Object)returnValue.getMessageDetail());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("JSON and config file update successfully ");
            } else {
                logger.error(status.getMessage() + "&" + status.getMessageDetail());
                logger.info("only JSON file update: " + filePath);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("JSON file update successfully");
                returnValue.setMessageDetail(status.getMessage() + ":" + status.getMessageDetail());
            }
        }
        catch (IOException e) {
            logger.error("Error occurred while writing JSON file: " + e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed to update json");
            throw e;
        }
        return returnValue;
    }

    private void addKeys(String currentPath, JsonNode jsonNode, Map<String, String> map, List<Integer> suffix) {
        if (jsonNode.isObject()) {
            String pathPrefix;
            ObjectNode objectNode = (ObjectNode)jsonNode;
            Iterator iter = objectNode.fields();
            String string = pathPrefix = currentPath.isEmpty() ? "" : currentPath + "-";
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                this.addKeys(pathPrefix + (String)entry.getKey(), (JsonNode)entry.getValue(), map, suffix);
            }
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (int i = 0; i < arrayNode.size(); ++i) {
                suffix.add(i + 1);
                this.addKeys(currentPath, arrayNode.get(i), map, suffix);
                if (i + 1 >= arrayNode.size()) continue;
                suffix.remove(arrayNode.size() - 1);
            }
        } else if (jsonNode.isValueNode()) {
            if (currentPath.contains("-")) {
                for (int i = 0; i < suffix.size(); ++i) {
                    currentPath = currentPath + "-" + suffix.get(i);
                }
                suffix = new ArrayList<Integer>();
            }
            ValueNode valueNode = (ValueNode)jsonNode;
            map.put(currentPath, valueNode.asText());
        }
    }

    public RequestResponse updateConfiguration(Long assetId) {
        String defaultTemplate = "";
        String macId = "";
        RequestResponse returnValue = new RequestResponse();
        Optional scadaAsset = this.scadaAssetRepository.findById(assetId);
        if (scadaAsset.isPresent()) {
            String productClass = ((SCADAAsset)scadaAsset.get()).getProductClass();
            macId = ((SCADAAsset)scadaAsset.get()).getMacAddress();
            Optional deviceModel = this.deviceModelRepository.findByProductClass(productClass);
            if (deviceModel.isPresent()) {
                defaultTemplate = ((DeviceModel)deviceModel.get()).getFormCode();
            }
        }
        String jsonContentPath = directoryPath + macId + ".json";
        String defaultTemplatePath = "/etc/coraltele/forms/devicemanager/template/";
        defaultTemplatePath = defaultTemplatePath + defaultTemplate + ".template";
        String configFilePath = "/var/www/html/configs/";
        try {
            String xmlContent;
            String jsonContentData = new String(Files.readAllBytes(Paths.get(jsonContentPath, new String[0])));
            ObjectMapper ojm = new ObjectMapper();
            JsonNode root = ojm.readTree(jsonContentData);
            HashMap map = new HashMap();
            this.addKeys("", root, map, new ArrayList());
            String xmlConfig = xmlContent = new String(Files.readAllBytes(Paths.get(defaultTemplatePath, new String[0])));
            for (Map.Entry entry : map.entrySet()) {
                xmlConfig = xmlConfig.replace("#" + (String)entry.getKey(), entry.getValue() != null ? (CharSequence)entry.getValue() : "");
            }
            Files.createDirectories(Paths.get(configFilePath, new String[0]), new FileAttribute[0]);
            String newXmlFileName = "";
            newXmlFileName = macId != null && StringUtils.hasText((String)macId) ? "cfg" + macId + ".xml" : "cfg" + assetId + ".xml";
            logger.info("Config file created Path:{}", (Object)newXmlFileName);
            File newXmlFile = new File(configFilePath + newXmlFileName);
            if (newXmlFile.exists()) {
                newXmlFile.delete();
            }
            Files.write(newXmlFile.toPath(), xmlConfig.getBytes(), new OpenOption[0]);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("New config file created");
            returnValue.setMessageDetail("New config file created: " + configFilePath + newXmlFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid default template");
            returnValue.setMessageDetail(e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAllNodeName() {
        List list = this.scadaAssetRepository.findAll();
        ArrayList<MediaGatewayModel> addValue = new ArrayList<MediaGatewayModel>();
        RequestResponse returnValue = new RequestResponse();
        for (SCADAAsset row : list) {
            MediaGatewayModel data = new MediaGatewayModel();
            data.setId(row.getId());
            data.setCellId(row.getCellId());
            data.setNodeName(row.getNodeName());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

