/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.taxonomy.service;

import com.coraltele.db.telephony.pbx.entity.Taxonomy;
import com.coraltele.db.telephony.pbx.repository.TaxonomyRepository;
import com.coraltele.db.telephony.pbx.specification.TaxonomySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.taxonomy.model.TaxonomyModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TaxonomyService {
    private static final Logger logger = LogManager.getLogger(TaxonomyService.class);
    @Autowired
    TaxonomyRepository taxonomyRepository;

    public RequestResponse createData(TaxonomyModel data) {
        logger.info("Create new taxonomy : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Taxonomy record = new Taxonomy();
            record.setCode(data.getCode());
            record.setDescription(data.getDescription());
            record.setCategory(data.getCategory());
            this.taxonomyRepository.save((Object)record);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("New Taxonomy Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create taxonomy");
            returnValue.setMessageDetail("Contact With administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(TaxonomyModel data) {
        logger.info("Update Taxonomy {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional taxonomy = this.taxonomyRepository.findById((Object)data.getId());
        if (!taxonomy.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Taxonomy Not Found");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCode() != null) {
            ((Taxonomy)taxonomy.get()).setCode(data.getCode());
        }
        if (data.getDescription() != null) {
            ((Taxonomy)taxonomy.get()).setDescription(data.getDescription());
        }
        if (data.getCategory() != null) {
            ((Taxonomy)taxonomy.get()).setCategory(data.getCategory());
        }
        this.taxonomyRepository.save(taxonomy.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Taxonomy Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional taxonomy = this.taxonomyRepository.findById((Object)ids);
            if (taxonomy.isPresent()) {
                addValue.add(taxonomy.get());
                this.taxonomyRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.taxonomyRepository.findAll();
        ArrayList<TaxonomyModel> addValue = new ArrayList<TaxonomyModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Taxonomy taxonomy : list) {
            TaxonomyModel data = new TaxonomyModel();
            data.setId(taxonomy.getId());
            data.setCode(taxonomy.getCode());
            data.setDescription(taxonomy.getDescription());
            data.setCategory(taxonomy.getCategory());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = TaxonomySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.taxonomyRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.taxonomyRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getByCategory(String category) {
        List list = this.taxonomyRepository.findByCategory(category);
        ArrayList<TaxonomyModel> addValue = new ArrayList<TaxonomyModel>();
        RequestResponse returnValue = new RequestResponse();
        if (!list.isEmpty()) {
            for (Taxonomy taxonomy : list) {
                TaxonomyModel data = new TaxonomyModel();
                data.setId(taxonomy.getId());
                data.setCode(taxonomy.getCode());
                data.setDescription(taxonomy.getDescription());
                data.setCategory(taxonomy.getCategory());
                addValue.add(data);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setData(addValue);
            logger.info(returnValue.getMessage());
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Empty list present");
            returnValue.setMessageDetail("data of selected category not exist");
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }
}

