/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.sendfaxprogress.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.sendfaxprogress.model.SendFaxProgressModel;
import com.coraltele.service.pbx.sendfaxprogress.service.SendFaxProgressService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/sendFaxProgress"})
@RestController
public class SendFaxProgressController {
    private static final Logger logger = LogManager.getLogger(SendFaxProgressController.class);
    private static final String CONTROLLER_NAME = "Send-Fax-Details";
    @Autowired
    SendFaxProgressService sendFaxProgressService;

    @PostMapping(value={"/"})
    public ResponseEntity<RequestResponse> getSendFaxProgressByProfileId(@RequestBody SendFaxProgressModel data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for update : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.sendFaxProgressService.getRecord(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for update : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for update: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }
}

