/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.gatewayMaster.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.GatewayController;
import com.coraltele.db.telephony.pbx.entity.GatewayMaster;
import com.coraltele.db.telephony.pbx.entity.InboundGateway;
import com.coraltele.db.telephony.pbx.repository.GatewayControllerRepository;
import com.coraltele.db.telephony.pbx.repository.GatewayMasterRepository;
import com.coraltele.db.telephony.pbx.repository.InboundGatewayRepository;
import com.coraltele.db.telephony.pbx.specification.GatewayMasterSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.gatewayMaster.model.GatewayMasterDropdownModel;
import com.coraltele.service.pbx.gatewayMaster.model.GatewayMasterModel;
import com.coraltele.service.uc.service.CustomerAccountService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class GatewayMasterService {
    private static final Logger logger = LogManager.getLogger(GatewayMasterService.class);
    @Autowired
    GatewayMasterRepository gatewayMasterRepository;
    @Autowired
    InboundGatewayRepository inboundGatewayRepository;
    @Autowired
    CustomerAccountService customerAccountService;
    @Autowired
    GatewayControllerRepository gatewayControllerRepository;

    public RequestResponse getAll() {
        List list = (List)this.gatewayMasterRepository.findAll();
        ArrayList<GatewayMasterDropdownModel> addValue = new ArrayList<GatewayMasterDropdownModel>();
        RequestResponse returnValue = new RequestResponse();
        for (GatewayMaster gatewayMaster : list) {
            GatewayMasterDropdownModel data = new GatewayMasterDropdownModel();
            data.setId(gatewayMaster.getId());
            data.setGwGroup(gatewayMaster.getGwGroup());
            data.setGwCode(gatewayMaster.getGwCode());
            data.setGwType(gatewayMaster.getGwType());
            data.setGwName(gatewayMaster.getGwName());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createData(GatewayMasterModel data) {
        logger.debug("create new gatewayMaster : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            List list = (List)this.gatewayMasterRepository.findAll();
            for (GatewayMaster gwCode : list) {
                if (!gwCode.getGwCode().equals(data.getGwCode())) continue;
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable to Create GatewayMaster");
                returnValue.setMessageDetail("Please Enter Different GwCode");
                return returnValue;
            }
            if (CustomerAccountService.getClickToCall()) {
                logger.info("Saving data using cli command");
                String dialPlan = "";
                String gatewayCode = data.getGwCode();
                String gatewayName = data.getGwName();
                String gatewayType = "";
                gatewayType = data.getGwType().equals("customType") ? data.getGwTypeCustom() : data.getGwType();
                String gatewayRange = this.convertWithHyphen(data.getGwRange());
                if (data.getDialPlan() != null && !data.getDialPlan().isEmpty()) {
                    if (data.getDialPlan().equals("sip")) {
                        dialPlan = "sofia/internal/$1@" + data.getDialValue();
                    } else if (data.getDialPlan().equals("pri")) {
                        dialPlan = "freeswitch/a/" + data.getDialValue();
                    } else if (data.getDialPlan().equals("custom")) {
                        dialPlan = data.getDialValue();
                    }
                }
                String maxChannel = data.getMaxChannel().toString();
                String callTimeOut = data.getCallTimeout().toString();
                String callStrip = data.getCallerStrip();
                String destinationStrip = data.getNumberStrip();
                String gwGroup = "";
                gwGroup = data.getGwGroup().equalsIgnoreCase("CustomGroup") ? data.getGwGroupCustom() : data.getGwGroup();
                CLIServerCommandLog cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("gateway create %s %s %s %s %s %s %s %s %s %s", gatewayCode, gatewayName, gatewayType, gatewayRange, dialPlan, maxChannel, callTimeOut, callStrip, destinationStrip, gwGroup));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info(cliServerCommandLog.getCLICommand());
            } else {
                GatewayMaster gatewayMaster = new GatewayMaster();
                if (data.getAllowDTmfTone() != null) {
                    gatewayMaster.setAllowDTmfTone(data.getAllowDTmfTone());
                } else {
                    gatewayMaster.setAllowDTmfTone(Boolean.valueOf(false));
                }
                if (data.getAllowExtendTime() != null) {
                    gatewayMaster.setAllowExtendTime(data.getAllowExtendTime());
                } else {
                    gatewayMaster.setAllowExtendTime(Boolean.valueOf(false));
                }
                gatewayMaster.setBeepInterval(data.getBeepInterval());
                if (data.getCacBandwidth() != null) {
                    gatewayMaster.setCacBandwidth(data.getCacBandwidth());
                } else {
                    gatewayMaster.setCacBandwidth(Long.valueOf(0L));
                }
                if (data.getCallTimeout() != null) {
                    gatewayMaster.setCallTimeout(data.getCallTimeout());
                } else {
                    gatewayMaster.setCallTimeout(Integer.valueOf(0));
                }
                gatewayMaster.setCallerStrip(data.getCallerStrip());
                gatewayMaster.setCliPrefix(data.getCliPrefix());
                gatewayMaster.setCodec(data.getCodec());
                if (data.getDialPlan().equals("sip")) {
                    gatewayMaster.setDialString("sofia/internal/$1@" + data.getDialValue());
                } else if (data.getDialPlan().equals("pri")) {
                    gatewayMaster.setDialString("freeswitch/a/" + data.getDialValue());
                } else if (data.getDialPlan().equals("custom")) {
                    gatewayMaster.setDialString(data.getDialValue());
                }
                if (data.getEfficiencyPer() != null) {
                    gatewayMaster.setEfficiencyPer(data.getEfficiencyPer());
                } else {
                    gatewayMaster.setEfficiencyPer(Integer.valueOf(90));
                }
                if (data.getEnhancedDuration() != null) {
                    gatewayMaster.setEnhancedDuration(data.getEnhancedDuration());
                } else {
                    gatewayMaster.setEnhancedDuration(Integer.valueOf(0));
                }
                if (data.getMinDuration() != null) {
                    gatewayMaster.setMinDuration(data.getMinDuration());
                } else {
                    gatewayMaster.setMinDuration(Integer.valueOf(0));
                }
                if (data.getExtFailoverTimeout() != null) {
                    gatewayMaster.setExtFailoverTimeout(data.getExtFailoverTimeout());
                } else {
                    gatewayMaster.setExtFailoverTimeout(Integer.valueOf(0));
                }
                gatewayMaster.setFailOverGateway(data.getFailOverGateway());
                gatewayMaster.setFailOverNumber(data.getFailOverNumber());
                if (data.getFailOverTry() != null) {
                    gatewayMaster.setFailOverTry(data.getFailOverTry());
                } else {
                    gatewayMaster.setFailOverTry(Integer.valueOf(0));
                }
                gatewayMaster.setFailoverIsDnCause(data.getFailoverIsDnCause());
                if (data.getFailoverMaxTry() != null) {
                    gatewayMaster.setFailoverMaxTry(data.getFailoverMaxTry());
                } else {
                    gatewayMaster.setFailoverMaxTry(Integer.valueOf(3));
                }
                gatewayMaster.setGatewayControllerCode(data.getGatewayControllerCode());
                gatewayMaster.setGatewayTestingCli(data.getGatewayTestingCli());
                if (data.getGatewayTestingLastTryEpoch() != null) {
                    gatewayMaster.setGatewayTestingLastTryEpoch(data.getGatewayTestingLastTryEpoch());
                } else {
                    gatewayMaster.setGatewayTestingLastTryEpoch(Integer.valueOf(0));
                }
                gatewayMaster.setGatewayTestingNumber(data.getGatewayTestingNumber());
                gatewayMaster.setGwCode(data.getGwCode());
                if (data.getGwGroup().equalsIgnoreCase("CustomGroup")) {
                    gatewayMaster.setGwGroup(data.getGwGroupCustom());
                } else {
                    gatewayMaster.setGwGroup(data.getGwGroup());
                }
                gatewayMaster.setGwName(data.getGwName());
                gatewayMaster.setGwRange(this.convertWithHyphen(data.getGwRange()));
                if (data.getGwType().equals("customType")) {
                    gatewayMaster.setGwType(data.getGwTypeCustom());
                } else {
                    gatewayMaster.setGwType(data.getGwType());
                }
                if (data.getHandleIsDnCause() != null) {
                    gatewayMaster.setHandleIsDnCause(data.getHandleIsDnCause());
                } else {
                    gatewayMaster.setHandleIsDnCause(Boolean.valueOf(false));
                }
                if (data.getIsRecording() != null) {
                    gatewayMaster.setIsRecording(data.getIsRecording());
                } else {
                    gatewayMaster.setIsRecording(Boolean.valueOf(false));
                }
                if (data.getLastCallEpoch() != null) {
                    gatewayMaster.setLastCallEpoch(data.getLastCallEpoch());
                } else {
                    gatewayMaster.setLastCallEpoch(Long.valueOf(0L));
                }
                gatewayMaster.setMaxChannel(data.getMaxChannel());
                if (data.getMaxOutDigit() != null) {
                    gatewayMaster.setMaxOutDigit(data.getMaxOutDigit());
                } else {
                    gatewayMaster.setMaxOutDigit(Integer.valueOf(0));
                }
                if (data.getNmsCac() != null) {
                    gatewayMaster.setNmsCac(data.getNmsCac());
                } else {
                    gatewayMaster.setNmsCac(Boolean.valueOf(false));
                }
                gatewayMaster.setNumberStrip(data.getNumberStrip());
                if (data.getPeerToPeer() != null) {
                    gatewayMaster.setPeerToPeer(data.getPeerToPeer());
                } else {
                    gatewayMaster.setPeerToPeer(Boolean.valueOf(false));
                }
                gatewayMaster.setPrefix(data.getPrefix());
                if (data.getPriority() != null) {
                    gatewayMaster.setPriority(data.getPriority());
                } else {
                    gatewayMaster.setPriority(Integer.valueOf(1));
                }
                if (data.getPulseInSecond() != null) {
                    gatewayMaster.setPulseInSecond(data.getPulseInSecond());
                } else {
                    gatewayMaster.setPulseInSecond(Integer.valueOf(0));
                }
                if (data.getPulseRate() != null) {
                    gatewayMaster.setPulseRate(data.getPulseRate());
                } else {
                    gatewayMaster.setPulseRate(Integer.valueOf(0));
                }
                if (data.getQSig() != null) {
                    gatewayMaster.setQSig(data.getQSig());
                } else {
                    gatewayMaster.setQSig(Boolean.valueOf(false));
                }
                gatewayMaster.setTenantCode(data.getTenantCode());
                if (data.getTollFree() != null) {
                    gatewayMaster.setTollFree(data.getTollFree());
                } else {
                    gatewayMaster.setTollFree(Boolean.valueOf(false));
                }
                this.gatewayMasterRepository.save((Object)gatewayMaster);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("GatewayMaster Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create GatewayMaster");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional gatewayMaster = this.gatewayMasterRepository.findById((Object)ids);
            if (gatewayMaster.isPresent()) {
                if (CustomerAccountService.getClickToCall()) {
                    CLIServerCommandLog cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway delete %s", ((GatewayMaster)gatewayMaster.get()).getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                    continue;
                }
                addValue.add(gatewayMaster.get());
                this.gatewayMasterRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("GatewayMaster Data Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateById(GatewayMasterModel data) {
        logger.debug("Update GatewayMaster {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional gatewayMaster = this.gatewayMasterRepository.findById((Object)data.getId());
        if (!gatewayMaster.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("GatewayMaster Data not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (CustomerAccountService.getClickToCall()) {
            CLIServerCommandLog cliServerCommandLog;
            if (!Objects.equals(data.getAllowDTmfTone(), ((GatewayMaster)gatewayMaster.get()).getAllowDTmfTone())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getAllowDTmfTone()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s allowdtmftone on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getAllowDTmfTone() == null || "false".equalsIgnoreCase(String.valueOf(data.getAllowDTmfTone()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s allowdtmftone off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getCliPrefix(), ((GatewayMaster)gatewayMaster.get()).getCliPrefix())) {
                if (data.getCliPrefix() != null && !data.getCliPrefix().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s cliprefix %s", data.getGwCode(), data.getCliPrefix()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getCliPrefix() == null || data.getCliPrefix().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s cliprefix reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getGatewayTestingNumber(), ((GatewayMaster)gatewayMaster.get()).getGatewayTestingNumber())) {
                if (data.getGatewayTestingNumber() != null && !data.getGatewayTestingNumber().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s gatewaytestingnumber %s", data.getGwCode(), data.getGatewayTestingNumber()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getGatewayTestingNumber() == null || data.getGatewayTestingNumber().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s gatewaytestingnumber reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getQSig(), ((GatewayMaster)gatewayMaster.get()).getQSig())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getQSig()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s qsig on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getQSig() == null || "false".equalsIgnoreCase(String.valueOf(data.getQSig()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s qsig off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getGwType(), ((GatewayMaster)gatewayMaster.get()).getGwType())) {
                if (data.getGwType() != null && !data.getGwType().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s type %s", data.getGwCode(), data.getGwType()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getGwType() == null || data.getGwType().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s type reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getAllowExtendTime(), ((GatewayMaster)gatewayMaster.get()).getAllowExtendTime())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getAllowExtendTime()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s allowtime on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getAllowExtendTime() == null || "false".equalsIgnoreCase(String.valueOf(data.getAllowExtendTime()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s allowtime off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getCodec(), ((GatewayMaster)gatewayMaster.get()).getCodec())) {
                if (data.getCodec() != null && !data.getCodec().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s codec %s", data.getGwCode(), data.getCodec()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getCodec() == null || data.getCodec().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s codec reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getFailOverNumber(), ((GatewayMaster)gatewayMaster.get()).getFailOverNumber())) {
                if (data.getFailOverNumber() != null && !data.getFailOverNumber().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s failovernumber %s", data.getGwCode(), data.getFailOverNumber()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getFailOverNumber() == null || data.getFailOverNumber().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s failovernumber reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getHandleIsDnCause(), ((GatewayMaster)gatewayMaster.get()).getHandleIsDnCause())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getHandleIsDnCause()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s handleisdncause on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getHandleIsDnCause() == null || "false".equalsIgnoreCase(String.valueOf(data.getHandleIsDnCause()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s handleisdncause off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getPulseRate(), ((GatewayMaster)gatewayMaster.get()).getPulseRate())) {
                if (data.getPulseRate() != null && !data.getPulseRate().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s rate %s", data.getGwCode(), data.getPulseRate()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getPulseRate() == null || data.getPulseRate().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s rate reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getCacBandwidth(), ((GatewayMaster)gatewayMaster.get()).getCacBandwidth())) {
                if (data.getCacBandwidth() != null && !data.getCacBandwidth().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s cacbandwidth %s", data.getGwCode(), data.getCacBandwidth()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getCacBandwidth() == null || data.getCacBandwidth().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s cacbandwidth reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getPrefix(), ((GatewayMaster)gatewayMaster.get()).getPrefix())) {
                if (data.getPrefix() != null && !data.getPrefix().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s dialprefix %s", data.getGwCode(), data.getPrefix()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getPrefix() == null || data.getPrefix().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s dialprefix reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getGatewayControllerCode(), ((GatewayMaster)gatewayMaster.get()).getGatewayControllerCode())) {
                if (data.getGatewayControllerCode() != null && !data.getGatewayControllerCode().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s gatewaycontrollercode %s", data.getGwCode(), data.getGatewayControllerCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getGatewayControllerCode() == null || data.getGatewayControllerCode().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s gatewaycontrollercode reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getMaxChannel(), ((GatewayMaster)gatewayMaster.get()).getMaxChannel())) {
                if (data.getMaxChannel() != null && !data.getMaxChannel().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s maxchannel %s", data.getGwCode(), data.getMaxChannel()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getMaxChannel() == null || data.getMaxChannel().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s maxchannel reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getPeerToPeer(), ((GatewayMaster)gatewayMaster.get()).getPeerToPeer())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getPeerToPeer()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s peertopeer on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getPeerToPeer() == null || "false".equalsIgnoreCase(String.valueOf(data.getPeerToPeer()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s peertopeer off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getNmsCac(), ((GatewayMaster)gatewayMaster.get()).getNmsCac())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getNmsCac()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s nmscac on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getNmsCac() == null || "false".equalsIgnoreCase(String.valueOf(data.getNmsCac()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s nmscac off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getIsRecording(), ((GatewayMaster)gatewayMaster.get()).getIsRecording())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getIsRecording()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s rec on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getIsRecording() == null || "false".equalsIgnoreCase(String.valueOf(data.getIsRecording()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s rec off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getFailoverIsDnCause(), ((GatewayMaster)gatewayMaster.get()).getFailoverIsDnCause())) {
                if (data.getFailoverIsDnCause() != null && !data.getFailoverIsDnCause().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s failisdncause %s", data.getGwCode(), data.getFailoverIsDnCause()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getFailoverIsDnCause() == null || data.getFailoverIsDnCause().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s failisdncause reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getEfficiencyPer(), ((GatewayMaster)gatewayMaster.get()).getEfficiencyPer())) {
                if (data.getEfficiencyPer() != null && !data.getEfficiencyPer().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s gatewayefficiency %s", data.getGwCode(), data.getEfficiencyPer()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getEfficiencyPer() == null || data.getEfficiencyPer().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s gatewayefficiency reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getMaxOutDigit(), ((GatewayMaster)gatewayMaster.get()).getMaxOutDigit())) {
                if (data.getMaxOutDigit() != null && !data.getMaxOutDigit().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s maxoutdigit %s", data.getGwCode(), data.getMaxOutDigit()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getMaxOutDigit() == null || data.getMaxOutDigit().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s maxoutdigit reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getPriority(), ((GatewayMaster)gatewayMaster.get()).getPriority())) {
                if (data.getPriority() != null && !data.getPriority().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s priority %s", data.getGwCode(), data.getPriority()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getPriority() == null || data.getPriority().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s priority reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getTenantCode(), ((GatewayMaster)gatewayMaster.get()).getTenantCode())) {
                if (data.getTenantCode() != null && !data.getTenantCode().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s tenant %s", data.getGwCode(), data.getTenantCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getTenantCode() == null || data.getTenantCode().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s tenant reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getCallTimeout(), ((GatewayMaster)gatewayMaster.get()).getCallTimeout())) {
                if (data.getCallTimeout() != null && !data.getCallTimeout().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s calltimeout %s", data.getGwCode(), data.getCallTimeout()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getCallTimeout() == null || data.getCallTimeout().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s calltimeout reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getExtFailoverTimeout(), ((GatewayMaster)gatewayMaster.get()).getExtFailoverTimeout())) {
                if (data.getExtFailoverTimeout() != null && !data.getExtFailoverTimeout().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s failoverexttimeout %s", data.getGwCode(), data.getExtFailoverTimeout()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getExtFailoverTimeout() == null || data.getExtFailoverTimeout().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s failoverexttimeout reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getGatewayTestingCli(), ((GatewayMaster)gatewayMaster.get()).getGatewayTestingCli())) {
                if (data.getGatewayTestingCli() != null && !data.getGatewayTestingCli().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s gatewaytestingcli %s", data.getGwCode(), data.getGatewayTestingCli()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getGatewayTestingCli() == null || data.getGatewayTestingCli().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s gatewaytestingcli reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getMinDuration(), ((GatewayMaster)gatewayMaster.get()).getMinDuration())) {
                if (data.getMinDuration() != null && !data.getMinDuration().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s minduration %s", data.getGwCode(), data.getMinDuration()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getMinDuration() == null || data.getMinDuration().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s minduration reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getPulseInSecond(), ((GatewayMaster)gatewayMaster.get()).getPulseInSecond())) {
                if (data.getPulseInSecond() != null && !data.getPulseInSecond().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s pulse %s", data.getGwCode(), data.getPulseInSecond()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getPulseInSecond() == null || data.getPulseInSecond().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s pulse reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getTollFree(), ((GatewayMaster)gatewayMaster.get()).getTollFree())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getTollFree()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s tollfree on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getTollFree() == null || "false".equalsIgnoreCase(String.valueOf(data.getTollFree()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s tollfree off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getCallerStrip(), ((GatewayMaster)gatewayMaster.get()).getCallerStrip())) {
                if (data.getCallerStrip() != null && !data.getCallerStrip().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s callerstrip %s", data.getGwCode(), data.getCallerStrip()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getCallerStrip() == null || data.getCallerStrip().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s callerstrip reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getNumberStrip(), ((GatewayMaster)gatewayMaster.get()).getNumberStrip())) {
                if (data.getNumberStrip() != null && !data.getNumberStrip().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s numberstrip %s", data.getGwCode(), data.getNumberStrip()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getNumberStrip() == null || data.getCallerStrip().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s numberstrip reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getFailOverTry(), ((GatewayMaster)gatewayMaster.get()).getFailOverTry())) {
                if (data.getFailOverTry() != null && !data.getFailOverTry().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s failovertry %s", data.getGwCode(), data.getFailOverTry()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getFailOverTry() == null || data.getFailOverTry().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s failovertry reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getBeepInterval(), ((GatewayMaster)gatewayMaster.get()).getBeepInterval())) {
                if (data.getBeepInterval() != null && !data.getBeepInterval().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s beepinterval %s", data.getGwCode(), data.getBeepInterval()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getBeepInterval() == null || data.getBeepInterval().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s beepinterval reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getGwRange(), ((GatewayMaster)gatewayMaster.get()).getGwRange())) {
                if (data.getGwRange() != null && !data.getGwRange().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s range %s", data.getGwCode(), this.convertWithHyphen(data.getGwRange())));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getGwRange() == null || data.getGwRange().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s range reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getGwGroup(), ((GatewayMaster)gatewayMaster.get()).getGwGroup())) {
                if (data.getGwGroup() != null && !data.getGwGroup().toString().isEmpty()) {
                    if (data.getGwGroup() != null && data.getGwGroup().equalsIgnoreCase("CustomGroup")) {
                        cliServerCommandLog = new CLIServerCommandLog();
                        cliServerCommandLog.setCLICommand(String.format("gateway update %s gwgroup %s", data.getGwCode(), data.getGwGroupCustom()));
                        this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    } else {
                        cliServerCommandLog = new CLIServerCommandLog();
                        cliServerCommandLog.setCLICommand(String.format("gateway update %s gwgroup %s", data.getGwCode(), data.getGwGroup()));
                        this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                        logger.info(cliServerCommandLog.getCLICommand());
                    }
                } else if (data.getGwGroup() == null || data.getGwGroup().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s gwgroup reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getGwName(), ((GatewayMaster)gatewayMaster.get()).getGwName())) {
                if (data.getGwName() != null && !data.getGwName().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s name %s", data.getGwCode(), data.getGwName()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getGwName() == null || data.getGwName().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s name reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getFailoverMaxTry(), ((GatewayMaster)gatewayMaster.get()).getFailoverMaxTry())) {
                if (data.getFailoverMaxTry() != null && !data.getFailoverMaxTry().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s failovermaxtry %s", data.getGwCode(), data.getFailoverMaxTry()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getFailoverMaxTry() == null || data.getFailoverMaxTry().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s failovermaxtry reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getDialPlan(), ((GatewayMaster)gatewayMaster.get()).getDialString())) {
                if (data.getDialPlan() != null && !data.getDialPlan().toString().isEmpty()) {
                    if (data.getDialPlan().equalsIgnoreCase("sip")) {
                        cliServerCommandLog = new CLIServerCommandLog();
                        cliServerCommandLog.setCLICommand(String.format("gateway update %s dialplan %s", data.getGwCode(), "sofia/internal/$1@" + data.getDialValue()));
                        this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                        logger.info(cliServerCommandLog.getCLICommand());
                    } else if (data.getDialPlan().equalsIgnoreCase("pri")) {
                        cliServerCommandLog = new CLIServerCommandLog();
                        cliServerCommandLog.setCLICommand(String.format("gateway update %s dialplan %s", data.getGwCode(), "freeswitch/a/" + data.getDialValue()));
                        this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                        logger.info(cliServerCommandLog.getCLICommand());
                    } else if (data.getDialPlan().equalsIgnoreCase("custom")) {
                        cliServerCommandLog = new CLIServerCommandLog();
                        cliServerCommandLog.setCLICommand(String.format("gateway update %s dialplan %s", data.getGwCode(), data.getDialValue()));
                        this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                        logger.info(cliServerCommandLog.getCLICommand());
                    }
                } else if (data.getDialValue() == null || data.getDialValue().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s dialplan reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getCallerStrip(), ((GatewayMaster)gatewayMaster.get()).getCallerStrip())) {
                if (data.getCallerStrip() != null && !data.getCallerStrip().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s callerstrip %s", data.getGwCode(), data.getCallerStrip()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getCallerStrip() == null || data.getCallerStrip().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gateway update %s callerstrip reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
        } else {
            if (data.getAllowDTmfTone() != null) {
                ((GatewayMaster)gatewayMaster.get()).setAllowDTmfTone(data.getAllowDTmfTone());
            }
            if (data.getAllowExtendTime() != null) {
                ((GatewayMaster)gatewayMaster.get()).setAllowExtendTime(data.getAllowExtendTime());
            }
            if (data.getBeepInterval() != null) {
                ((GatewayMaster)gatewayMaster.get()).setBeepInterval(data.getBeepInterval());
            }
            if (data.getCacBandwidth() != null) {
                ((GatewayMaster)gatewayMaster.get()).setCacBandwidth(data.getCacBandwidth());
            }
            if (data.getCallTimeout() != null) {
                ((GatewayMaster)gatewayMaster.get()).setCallTimeout(data.getCallTimeout());
            }
            if (data.getCallerStrip() != null) {
                ((GatewayMaster)gatewayMaster.get()).setCallerStrip(data.getCallerStrip());
            }
            if (data.getCliPrefix() != null) {
                ((GatewayMaster)gatewayMaster.get()).setCliPrefix(data.getCliPrefix());
            }
            if (data.getCodec() != null) {
                ((GatewayMaster)gatewayMaster.get()).setCodec(data.getCodec());
            }
            if (data.getDialValue() != null && !data.getDialValue().isEmpty()) {
                if (data.getDialPlan().equals("sip")) {
                    ((GatewayMaster)gatewayMaster.get()).setDialString("sofia/internal/$1@" + data.getDialValue());
                } else if (data.getDialPlan().equals("pri")) {
                    ((GatewayMaster)gatewayMaster.get()).setDialString("freeswitch/a/" + data.getDialValue());
                } else if (data.getDialPlan().equals("custom")) {
                    ((GatewayMaster)gatewayMaster.get()).setDialString(data.getDialValue());
                }
            }
            if (data.getEfficiencyPer() != null) {
                ((GatewayMaster)gatewayMaster.get()).setEfficiencyPer(data.getEfficiencyPer());
            }
            if (data.getEnhancedDuration() != null) {
                ((GatewayMaster)gatewayMaster.get()).setEnhancedDuration(data.getEnhancedDuration());
            }
            if (data.getExtFailoverTimeout() != null) {
                ((GatewayMaster)gatewayMaster.get()).setExtFailoverTimeout(data.getExtFailoverTimeout());
            }
            if (data.getFailOverGateway() != null) {
                ((GatewayMaster)gatewayMaster.get()).setFailOverGateway(data.getFailOverGateway());
            }
            if (data.getFailOverNumber() != null) {
                ((GatewayMaster)gatewayMaster.get()).setFailOverNumber(data.getFailOverNumber());
            }
            if (data.getFailOverTry() != null) {
                ((GatewayMaster)gatewayMaster.get()).setFailOverTry(data.getFailOverTry());
            }
            if (data.getFailoverIsDnCause() != null) {
                ((GatewayMaster)gatewayMaster.get()).setFailoverIsDnCause(data.getFailoverIsDnCause());
            }
            if (data.getFailoverMaxTry() != null) {
                ((GatewayMaster)gatewayMaster.get()).setFailoverMaxTry(data.getFailoverMaxTry());
            }
            if (data.getGatewayControllerCode() != null) {
                ((GatewayMaster)gatewayMaster.get()).setGatewayControllerCode(data.getGatewayControllerCode());
            }
            if (data.getGatewayTestingCli() != null) {
                ((GatewayMaster)gatewayMaster.get()).setGatewayTestingCli(data.getGatewayTestingCli());
            }
            if (data.getGatewayTestingLastTryEpoch() != null) {
                ((GatewayMaster)gatewayMaster.get()).setGatewayTestingLastTryEpoch(data.getGatewayTestingLastTryEpoch());
            }
            if (data.getGatewayTestingNumber() != null) {
                ((GatewayMaster)gatewayMaster.get()).setGatewayTestingNumber(data.getGatewayTestingNumber());
            }
            if (data.getGwCode() != null) {
                ((GatewayMaster)gatewayMaster.get()).setGwCode(data.getGwCode());
            }
            if (data.getGwGroup() != null && data.getGwGroup().equals("CustomGroup")) {
                ((GatewayMaster)gatewayMaster.get()).setGwGroup(data.getGwGroupCustom());
            } else if (data.getGwGroup() != null) {
                ((GatewayMaster)gatewayMaster.get()).setGwGroup(data.getGwGroup());
            }
            if (data.getGwName() != null) {
                ((GatewayMaster)gatewayMaster.get()).setGwName(data.getGwName());
            }
            if (data.getGwRange() != null) {
                ((GatewayMaster)gatewayMaster.get()).setGwRange(this.convertWithHyphen(data.getGwRange()));
            }
            if (data.getGwType() != null && data.getGwType().equalsIgnoreCase("customType")) {
                ((GatewayMaster)gatewayMaster.get()).setGwType(data.getGwTypeCustom());
            } else if (data.getGwType() != null) {
                ((GatewayMaster)gatewayMaster.get()).setGwType(data.getGwType());
            }
            if (data.getHandleIsDnCause() != null) {
                ((GatewayMaster)gatewayMaster.get()).setHandleIsDnCause(data.getHandleIsDnCause());
            }
            if (data.getIsRecording() != null) {
                ((GatewayMaster)gatewayMaster.get()).setIsRecording(data.getIsRecording());
            }
            if (data.getLastCallEpoch() != null) {
                ((GatewayMaster)gatewayMaster.get()).setLastCallEpoch(data.getLastCallEpoch());
            }
            ((GatewayMaster)gatewayMaster.get()).setMaxChannel(data.getMaxChannel());
            if (data.getMaxOutDigit() != null) {
                ((GatewayMaster)gatewayMaster.get()).setMaxOutDigit(data.getMaxOutDigit());
            }
            if (data.getMinDuration() != null) {
                ((GatewayMaster)gatewayMaster.get()).setMinDuration(data.getMinDuration());
            }
            if (data.getNmsCac() != null) {
                ((GatewayMaster)gatewayMaster.get()).setNmsCac(data.getNmsCac());
            }
            if (data.getNumberStrip() != null) {
                ((GatewayMaster)gatewayMaster.get()).setNumberStrip(data.getNumberStrip());
            }
            if (data.getPeerToPeer() != null) {
                ((GatewayMaster)gatewayMaster.get()).setPeerToPeer(data.getPeerToPeer());
            }
            if (data.getPrefix() != null) {
                ((GatewayMaster)gatewayMaster.get()).setPrefix(data.getPrefix());
            }
            if (data.getPriority() != null) {
                ((GatewayMaster)gatewayMaster.get()).setPriority(data.getPriority());
            }
            if (data.getPulseInSecond() != null) {
                ((GatewayMaster)gatewayMaster.get()).setPulseInSecond(data.getPulseInSecond());
            }
            if (data.getPulseRate() != null) {
                ((GatewayMaster)gatewayMaster.get()).setPulseRate(data.getPulseRate());
            }
            if (data.getQSig() != null) {
                ((GatewayMaster)gatewayMaster.get()).setQSig(data.getQSig());
            }
            if (data.getTenantCode() != null) {
                ((GatewayMaster)gatewayMaster.get()).setTenantCode(data.getTenantCode());
            }
            if (data.getTollFree() != null) {
                ((GatewayMaster)gatewayMaster.get()).setTollFree(data.getTollFree());
            }
            this.gatewayMasterRepository.save(gatewayMaster.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("GatewayMaster Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = GatewayMasterSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.gatewayMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.gatewayMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<GatewayMasterModel> entityToModelConversion(List<GatewayMaster> gatewayMaster) {
        ArrayList<GatewayMasterModel> addValue = new ArrayList<GatewayMasterModel>();
        for (GatewayMaster data : gatewayMaster) {
            GatewayMasterModel gatewayMasterModel = new GatewayMasterModel();
            gatewayMasterModel.setId(data.getId());
            gatewayMasterModel.setGwCode(data.getGwCode());
            gatewayMasterModel.setGwType(data.getGwType());
            gatewayMasterModel.setGwName(data.getGwName());
            gatewayMasterModel.setGwRange(this.trimHyphen(data.getGwRange()));
            gatewayMasterModel.setDialPlan(this.getDialPlan(data.getDialString()));
            gatewayMasterModel.setDialValue(this.getDialValue(data.getDialString()));
            gatewayMasterModel.setDialString(data.getDialString());
            gatewayMasterModel.setPulseInSecond(data.getPulseInSecond());
            gatewayMasterModel.setPulseRate(data.getPulseRate());
            gatewayMasterModel.setCallTimeout(data.getCallTimeout());
            gatewayMasterModel.setMaxChannel(data.getMaxChannel());
            gatewayMasterModel.setNumberStrip(data.getNumberStrip());
            gatewayMasterModel.setCallerStrip(data.getCallerStrip());
            gatewayMasterModel.setGwGroup(data.getGwGroup());
            gatewayMasterModel.setNmsCac(data.getNmsCac());
            gatewayMasterModel.setIsRecording(data.getIsRecording());
            gatewayMasterModel.setQSig(data.getQSig());
            gatewayMasterModel.setFailOverGateway(data.getFailOverGateway());
            gatewayMasterModel.setFailoverIsDnCause(data.getFailoverIsDnCause());
            gatewayMasterModel.setAllowExtendTime(data.getAllowExtendTime());
            gatewayMasterModel.setMinDuration(data.getMinDuration());
            gatewayMasterModel.setEnhancedDuration(data.getEnhancedDuration());
            gatewayMasterModel.setBeepInterval(data.getBeepInterval());
            gatewayMasterModel.setTenantCode(data.getTenantCode());
            gatewayMasterModel.setLastCallEpoch(data.getLastCallEpoch());
            gatewayMasterModel.setEfficiencyPer(data.getEfficiencyPer());
            gatewayMasterModel.setCodec(data.getCodec());
            gatewayMasterModel.setFailoverMaxTry(data.getFailoverMaxTry());
            gatewayMasterModel.setFailOverTry(data.getFailOverTry());
            gatewayMasterModel.setPriority(data.getPriority());
            gatewayMasterModel.setPeerToPeer(data.getPeerToPeer());
            gatewayMasterModel.setMaxOutDigit(data.getMaxOutDigit());
            gatewayMasterModel.setPrefix(data.getPrefix());
            gatewayMasterModel.setGatewayControllerCode(data.getGatewayControllerCode());
            gatewayMasterModel.setGatewayTestingCli(data.getGatewayTestingCli());
            gatewayMasterModel.setGatewayTestingLastTryEpoch(data.getGatewayTestingLastTryEpoch());
            gatewayMasterModel.setHandleIsDnCause(data.getHandleIsDnCause());
            gatewayMasterModel.setFailOverNumber(data.getFailOverNumber());
            gatewayMasterModel.setExtFailoverTimeout(data.getExtFailoverTimeout());
            gatewayMasterModel.setCacBandwidth(data.getCacBandwidth());
            gatewayMasterModel.setCliPrefix(data.getCliPrefix());
            gatewayMasterModel.setTollFree(data.getTollFree());
            gatewayMasterModel.setAllowDTmfTone(data.getAllowDTmfTone());
            gatewayMasterModel.setGatewayTestingNumber(data.getGatewayTestingNumber());
            addValue.add(gatewayMasterModel);
        }
        return addValue;
    }

    public RequestResponse getAllGwCode() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<GatewayMasterDropdownModel> addValue = new ArrayList<GatewayMasterDropdownModel>();
        List list = (List)this.gatewayMasterRepository.findAll();
        if (!list.isEmpty()) {
            HashSet<String> uniqueAccessCodes = new HashSet<String>();
            for (GatewayMaster row : list) {
                if (!uniqueAccessCodes.add(row.getGwCode())) continue;
                GatewayMasterDropdownModel data = new GatewayMasterDropdownModel();
                data.setId(row.getId());
                data.setGwName(row.getGwName());
                data.setGwCode(row.getGwCode());
                data.setGwRange(row.getGwRange());
                data.setGwType(row.getGwType());
                data.setDialString(row.getDialString());
                data.setGwGroup(row.getGwGroup());
                addValue.add(data);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setData(addValue);
            returnValue.setMessage("list of unique gwCode");
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setData(Collections.emptyList());
            returnValue.setMessage("No any gwCode exist");
            logger.error(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getDataByGwCode(String gwCode) {
        RequestResponse returnValue = new RequestResponse();
        List<String> gwCodeList = Arrays.asList(gwCode.split(","));
        logger.info("list of Selected code is:{}", gwCodeList);
        List list = this.gatewayMasterRepository.findByGwCodeIn(gwCodeList);
        if (!list.isEmpty()) {
            ArrayList<GatewayMasterDropdownModel> addValue = new ArrayList<GatewayMasterDropdownModel>();
            for (GatewayMaster row : list) {
                GatewayMasterDropdownModel data = new GatewayMasterDropdownModel();
                data.setId(row.getId());
                data.setGwName(row.getGwName());
                data.setGwCode(row.getGwCode());
                data.setGwRange(row.getGwRange());
                data.setGwType(row.getGwType());
                data.setDialString(row.getDialString());
                data.setGwGroup(row.getGwGroup());
                addValue.add(data);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Size of list:" + addValue.size());
            returnValue.setData(addValue);
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Data not found");
            returnValue.setData(Collections.emptyList());
        }
        return returnValue;
    }

    public RequestResponse getAllGwGroup() {
        List gatewayMasterList = (List)this.gatewayMasterRepository.findAll();
        List inboundGatewayList = (List)this.inboundGatewayRepository.findAll();
        HashSet<String> uniqueGwGroup = new HashSet<String>();
        ArrayList<GatewayMasterDropdownModel> addValue = new ArrayList<GatewayMasterDropdownModel>();
        uniqueGwGroup.add("CustomGroup");
        for (GatewayMaster gatewayMaster : gatewayMasterList) {
            if (gatewayMaster.getGwGroup() == null || gatewayMaster.getGwGroup().isEmpty()) continue;
            uniqueGwGroup.add(gatewayMaster.getGwGroup());
        }
        for (InboundGateway inboundGateway : inboundGatewayList) {
            if (inboundGateway.getOutboundGroupGw() == null || inboundGateway.getOutboundGroupGw().isEmpty()) continue;
            uniqueGwGroup.add(inboundGateway.getOutboundGroupGw());
        }
        for (String gwGroup : uniqueGwGroup) {
            GatewayMasterDropdownModel data = new GatewayMasterDropdownModel();
            data.setGwGroup(gwGroup);
            addValue.add(data);
        }
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Size of list: " + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public String convertWithHyphen(String value) {
        if (value == null || value.trim().isEmpty()) {
            return "";
        }
        String[] numbers = value.split(",");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < numbers.length; ++i) {
            result.append("-").append(numbers[i].trim());
            if (i >= numbers.length - 1) continue;
            result.append(",");
        }
        return result.toString();
    }

    public String trimHyphen(String value) {
        if (value == null || value.trim().isEmpty()) {
            return "";
        }
        String[] numbers = value.split(",");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < numbers.length; ++i) {
            String numStr = numbers[i].trim();
            String convertedNum = numStr.startsWith("-") ? numStr.substring(1) : numStr;
            result.append(convertedNum);
            if (i >= numbers.length - 1) continue;
            result.append(",");
        }
        return result.toString();
    }

    public String getDialPlan(String dialString) {
        if (dialString != null && !dialString.equals("")) {
            if (dialString.contains("sofia/internal")) {
                return "sip";
            }
            if (dialString.contains("freeswitch/a")) {
                return "pri";
            }
            return "custom";
        }
        return "";
    }

    public String getDialValue(String dialString) {
        Pattern pattern;
        Matcher matcher;
        if (dialString == null || dialString.equals("")) {
            return "";
        }
        if (dialString.contains("freeswitch/a/")) {
            return dialString.substring(dialString.lastIndexOf("/") + 1);
        }
        if (dialString.contains("sofia/internal/") && (matcher = (pattern = Pattern.compile("@([0-9.]+)")).matcher(dialString)).find()) {
            return matcher.group(1);
        }
        return dialString;
    }

    public RequestResponse getAllGwCodeByQuery() {
        List list = (List)this.gatewayMasterRepository.findAll();
        ArrayList<GatewayMasterDropdownModel> addValue = new ArrayList<GatewayMasterDropdownModel>();
        RequestResponse returnValue = new RequestResponse();
        for (GatewayMaster gatewayMaster : list) {
            GatewayMasterDropdownModel data = new GatewayMasterDropdownModel();
            GatewayController gatewayController = this.gatewayControllerRepository.findByGatewayCode(gatewayMaster.getGatewayControllerCode());
            String gwCode = gatewayController != null && gatewayController.getGatewayCode() != null && !gatewayController.getGatewayCode().isEmpty() ? gatewayController.getGatewayCode() : gatewayMaster.getGwCode();
            data.setGwCode(gwCode);
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK " + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

