/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.cos.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.OutboundCos;
import com.coraltele.db.telephony.pbx.repository.OutboundCosRepository;
import com.coraltele.db.telephony.pbx.specification.OutboundCosSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.CliCommandData;
import com.coraltele.model.InputAction;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.cLIServerCommandLog.service.CLIServerCommandLogService;
import com.coraltele.service.pbx.cos.model.OutboundCosModel;
import com.coraltele.service.pbx.cos.model.OutboundCosMultipleUpdates;
import com.coraltele.service.pbx.cos.model.SingleCosModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class OutboundCosService {
    private static final Logger logger = LogManager.getLogger(OutboundCosService.class);
    @Autowired
    private OutboundCosRepository outboundCosRepository;
    @Autowired
    private CLIServerCommandLogService cLIServerCommandLogService;

    public boolean checkOutboundCosWithZerosCos() {
        Optional outboundCos = this.outboundCosRepository.findByCos("0");
        return outboundCos.isPresent();
    }

    public void createOutboundCoswithZerosCos() {
        OutboundCos outboundData = new OutboundCos();
        outboundData.setCos("0");
        outboundData.setIsd(Boolean.valueOf(true));
        outboundData.setStd(Boolean.valueOf(true));
        outboundData.setLoc(Boolean.valueOf(true));
        outboundData.setIc(Boolean.valueOf(true));
        this.outboundCosRepository.save((Object)outboundData);
    }

    public RequestResponse createOutboundCos(OutboundCosModel data) {
        logger.debug("create new OutboundCos : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional info = this.outboundCosRepository.findByCos(data.getCos());
            if (info.isPresent()) {
                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                returnValue.setMessage("Cos already exists");
                returnValue.setMessageDetail("Please enter different cos");
                return returnValue;
            }
            OutboundCos outboundCos = new OutboundCos();
            outboundCos.setCos(data.getCos());
            outboundCos.setCosGroup(data.getCosGroup());
            if (data.getAcdPickup() != null) {
                outboundCos.setAcdPickup(data.getAcdPickup());
            } else {
                outboundCos.setAcdPickup(Boolean.valueOf(false));
            }
            if (data.getAllowBgm() != null) {
                outboundCos.setAllowBgm(data.getAllowBgm());
            } else {
                outboundCos.setAllowBgm(Boolean.valueOf(false));
            }
            if (data.getAllowCallbackAfterHold() != null) {
                outboundCos.setAllowCallbackAfterHold(data.getAllowCallbackAfterHold());
            } else {
                outboundCos.setAllowCallbackAfterHold(Boolean.valueOf(false));
            }
            outboundCos.setAllowEmergencyConf(data.getAllowEmergencyConf());
            if (data.getAllowExtensionService() != null) {
                outboundCos.setAllowExtensionService(data.getAllowExtensionService());
            } else {
                outboundCos.setAllowExtensionService(Boolean.valueOf(true));
            }
            outboundCos.setAllowPa(data.getAllowPa());
            outboundCos.setAllowTenant(data.getAllowTenant());
            if (data.getArb() != null) {
                outboundCos.setArb(data.getArb());
            } else {
                outboundCos.setArb(Boolean.valueOf(false));
            }
            if (data.getBgn() != null) {
                outboundCos.setBgn(data.getBgn());
            } else {
                outboundCos.setBgn(Boolean.valueOf(false));
            }
            if (data.getCallPark() != null) {
                outboundCos.setCallPark(data.getCallPark());
            } else {
                outboundCos.setCallPark(Boolean.valueOf(true));
            }
            if (data.getCb() != null) {
                outboundCos.setCb(data.getCb());
            } else {
                outboundCos.setCb(Boolean.valueOf(true));
            }
            if (data.getCampOn() != null) {
                outboundCos.setCampOn(data.getCampOn());
            } else {
                outboundCos.setCampOn(Boolean.valueOf(false));
            }
            if (data.getCliExternalBlock() != null) {
                outboundCos.setCliExternalBlock(data.getCliExternalBlock());
            } else {
                outboundCos.setCliExternalBlock(Boolean.valueOf(false));
            }
            if (data.getCliForwardOnTransfer() != null) {
                outboundCos.setCliForwardOnTransfer(data.getCliForwardOnTransfer());
            } else {
                outboundCos.setCliForwardOnTransfer(Boolean.valueOf(true));
            }
            if (data.getCliInternalBlock() != null) {
                outboundCos.setCliInternalBlock(data.getCliInternalBlock());
            } else {
                outboundCos.setCliInternalBlock(Boolean.valueOf(false));
            }
            if (data.getConferenceBeep() != null) {
                outboundCos.setConferenceBeep(data.getConferenceBeep());
            } else {
                outboundCos.setConferenceBeep(Boolean.valueOf(false));
            }
            if (data.getCpe() != null) {
                outboundCos.setCpe(data.getCpe());
            } else {
                outboundCos.setCpe(Boolean.valueOf(false));
            }
            if (data.getCpg() != null) {
                outboundCos.setCpg(data.getCpg());
            } else {
                outboundCos.setCpg(Boolean.valueOf(false));
            }
            if (data.getDropCall() != null) {
                outboundCos.setDropCall(data.getDropCall());
            } else {
                outboundCos.setDropCall(Boolean.valueOf(false));
            }
            if (data.getExtensionTransfer() != null) {
                outboundCos.setExtensionTransfer(data.getExtensionTransfer());
            } else {
                outboundCos.setExtensionTransfer(Boolean.valueOf(false));
            }
            if (data.getGConfCall() != null) {
                outboundCos.setGConfCall(data.getGConfCall());
            } else {
                outboundCos.setGConfCall(Boolean.valueOf(false));
            }
            outboundCos.setGwOutBound(data.getGwOutBound());
            if (data.getIbe() != null) {
                outboundCos.setIbe(data.getIbe());
            } else {
                outboundCos.setIbe(Boolean.valueOf(false));
            }
            if (data.getIc() != null) {
                outboundCos.setIc(data.getIc());
            } else {
                outboundCos.setIc(Boolean.valueOf(false));
            }
            if (data.getIsConferenceModerator() != null) {
                outboundCos.setIsConferenceModerator(data.getIsConferenceModerator());
            } else {
                outboundCos.setIsConferenceModerator(Boolean.valueOf(false));
            }
            if (data.getIsd() != null) {
                outboundCos.setIsd(data.getIsd());
            } else {
                outboundCos.setIsd(Boolean.valueOf(false));
            }
            if (data.getLoc() != null) {
                outboundCos.setLoc(data.getLoc());
            } else {
                outboundCos.setLoc(Boolean.valueOf(false));
            }
            if (data.getLongTalkBeep() != null) {
                outboundCos.setLongTalkBeep(data.getLongTalkBeep());
            } else {
                outboundCos.setLongTalkBeep(Boolean.valueOf(true));
            }
            if (data.getOutBoundGroupGw() != null) {
                outboundCos.setOutBoundGroupGw(data.getOutBoundGroupGw());
            } else {
                outboundCos.setOutBoundGroupGw(data.getOutBoundGroupGw());
            }
            if (data.getOverRideIBedTmf() != null) {
                outboundCos.setOverRideIBedTmf(data.getOverRideIBedTmf());
            } else {
                outboundCos.setOverRideIBedTmf(Boolean.valueOf(false));
            }
            if (data.getPaging() != null) {
                outboundCos.setPaging(data.getPaging());
            } else {
                outboundCos.setPaging(Boolean.valueOf(false));
            }
            if (data.getParkConf() != null) {
                outboundCos.setParkConf(data.getParkConf());
            } else {
                outboundCos.setParkConf(Boolean.valueOf(false));
            }
            if (data.getRdl() != null) {
                outboundCos.setRdl(data.getRdl());
            } else {
                outboundCos.setRdl(Boolean.valueOf(true));
            }
            outboundCos.setSNmpTrapEnabledOn(data.getSNmpTrapEnabledOn());
            if (data.getSecretaryBypass() != null) {
                outboundCos.setSecretaryBypass(data.getSecretaryBypass());
            } else {
                outboundCos.setSecretaryBypass(Boolean.valueOf(false));
            }
            if (data.getSep() != null) {
                outboundCos.setSep(data.getSep());
            } else {
                outboundCos.setSep(Boolean.valueOf(false));
            }
            if (data.getStd() != null) {
                outboundCos.setStd(data.getStd());
            } else {
                outboundCos.setStd(Boolean.valueOf(false));
            }
            if (data.getTac() != null) {
                outboundCos.setTac(data.getTac());
            } else {
                outboundCos.setTac(Boolean.valueOf(false));
            }
            if (data.getTransferRecall() != null) {
                outboundCos.setTransferRecall(data.getTransferRecall());
            } else {
                outboundCos.setTransferRecall(Boolean.valueOf(false));
            }
            if (data.getTrunkBArgIn() != null) {
                outboundCos.setTrunkBArgIn(data.getTrunkBArgIn());
            } else {
                outboundCos.setTrunkBArgIn(Boolean.valueOf(false));
            }
            if (data.getTrunkFailOver() != null) {
                outboundCos.setTrunkFailOver(data.getTrunkFailOver());
            } else {
                outboundCos.setTrunkFailOver(Boolean.valueOf(true));
            }
            if (data.getTrunkToTrunkTrFr() != null) {
                outboundCos.setTrunkToTrunkTrFr(data.getTrunkToTrunkTrFr());
            } else {
                outboundCos.setTrunkToTrunkTrFr(Boolean.valueOf(false));
            }
            if (data.getVMacs() != null) {
                outboundCos.setVMacs(data.getVMacs());
            } else {
                outboundCos.setVMacs(Boolean.valueOf(false));
            }
            if (data.getWhisper() != null) {
                outboundCos.setWhisper(data.getWhisper());
            } else {
                outboundCos.setWhisper(Boolean.valueOf(false));
            }
            if (data.getCf() != null) {
                outboundCos.setCf(data.getCf());
            } else {
                outboundCos.setCf(Boolean.valueOf(false));
            }
            if (data.getAllowgd() != null) {
                outboundCos.setAllowgd(data.getAllowgd());
            } else {
                outboundCos.setAllowgd(Boolean.valueOf(false));
            }
            if (data.getCallForwardExternal() != null) {
                outboundCos.setCallForwardExternal(data.getCallForwardExternal());
            } else {
                outboundCos.setCallForwardExternal(Boolean.valueOf(true));
            }
            if (data.getForcedDnd() != null) {
                outboundCos.setForcedDnd(data.getForcedDnd());
            } else {
                outboundCos.setForcedDnd(Boolean.valueOf(false));
            }
            if (data.getManualDnd() != null) {
                outboundCos.setManualDnd(data.getManualDnd());
            } else {
                outboundCos.setManualDnd(Boolean.valueOf(false));
            }
            this.outboundCosRepository.save((Object)outboundCos);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("OutboundCos Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create OutboundCos");
            returnValue.setMessageDetail("Contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional outboundCos = this.outboundCosRepository.findById(id);
            if (outboundCos.isPresent()) {
                OutboundCosModel data = new OutboundCosModel();
                data.setId(((OutboundCos)outboundCos.get()).getId().intValue());
                data.setAcdPickup(((OutboundCos)outboundCos.get()).getAcdPickup());
                data.setAllowBgm(((OutboundCos)outboundCos.get()).getAllowBgm());
                data.setAllowCallbackAfterHold(((OutboundCos)outboundCos.get()).getAllowCallbackAfterHold());
                data.setAllowEmergencyConf(((OutboundCos)outboundCos.get()).getAllowEmergencyConf());
                data.setAllowExtensionService(((OutboundCos)outboundCos.get()).getAllowExtensionService());
                data.setAllowPa(((OutboundCos)outboundCos.get()).getAllowPa());
                data.setAllowTenant(((OutboundCos)outboundCos.get()).getAllowTenant());
                data.setArb(((OutboundCos)outboundCos.get()).getArb());
                data.setBgn(((OutboundCos)outboundCos.get()).getBgn());
                data.setCallPark(((OutboundCos)outboundCos.get()).getCallPark());
                data.setCampOn(((OutboundCos)outboundCos.get()).getCampOn());
                data.setCb(((OutboundCos)outboundCos.get()).getCb());
                data.setCf(((OutboundCos)outboundCos.get()).getCf());
                data.setCliExternalBlock(((OutboundCos)outboundCos.get()).getCliExternalBlock());
                data.setCliForwardOnTransfer(((OutboundCos)outboundCos.get()).getCliForwardOnTransfer());
                data.setCliInternalBlock(((OutboundCos)outboundCos.get()).getCliInternalBlock());
                data.setConferenceBeep(((OutboundCos)outboundCos.get()).getConferenceBeep());
                data.setCos(((OutboundCos)outboundCos.get()).getCos());
                data.setCosGroup(((OutboundCos)outboundCos.get()).getCosGroup());
                data.setCpe(((OutboundCos)outboundCos.get()).getCpe());
                data.setCpg(((OutboundCos)outboundCos.get()).getCpg());
                data.setDropCall(((OutboundCos)outboundCos.get()).getDropCall());
                data.setExtensionTransfer(((OutboundCos)outboundCos.get()).getExtensionTransfer());
                data.setGConfCall(((OutboundCos)outboundCos.get()).getGConfCall());
                data.setGwOutBound(((OutboundCos)outboundCos.get()).getGwOutBound());
                data.setIbe(((OutboundCos)outboundCos.get()).getIbe());
                data.setIc(((OutboundCos)outboundCos.get()).getIc());
                data.setIsConferenceModerator(((OutboundCos)outboundCos.get()).getIsConferenceModerator());
                data.setIsd(((OutboundCos)outboundCos.get()).getIsd());
                data.setLoc(((OutboundCos)outboundCos.get()).getLoc());
                data.setLongTalkBeep(((OutboundCos)outboundCos.get()).getLongTalkBeep());
                data.setOutBoundGroupGw(((OutboundCos)outboundCos.get()).getOutBoundGroupGw());
                data.setOverRideIBedTmf(((OutboundCos)outboundCos.get()).getOverRideIBedTmf());
                data.setPaging(((OutboundCos)outboundCos.get()).getPaging());
                data.setParkConf(((OutboundCos)outboundCos.get()).getParkConf());
                data.setRdl(((OutboundCos)outboundCos.get()).getRdl());
                data.setSNmpTrapEnabledOn(((OutboundCos)outboundCos.get()).getSNmpTrapEnabledOn());
                data.setSecretaryBypass(((OutboundCos)outboundCos.get()).getSecretaryBypass());
                data.setSep(((OutboundCos)outboundCos.get()).getSep());
                data.setStd(((OutboundCos)outboundCos.get()).getStd());
                data.setTac(((OutboundCos)outboundCos.get()).getTac());
                data.setTransferRecall(((OutboundCos)outboundCos.get()).getTransferRecall());
                data.setTrunkBArgIn(((OutboundCos)outboundCos.get()).getTrunkBArgIn());
                data.setTrunkFailOver(((OutboundCos)outboundCos.get()).getTrunkFailOver());
                data.setTrunkToTrunkTrFr(((OutboundCos)outboundCos.get()).getTrunkToTrunkTrFr());
                data.setVMacs(((OutboundCos)outboundCos.get()).getVMacs());
                data.setWhisper(((OutboundCos)outboundCos.get()).getWhisper());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OutboundCos Found");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateOutboundCosById(HttpServletRequest request, OutboundCosModel data, Principal principal) throws IOException {
        logger.debug("Update OutboundCos {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional outboundCos = this.outboundCosRepository.findById(data.getId());
        if (!outboundCos.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("OutboundCos not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getAcdPickup() != null) {
            ((OutboundCos)outboundCos.get()).setAcdPickup(data.getAcdPickup());
        }
        if (data.getAllowBgm() != null) {
            ((OutboundCos)outboundCos.get()).setAllowBgm(data.getAllowBgm());
        }
        if (data.getAllowCallbackAfterHold() != null) {
            ((OutboundCos)outboundCos.get()).setAllowCallbackAfterHold(data.getAllowCallbackAfterHold());
        }
        if (data.getAllowEmergencyConf() != null && !data.getAllowEmergencyConf().equals("")) {
            ((OutboundCos)outboundCos.get()).setAllowEmergencyConf(data.getAllowEmergencyConf());
        }
        if (data.getAllowExtensionService() != null) {
            ((OutboundCos)outboundCos.get()).setAllowExtensionService(data.getAllowExtensionService());
        }
        if (data.getAllowgd() != null) {
            ((OutboundCos)outboundCos.get()).setAllowgd(data.getAllowgd());
        }
        if (data.getAllowPa() != null && !data.getAllowPa().equals("")) {
            ((OutboundCos)outboundCos.get()).setAllowPa(data.getAllowPa());
        }
        if (data.getAllowTenant() != null) {
            ((OutboundCos)outboundCos.get()).setAllowTenant(data.getAllowTenant());
        }
        if (data.getArb() != null) {
            ((OutboundCos)outboundCos.get()).setArb(data.getArb());
        }
        if (data.getBgn() != null) {
            ((OutboundCos)outboundCos.get()).setBgn(data.getBgn());
        }
        if (data.getCallPark() != null) {
            ((OutboundCos)outboundCos.get()).setCallPark(data.getCallPark());
        }
        if (data.getCampOn() != null) {
            ((OutboundCos)outboundCos.get()).setCampOn(data.getCampOn());
        }
        if (data.getCb() != null) {
            ((OutboundCos)outboundCos.get()).setCb(data.getCb());
        }
        if (data.getCf() != null) {
            ((OutboundCos)outboundCos.get()).setCf(data.getCf());
        }
        if (data.getCliExternalBlock() != null) {
            ((OutboundCos)outboundCos.get()).setCliExternalBlock(data.getCliExternalBlock());
        }
        if (data.getCliForwardOnTransfer() != null) {
            ((OutboundCos)outboundCos.get()).setCliForwardOnTransfer(data.getCliForwardOnTransfer());
        }
        if (data.getCliInternalBlock() != null) {
            ((OutboundCos)outboundCos.get()).setCliInternalBlock(data.getCliInternalBlock());
        }
        if (data.getConferenceBeep() != null) {
            ((OutboundCos)outboundCos.get()).setConferenceBeep(data.getConferenceBeep());
        }
        if (data.getCos() != null && !data.getCos().equals("")) {
            ((OutboundCos)outboundCos.get()).setCos(data.getCos());
        }
        if (data.getCosGroup() != null) {
            ((OutboundCos)outboundCos.get()).setCosGroup(data.getCosGroup());
        }
        if (data.getCpe() != null) {
            ((OutboundCos)outboundCos.get()).setCpe(data.getCpe());
        }
        if (data.getCpg() != null) {
            ((OutboundCos)outboundCos.get()).setCpg(data.getCpg());
        }
        if (data.getDropCall() != null) {
            ((OutboundCos)outboundCos.get()).setDropCall(data.getDropCall());
        }
        if (data.getExtensionTransfer() != null) {
            ((OutboundCos)outboundCos.get()).setExtensionTransfer(data.getExtensionTransfer());
        }
        if (data.getGConfCall() != null) {
            ((OutboundCos)outboundCos.get()).setGConfCall(data.getGConfCall());
        }
        if (data.getGwOutBound() != null && !data.getGwOutBound().equals("")) {
            ((OutboundCos)outboundCos.get()).setGwOutBound(data.getGwOutBound());
        }
        if (data.getIbe() != null) {
            ((OutboundCos)outboundCos.get()).setIbe(data.getIbe());
        }
        if (data.getIc() != null) {
            ((OutboundCos)outboundCos.get()).setIc(data.getIc());
        }
        if (data.getIsConferenceModerator() != null) {
            ((OutboundCos)outboundCos.get()).setIsConferenceModerator(data.getIsConferenceModerator());
        }
        if (data.getIsd() != null) {
            ((OutboundCos)outboundCos.get()).setIsd(data.getIsd());
        }
        if (data.getLoc() != null) {
            ((OutboundCos)outboundCos.get()).setLoc(data.getLoc());
        }
        if (data.getLongTalkBeep() != null) {
            ((OutboundCos)outboundCos.get()).setLongTalkBeep(data.getLongTalkBeep());
        }
        if (data.getOutBoundGroupGw() != null && !data.getOutBoundGroupGw().equals("")) {
            ((OutboundCos)outboundCos.get()).setOutBoundGroupGw(data.getOutBoundGroupGw());
        }
        if (data.getOverRideIBedTmf() != null) {
            ((OutboundCos)outboundCos.get()).setOverRideIBedTmf(data.getOverRideIBedTmf());
        }
        if (data.getPaging() != null) {
            ((OutboundCos)outboundCos.get()).setPaging(data.getPaging());
        }
        if (data.getParkConf() != null) {
            ((OutboundCos)outboundCos.get()).setParkConf(data.getParkConf());
        }
        if (data.getRdl() != null) {
            ((OutboundCos)outboundCos.get()).setRdl(data.getRdl());
        }
        if (data.getSNmpTrapEnabledOn() != null) {
            ((OutboundCos)outboundCos.get()).setSNmpTrapEnabledOn(data.getSNmpTrapEnabledOn());
        }
        if (data.getSecretaryBypass() != null) {
            ((OutboundCos)outboundCos.get()).setSecretaryBypass(data.getSecretaryBypass());
        }
        if (data.getSep() != null) {
            ((OutboundCos)outboundCos.get()).setSep(data.getSep());
        }
        if (data.getStd() != null) {
            ((OutboundCos)outboundCos.get()).setStd(data.getStd());
        }
        if (data.getTac() != null) {
            ((OutboundCos)outboundCos.get()).setTac(data.getTac());
        }
        if (data.getTransferRecall() != null) {
            ((OutboundCos)outboundCos.get()).setTransferRecall(data.getTransferRecall());
        }
        if (data.getTrunkBArgIn() != null) {
            ((OutboundCos)outboundCos.get()).setTrunkBArgIn(data.getTrunkBArgIn());
        }
        if (data.getTrunkFailOver() != null) {
            ((OutboundCos)outboundCos.get()).setTrunkFailOver(data.getTrunkFailOver());
        }
        if (data.getTrunkToTrunkTrFr() != null) {
            ((OutboundCos)outboundCos.get()).setTrunkToTrunkTrFr(data.getTrunkToTrunkTrFr());
        }
        if (data.getVMacs() != null) {
            ((OutboundCos)outboundCos.get()).setVMacs(data.getVMacs());
        }
        if (data.getWhisper() != null) {
            ((OutboundCos)outboundCos.get()).setWhisper(data.getWhisper());
        }
        if (data.getForcedDnd() != null) {
            ((OutboundCos)outboundCos.get()).setForcedDnd(data.getForcedDnd());
        }
        if (data.getManualDnd() != null) {
            ((OutboundCos)outboundCos.get()).setManualDnd(data.getManualDnd());
        }
        this.outboundCosRepository.save(outboundCos.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("OutboundCos Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateAll(HttpServletRequest request, OutboundCosMultipleUpdates data, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        for (Integer id : data.getIds()) {
            Optional outboundCos = this.outboundCosRepository.findById((Object)id);
            if (!outboundCos.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("outboundCos not found");
                continue;
            }
            this.saveData(request, (OutboundCos)outboundCos.get(), authentication);
            if (data.getAcdPickup() != null) {
                ((OutboundCos)outboundCos.get()).setAcdPickup(data.getAcdPickup());
            }
            if (data.getAllowBgm() != null) {
                ((OutboundCos)outboundCos.get()).setAllowBgm(data.getAllowBgm());
            }
            if (data.getAllowCallbackAfterHold() != null) {
                ((OutboundCos)outboundCos.get()).setAllowCallbackAfterHold(data.getAllowCallbackAfterHold());
            }
            if (data.getAllowEmergencyConf() != null) {
                ((OutboundCos)outboundCos.get()).setAllowEmergencyConf(data.getAllowEmergencyConf());
            }
            if (data.getAllowExtensionService() != null) {
                ((OutboundCos)outboundCos.get()).setAllowExtensionService(data.getAllowExtensionService());
            }
            if (data.getAllowPa() != null) {
                ((OutboundCos)outboundCos.get()).setAllowPa(data.getAllowPa());
            }
            if (data.getAllowTenant() != null) {
                ((OutboundCos)outboundCos.get()).setAllowTenant(data.getAllowTenant());
            }
            if (data.getArb() != null) {
                ((OutboundCos)outboundCos.get()).setArb(data.getArb());
            }
            if (data.getBgn() != null) {
                ((OutboundCos)outboundCos.get()).setBgn(data.getBgn());
            }
            if (data.getCallPark() != null) {
                ((OutboundCos)outboundCos.get()).setCallPark(data.getCallPark());
            }
            if (data.getCampOn() != null) {
                ((OutboundCos)outboundCos.get()).setCampOn(data.getCampOn());
            }
            if (data.getCb() != null) {
                ((OutboundCos)outboundCos.get()).setCb(data.getCb());
            }
            if (data.getCf() != null) {
                ((OutboundCos)outboundCos.get()).setCf(data.getCf());
            }
            if (data.getCliExternalBlock() != null) {
                ((OutboundCos)outboundCos.get()).setCliExternalBlock(data.getCliExternalBlock());
            }
            if (data.getCliForwardOnTransfer() != null) {
                ((OutboundCos)outboundCos.get()).setCliForwardOnTransfer(data.getCliForwardOnTransfer());
            }
            if (data.getCliInternalBlock() != null) {
                ((OutboundCos)outboundCos.get()).setCliInternalBlock(data.getCliInternalBlock());
            }
            if (data.getConferenceBeep() != null) {
                ((OutboundCos)outboundCos.get()).setConferenceBeep(data.getConferenceBeep());
            }
            if (data.getCos() != null) {
                ((OutboundCos)outboundCos.get()).setCos(data.getCos());
            }
            if (data.getCosGroup() != null && data.getCosGroup().equals("")) {
                ((OutboundCos)outboundCos.get()).setCosGroup(data.getCosGroup());
            }
            if (data.getCpe() != null) {
                ((OutboundCos)outboundCos.get()).setCpe(data.getCpe());
            }
            if (data.getCpg() != null) {
                ((OutboundCos)outboundCos.get()).setCpg(data.getCpg());
            }
            if (data.getDropCall() != null) {
                ((OutboundCos)outboundCos.get()).setDropCall(data.getDropCall());
            }
            if (data.getExtensionTransfer() != null) {
                ((OutboundCos)outboundCos.get()).setExtensionTransfer(data.getExtensionTransfer());
            }
            if (data.getGConfCall() != null) {
                ((OutboundCos)outboundCos.get()).setGConfCall(data.getGConfCall());
            }
            if (data.getGwOutBound() != null) {
                ((OutboundCos)outboundCos.get()).setGwOutBound(data.getGwOutBound());
            }
            if (data.getIbe() != null) {
                ((OutboundCos)outboundCos.get()).setIbe(data.getIbe());
            }
            if (data.getIc() != null) {
                ((OutboundCos)outboundCos.get()).setIc(data.getIc());
            }
            if (data.getIsConferenceModerator() != null) {
                ((OutboundCos)outboundCos.get()).setIsConferenceModerator(data.getIsConferenceModerator());
            }
            if (data.getIsd() != null) {
                ((OutboundCos)outboundCos.get()).setIsd(data.getIsd());
            }
            if (data.getLoc() != null) {
                ((OutboundCos)outboundCos.get()).setLoc(data.getLoc());
            }
            if (data.getLongTalkBeep() != null) {
                ((OutboundCos)outboundCos.get()).setLongTalkBeep(data.getLongTalkBeep());
            }
            if (data.getOutBoundGroupGw() != null) {
                ((OutboundCos)outboundCos.get()).setOutBoundGroupGw(data.getOutBoundGroupGw());
            }
            if (data.getOverRideIBedTmf() != null) {
                ((OutboundCos)outboundCos.get()).setOverRideIBedTmf(data.getOverRideIBedTmf());
            }
            if (data.getPaging() != null) {
                ((OutboundCos)outboundCos.get()).setPaging(data.getPaging());
            }
            if (data.getParkConf() != null) {
                ((OutboundCos)outboundCos.get()).setParkConf(data.getParkConf());
            }
            if (data.getRdl() != null) {
                ((OutboundCos)outboundCos.get()).setRdl(data.getRdl());
            }
            if (data.getSNmpTrapEnabledOn() != null) {
                ((OutboundCos)outboundCos.get()).setSNmpTrapEnabledOn(data.getSNmpTrapEnabledOn());
            }
            if (data.getSecretaryBypass() != null) {
                ((OutboundCos)outboundCos.get()).setSecretaryBypass(data.getSecretaryBypass());
            }
            if (data.getSep() != null) {
                ((OutboundCos)outboundCos.get()).setSep(data.getSep());
            }
            if (data.getStd() != null) {
                ((OutboundCos)outboundCos.get()).setStd(data.getStd());
            }
            if (data.getTac() != null) {
                ((OutboundCos)outboundCos.get()).setTac(data.getTac());
            }
            if (data.getTransferRecall() != null) {
                ((OutboundCos)outboundCos.get()).setTransferRecall(data.getTransferRecall());
            }
            if (data.getTrunkBArgIn() != null) {
                ((OutboundCos)outboundCos.get()).setTrunkBArgIn(data.getTrunkBArgIn());
            }
            if (data.getTrunkFailOver() != null) {
                ((OutboundCos)outboundCos.get()).setTrunkFailOver(data.getTrunkFailOver());
            }
            if (data.getTrunkToTrunkTrFr() != null) {
                ((OutboundCos)outboundCos.get()).setTrunkToTrunkTrFr(data.getTrunkToTrunkTrFr());
            }
            if (data.getVMacs() != null) {
                ((OutboundCos)outboundCos.get()).setVMacs(data.getVMacs());
            }
            if (data.getWhisper() != null) {
                ((OutboundCos)outboundCos.get()).setWhisper(data.getWhisper());
            }
            this.outboundCosRepository.save(outboundCos.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("outboundCos Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse delete(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional inboundCos = this.outboundCosRepository.findById(ids.intValue());
            if (inboundCos.isPresent()) {
                addValue.add(inboundCos.get());
                this.outboundCosRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records deleted successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public void saveData(HttpServletRequest request, OutboundCos data, Authentication authentication) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
        Map newMap = (Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), Map.class);
        Set entrySet = newMap.entrySet();
        Iterator iterator = entrySet.iterator();
        ArrayList<InputAction> addValue = new ArrayList<InputAction>();
        CliCommandData cliCommandData = new CliCommandData();
        try {
            if (data.getId() != null && this.outboundCosRepository.findById((Object)data.getId()).isPresent()) {
                Optional oldData = this.outboundCosRepository.findById((Object)data.getId());
                Map oldMap = (Map)objectMapper.convertValue(oldData.get(), Map.class);
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    InputAction inputValue = new InputAction();
                    inputValue.setFieldName(mapEntry.getKey());
                    inputValue.setNewValue(mapEntry.getValue());
                    for (Map.Entry compare : oldMap.entrySet()) {
                        if (!mapEntry.getKey().equals(compare.getKey())) continue;
                        inputValue.setOldValue(compare.getValue());
                    }
                    addValue.add(inputValue);
                }
                cliCommandData.setData(addValue);
                cliCommandData.setEntity("outboundcos");
                String dataReceived = objectMapper.writeValueAsString(addValue);
                CLIServerCommandLog dataLogs = new CLIServerCommandLog();
                dataLogs.setCLICommand(dataReceived);
                dataLogs.setRecordSource("dl");
                dataLogs.setServerCode("");
                dataLogs.setRecordCreatedBy(authentication.getName());
                dataLogs.setRecordCreatedOn(LocalDateTime.now());
                dataLogs.setOutputFileName("Name");
                dataLogs.setOutputFilePath("");
                this.cLIServerCommandLogService.save(dataLogs);
            }
        }
        catch (JsonProcessingException e) {
            logger.info((Object)e);
        }
    }

    public RequestResponse getOutboundCosByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = OutboundCosSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.outboundCosRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.outboundCosRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllCos() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SingleCosModel> addValue = new ArrayList<SingleCosModel>();
        List outboundCos = this.outboundCosRepository.findAll();
        if (outboundCos.isEmpty()) {
            returnValue.setMessage("List is empty");
            logger.error("unable to fetch data: ", (Object)returnValue.getMessage());
        } else {
            for (OutboundCos row : outboundCos) {
                SingleCosModel data = new SingleCosModel();
                data.setCos(row.getCos());
                data.setId(row.getId());
                addValue.add(data);
            }
        }
        returnValue.setData(addValue);
        returnValue.setMessage("List of Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

