/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.queue.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.queue.model.AgentPositionModel;
import com.coraltele.service.coralApps.callcenter.queue.model.AgentQueueModel;
import com.coraltele.service.coralApps.callcenter.queue.model.QueueModel;
import com.coraltele.service.coralApps.callcenter.queue.model.QueueServicesModel;
import com.coraltele.service.coralApps.callcenter.queue.model.TiersPositionModel;
import com.coraltele.service.coralApps.callcenter.queue.service.QueueService;
import java.io.IOException;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/api/v2/queue"})
@RestController
public class QueueController {
    private static final Logger logger = LogManager.getLogger(QueueController.class);
    @Autowired
    QueueService queueService;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllExtensionView(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.queueService.getList(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info("queue list successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.info("failed on getting queue list!");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> storeData(@RequestBody QueueServicesModel data, Principal principal) throws IOException {
        RequestResponse returnValue = this.queueService.create(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateQueue(@RequestBody QueueModel data) {
        RequestResponse returnValue = this.queueService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"delete/{id}"})
    public ResponseEntity<RequestResponse> delete(@PathVariable(value="id") int id) {
        RequestResponse returnValue = this.queueService.deleteQueue(Integer.valueOf(id));
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{id}"})
    public ResponseEntity<RequestResponse> getQueueById(@PathVariable(value="id") int id) {
        RequestResponse returnValue = this.queueService.getById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/acdList"})
    public ResponseEntity<RequestResponse> getAcdList(Principal principal) {
        RequestResponse returnValue = this.queueService.getAcdList(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/agentQueue"})
    public ResponseEntity<RequestResponse> getAllCallingFeatures(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.queueService.getListAgentQueue(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create/tier"})
    public ResponseEntity<RequestResponse> createByAgentQueue(@RequestBody AgentQueueModel data) {
        RequestResponse returnValue = this.queueService.createTiers(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/tier"})
    public ResponseEntity<RequestResponse> updateTier(@RequestBody AgentPositionModel data) {
        RequestResponse returnValue = this.queueService.updatePosition(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.queueService.getAll();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/tierPosition"})
    public ResponseEntity<RequestResponse> updatePositionInTiers(@RequestBody TiersPositionModel data, @RequestParam String arrowDirection) {
        RequestResponse returnValue = this.queueService.updatePositionInTiers(data, arrowDirection);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/createQueue"})
    public ResponseEntity<RequestResponse> create(@RequestBody QueueModel data) {
        RequestResponse returnValue = this.queueService.createDataInQueue(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateQueue"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody QueueModel data) {
        RequestResponse returnValue = this.queueService.updateQueueById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/deleteQueue"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.queueService.deleteQueueById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/filteredList"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.queueService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/upload/{fileName}"})
    public ResponseEntity<RequestResponse> upload(@RequestParam(value="file") MultipartFile file, @PathVariable(value="fileName") String fileName) {
        RequestResponse returnValue = this.queueService.uploadWavFile(file, fileName);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/queue"})
    public ResponseEntity<RequestResponse> getAllQueue() {
        RequestResponse returnValue = this.queueService.getAllQueue();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

