/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.disposition.service;

import com.coraltele.db.coralapps.callcenter.entity.Disposition;
import com.coraltele.db.coralapps.callcenter.repository.DispositionRepository;
import com.coraltele.db.coralapps.callcenter.specification.DispositionSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.disposition.model.DispositionCreateModel;
import com.coraltele.service.coralApps.callcenter.disposition.model.DispositionModel;
import com.coraltele.service.coralApps.callcenter.disposition.service.DispositionService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DispositionService {
    private static final Logger logger = LogManager.getLogger(DispositionService.class);
    private static String agentFilePath = "/etc/coraltele/forms/agent.json";
    private static String inboundFormPath = "/etc/coraltele/forms/inboundform.json";
    @Autowired
    DispositionRepository dispositionRepository;
    @Autowired
    UserRepository userRepository;

    public RequestResponse getAgentFile() {
        RequestResponse returnValue = new RequestResponse();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FileInputStream inputStream = new FileInputStream(new File(agentFilePath));
            List jsonDataList = (List)objectMapper.readValue((InputStream)inputStream, (TypeReference)typeReference);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Retrieved ");
            returnValue.setMessageDetail("Data Retrieved Successfully");
            returnValue.setData((Object)jsonDataList);
            logger.info("Data retrieved successfully");
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("File Not Found");
            logger.error("Error while retrieving data from file", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable To Retrieve Data From File");
            logger.error("Error while retrieving data from file", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllDisposition() {
        List list = (List)this.dispositionRepository.findAll();
        ArrayList<DispositionModel> addValue = new ArrayList<DispositionModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Disposition disposition : list) {
            DispositionModel data = new DispositionModel();
            data.setId(disposition.getId());
            data.setDisposition(disposition.getDescription());
            data.setShortCode(disposition.getShortCode());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getInboundForm() {
        RequestResponse returnValue = new RequestResponse();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            2 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FileInputStream inputStream = new FileInputStream(new File(inboundFormPath));
            List jsonDataList = (List)objectMapper.readValue((InputStream)inputStream, (TypeReference)typeReference);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Retrieved ");
            returnValue.setMessageDetail("Data Retrieved Successfully");
            returnValue.setData((Object)jsonDataList);
            logger.info("Data retrieved successfully");
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("File Not Found");
            logger.error("Error while retrieving data from file", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable To Retrieve Data From File");
            logger.error("Error while retrieving data from file", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse createDataInDisposition(DispositionCreateModel data, Principal principal) {
        logger.debug("create new Agent : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Disposition disposition = new Disposition();
            Optional username = this.userRepository.findByUsername(principal.getName());
            Long userId = (long)((User)username.get()).getId();
            disposition.setCreatedBy(userId);
            disposition.setCreatedOn(LocalDateTime.now());
            disposition.setDescription(data.getDescription());
            if (data.getIsDisabled() != null) {
                disposition.setIsDisabled(data.getIsDisabled());
            } else {
                disposition.setIsDisabled(Boolean.valueOf(false));
            }
            disposition.setShortCode(data.getShortCode());
            this.dispositionRepository.save((Object)disposition);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Disposition Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Disposition");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(DispositionCreateModel data) {
        logger.debug("Update Disposition {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional disposition = this.dispositionRepository.findById((Object)data.getId());
        if (!disposition.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("Disposition not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getDescription() != null) {
            ((Disposition)disposition.get()).setDescription(data.getDescription());
        }
        if (data.getIsDisabled() != null) {
            ((Disposition)disposition.get()).setIsDisabled(data.getIsDisabled());
        }
        if (data.getShortCode() != null) {
            ((Disposition)disposition.get()).setShortCode(data.getShortCode());
        }
        this.dispositionRepository.save(disposition.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Disposition Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteAgentById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional disposition = this.dispositionRepository.findById((Object)ids);
            if (disposition.isPresent()) {
                addValue.add(disposition.get());
                this.dispositionRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DispositionSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.dispositionRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.dispositionRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<DispositionCreateModel> entityToModelConversion(List<Disposition> disposition) {
        ArrayList<DispositionCreateModel> addValue = new ArrayList<DispositionCreateModel>();
        for (Disposition row : disposition) {
            DispositionCreateModel data = new DispositionCreateModel();
            data.setId(row.getId());
            if (row.getCreatedBy() != null) {
                Optional user = this.userRepository.findById(row.getCreatedBy().intValue());
                data.setCreatedBy(((User)user.get()).getUsername());
            } else {
                data.setCreatedBy("");
            }
            data.setCreatedOn(row.getCreatedOn());
            data.setDescription(row.getDescription());
            data.setIsDisabled(row.getIsDisabled());
            data.setShortCode(row.getShortCode());
            addValue.add(data);
        }
        return addValue;
    }
}

