/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.channels.service;

import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class ChannelsService {
    private static final Logger logger = LogManager.getLogger(ChannelsService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    UserRepository userRepository;

    public RequestResponse getChannelsData() {
        RequestResponse returnValue = new RequestResponse();
        String opaqueKey = null;
        List users = (List)this.userRepository.findAll();
        for (User row : users) {
            if (row.getIpAddress() == null || !row.getIpAddress().equalsIgnoreCase("all-ip")) continue;
            opaqueKey = "Opaque " + row.getKeyValue();
            break;
        }
        if (opaqueKey == null) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("No matching user found with 'all-ip'.");
            return returnValue;
        }
        try {
            String url = "http://127.0.0.1:8991/api/v2/channel";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", opaqueKey);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                String responseBody = (String)responseEntity.getBody();
                List channelDataList = (List)this.objectMapper.readValue(responseBody, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                returnValue.setData((Object)channelDataList);
                returnValue.setStatus(Constants.Error.OK);
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Failed to retrieve channel data. Status: " + responseEntity.getStatusCode());
            }
        }
        catch (HttpStatusCodeException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("API call failed. HTTP Status: " + e.getStatusCode() + ", Response: " + e.getResponseBodyAsString());
        }
        catch (ResourceAccessException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("I/O error occurred: " + e.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Exception occurred while calling channel API: " + e.getMessage());
        }
        return returnValue;
    }
}

