/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.archiving.billingCdrHistorical.service;

import com.coraltele.service.archiving.billingCdrHistorical.service.TableDumpService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class TableDumpService {
    private static final Logger logger = LoggerFactory.getLogger(TableDumpService.class);
    @Autowired
    @Qualifier(value="switchDataSource")
    private DataSource switchDataSource;
    @Autowired
    @Qualifier(value="coralAppsDataSource")
    private DataSource coralAppsDataSource;
    @Autowired
    @Qualifier(value="usersDataSource")
    private DataSource usersDataSource;
    @Autowired
    private ObjectMapper objectMapper;

    public Map<String, Object> listDumpedFiles(Path dumpDirectory) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList fileList = new ArrayList();
        File dir = dumpDirectory.toFile();
        if (!dir.exists() || !dir.isDirectory()) {
            result.put("data", fileList);
            result.put("message", "Directory not found");
            return result;
        }
        File[] files = dir.listFiles((d, name) -> name.endsWith(".json"));
        if (files == null || files.length == 0) {
            result.put("data", fileList);
            result.put("message", "No JSON files found");
            return result;
        }
        Arrays.sort(files, (f1, f2) -> Long.compare(f2.lastModified(), f1.lastModified()));
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        for (File file : files) {
            HashMap<String, Object> fileInfo = new HashMap<String, Object>();
            fileInfo.put("fileName", file.getName());
            fileInfo.put("filePath", file.getAbsolutePath());
            fileInfo.put("sizeBytes", file.length());
            fileInfo.put("lastModified", sdf.format(new Date(file.lastModified())));
            try {
                Map dumpContent = (Map)this.objectMapper.readValue(file, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                fileInfo.put("metadata", dumpContent.getOrDefault("metadata", null));
                fileInfo.put("dumpTimestamp", dumpContent.getOrDefault("dumpTimestamp", null));
                fileInfo.put("totalTables", dumpContent.getOrDefault("totalTables", 0));
            }
            catch (IOException e) {
                logger.warn("Could not read metadata from file: {}", (Object)file.getName(), (Object)e);
                fileInfo.put("metadata", null);
            }
            fileList.add(fileInfo);
        }
        result.put("data", fileList);
        result.put("count", fileList.size());
        result.put("status", "SUCCESS");
        return result;
    }

    public Map<String, Object> dumpAllTables(String outputFilePath, Map<String, String> metadata) throws IOException {
        logger.info("Starting table dump process...");
        List tableConfigs = this.readTableConfiguration();
        LinkedHashMap<String, Object> dumpData = new LinkedHashMap<String, Object>();
        if (metadata != null) {
            dumpData.put("metadata", metadata);
        }
        dumpData.put("dumpTimestamp", new Date().toString());
        dumpData.put("totalTables", tableConfigs.size());
        ArrayList tablesData = new ArrayList();
        for (TableConfig config : tableConfigs) {
            try {
                logger.info("Dumping table: {}.{}.{}", new Object[]{config.getDatabase(), config.getSchema(), config.getTable()});
                LinkedHashMap<String, Object> tableData = new LinkedHashMap<String, Object>();
                tableData.put("database", config.getDatabase());
                tableData.put("schema", config.getSchema());
                tableData.put("table", config.getTable());
                List rows = this.dumpTable(config);
                tableData.put("rowCount", rows.size());
                tableData.put("data", rows);
                tablesData.add(tableData);
                logger.info("Successfully dumped {} rows from {}.{}.{}", new Object[]{rows.size(), config.getDatabase(), config.getSchema(), config.getTable()});
            }
            catch (Exception e) {
                logger.error("Error dumping table {}.{}.{}: {}", new Object[]{config.getDatabase(), config.getSchema(), config.getTable(), e.getMessage(), e});
                LinkedHashMap<String, Object> errorData = new LinkedHashMap<String, Object>();
                errorData.put("database", config.getDatabase());
                errorData.put("schema", config.getSchema());
                errorData.put("table", config.getTable());
                errorData.put("error", e.getMessage());
                errorData.put("rowCount", 0);
                errorData.put("data", Collections.emptyList());
                tablesData.add(errorData);
            }
        }
        dumpData.put("tables", tablesData);
        File outputFile = new File(outputFilePath);
        this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(outputFile, dumpData);
        logger.info("Table dump completed. Output written to: {}", (Object)outputFilePath);
        return dumpData;
    }

    private List<Map<String, Object>> dumpTable(TableConfig config) {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplateForDatabase(config.getDatabase());
        String query = String.format("SELECT * FROM %s.%s", config.getSchema(), config.getTable());
        return jdbcTemplate.queryForList(query);
    }

    private JdbcTemplate getJdbcTemplateForDatabase(String database) {
        switch (database.toLowerCase()) {
            case "switch": {
                return new JdbcTemplate(this.switchDataSource);
            }
            case "coralapps": {
                return new JdbcTemplate(this.coralAppsDataSource);
            }
            case "users": {
                return new JdbcTemplate(this.usersDataSource);
            }
        }
        throw new IllegalArgumentException("Unknown database: " + database);
    }

    private List<TableConfig> readTableConfiguration() throws IOException {
        ClassPathResource resource = new ClassPathResource("default-data/database-schema-tables.json");
        return (List)this.objectMapper.readValue(resource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }
}

