/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DownloadPdfService {
    private static final Logger logger = LogManager.getLogger(DownloadPdfService.class);
    @Autowired
    PdfReportRepository pdfReportRepository;

    public ResponseEntity<byte[]> getPdfFile(String path) {
        try {
            Optional pathLocation = this.pdfReportRepository.findByPdfLocation(path);
            if (!pathLocation.isPresent() || !"success".equals(((PdfReportFilters)pathLocation.get()).getStatus())) {
                String errorMessage = "Failed to download PDF. Invalid or non-successful path: " + path;
                logger.error(errorMessage);
                return ResponseEntity.status((int)400).build();
            }
            byte[] fileContent = Files.readAllBytes(new File(path).toPath());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_PDF);
            headers.setContentDispositionFormData("attachment", "filename.pdf");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)fileContent);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).build();
        }
    }
}

