/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.telemetry.main.entity.view;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import lombok.Generated;
import org.hibernate.annotations.Subselect;
import org.springframework.data.annotation.Immutable;

@Entity
@Immutable
@Subselect(value="select * from (\n            select uuid,\n                   queue,\n                   queue_name,\n                   campaign,\n                  cc_agent,\n                   call_id,\n                   customer_number,\n                   start_time as abandoned_time,\n                   hangup_cause,\n                   duration,\n                   row_number() over (\n                       partition by customer_number, call_id,date(to_timestamp(start_time))\n                       order by queue, to_timestamp(start_time) desc\n                   ) as rn\n            from customer_cdr\n            where status in ('ABD at Agent', 'ABD at Queue')\n        ) a\n        where rn = 1")
public class LastAbandonedView {
    @Id
    @Column(name="uuid")
    private String uuid;
    @Column(name="queue")
    private String queue;
    @Column(name="campaign")
    private String campaign;
    @Column(name="queue_name")
    private String queueName;
    @Column(name="call_id")
    private String callId;
    @Column(name="customer_number")
    private String customerNumber;
    @Column(name="abandoned_time")
    private Long startTime;
    @Column(name="hangup_cause")
    private String hangupCause;
    @Column(name="duration")
    private Integer duration;
    @Column(name="cc_agent")
    private String ccAgent;

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getQueue() {
        return this.queue;
    }

    @Generated
    public String getCampaign() {
        return this.campaign;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getCallId() {
        return this.callId;
    }

    @Generated
    public String getCustomerNumber() {
        return this.customerNumber;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public String getHangupCause() {
        return this.hangupCause;
    }

    @Generated
    public Integer getDuration() {
        return this.duration;
    }

    @Generated
    public String getCcAgent() {
        return this.ccAgent;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setQueue(String queue) {
        this.queue = queue;
    }

    @Generated
    public void setCampaign(String campaign) {
        this.campaign = campaign;
    }

    @Generated
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Generated
    public void setCallId(String callId) {
        this.callId = callId;
    }

    @Generated
    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    @Generated
    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setHangupCause(String hangupCause) {
        this.hangupCause = hangupCause;
    }

    @Generated
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Generated
    public void setCcAgent(String ccAgent) {
        this.ccAgent = ccAgent;
    }
}

