/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.service;

import com.coraltele.db.billing.main.entity.ChannelUC;
import com.coraltele.db.billing.main.entity.Notification;
import com.coraltele.db.billing.main.repository.ChannelRecipientRepository;
import com.coraltele.db.billing.main.repository.ChannelRepository;
import com.coraltele.db.billing.main.repository.ChannelUCRepository;
import com.coraltele.db.billing.main.repository.NotificationRepository;
import com.coraltele.db.telemetry.main.repository.UCDetailsRepository;
import com.coraltele.db.telephony.uc.entity.UserData;
import com.coraltele.db.telephony.uc.repository.CountNotificationRepository;
import com.coraltele.db.telephony.uc.repository.UserDataRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.ObjectTraverse;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.service.uc.service.ViewChannelUCService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class UCService {
    private static final Logger logger = LogManager.getLogger(UCService.class);
    @Autowired
    ChannelUCRepository channelUCRepository;
    @Autowired
    UserDataRepository ucUserDataRepository;
    @Autowired
    NotificationRepository notificationRepository;
    @Autowired
    CountNotificationRepository countNotificationRepository;
    @Autowired
    ObjectTraverse objectTraverse;
    @Autowired
    UCDetailsRepository ucDetailsRepository;
    @Autowired
    ViewChannelUCService viewChannelUCService;
    @Autowired
    ChannelRepository channelsRepository;
    @Autowired
    ChannelRecipientRepository channelsRecipientRepository;

    public List<ChannelUC> getCDR(String userName) {
        return this.channelUCRepository.findAll();
    }

    public List<UserData> getFax(String userName) {
        return this.ucUserDataRepository.getFax(userName);
    }

    public List<UserData> getVoiceMails(String userName) {
        return this.ucUserDataRepository.getVM(userName);
    }

    public RequestResponse updateNotification(InputIdModel rowId, Authentication authentication, String messageType) {
        RequestResponse returnValue = new RequestResponse();
        List list = this.notificationRepository.findByMessageIdAndLoginId((Long)rowId.getId().get(0), authentication.getName());
        if (list.isEmpty()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage(" Not Found");
            returnValue.setMessageDetail("Data Not Found this row {}" + rowId);
            logger.info(returnValue.getMessageDetail());
        } else {
            for (Notification data : list) {
                if (!data.getMessageType().equals(messageType)) continue;
                data.setIsMessageRead(Boolean.valueOf(true));
                data.setMessageReadTime(LocalDateTime.now());
                data.setMessageReadBy(authentication.getName());
                this.notificationRepository.save((Object)data);
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Data Updated");
        returnValue.setMessageDetail("successfully update this row {}" + rowId);
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse updateNotificationForAll(Authentication authentication, String messageType) {
        RequestResponse returnValue = new RequestResponse();
        List list = this.notificationRepository.findByLoginIdAndMessageType(authentication.getName(), messageType);
        if (list.isEmpty()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage(" Not Found");
            returnValue.setMessageDetail("Data Not Found");
            logger.info(returnValue.getMessageDetail());
        } else {
            for (Notification data : list) {
                if (!data.getMessageType().equals(messageType)) continue;
                data.setIsMessageNotified(Boolean.valueOf(true));
                data.setMessageReadTime(LocalDateTime.now());
                data.setMessageReadBy(authentication.getName());
                this.notificationRepository.save((Object)data);
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Data Updated");
        returnValue.setMessageDetail("successfully update");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse getListOfNotification(Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        List data = this.countNotificationRepository.getNotifiedList(authentication.getName());
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("notifications", data);
        if (data == null || data.isEmpty()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("No unread messages found.");
            returnValue.setData(map);
        } else {
            map.put("notifications", data);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Alert");
            returnValue.setMessageDetail("List of unread messages.");
            returnValue.setData(map);
        }
        return returnValue;
    }

    public RequestResponse deleteMissedCall(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList recordsToDelete = new ArrayList();
        logger.info("List of voicemail IDs to delete: {}", (Object)data.getIntId());
        if (this.viewChannelUCService.readConfigureUc().equalsIgnoreCase("true")) {
            for (Integer row : data.getIntId()) {
                Optional currentRecord = this.ucDetailsRepository.findById((Object)row);
                currentRecord.ifPresent(recordsToDelete::add);
            }
            if (!recordsToDelete.isEmpty()) {
                this.ucDetailsRepository.deleteAll(recordsToDelete);
                returnValue.setMessage("Record Deleted");
                returnValue.setMessageDetail("Successfully deleted " + recordsToDelete.size() + " record(s).");
                logger.info("Deleted {} voicemail(s)", (Object)recordsToDelete.size());
            } else {
                returnValue.setMessage("No Records Found");
                returnValue.setMessageDetail("No matching records found for given IDs.");
                logger.info("No matching records found for IDs: {}", (Object)data.getIntId());
            }
        } else {
            ArrayList channelsToDelete = new ArrayList();
            ArrayList recipientsToDelete = new ArrayList();
            for (Integer row : data.getIntId()) {
                Optional channelRecord = this.channelsRepository.findById((Object)row);
                channelRecord.ifPresent(channelsToDelete::add);
                Optional recipientRecord = this.channelsRecipientRepository.findById((Object)row);
                recipientRecord.ifPresent(recipientsToDelete::add);
            }
            if (!channelsToDelete.isEmpty() || !recipientsToDelete.isEmpty()) {
                if (!recipientsToDelete.isEmpty()) {
                    this.channelsRecipientRepository.deleteAll(recipientsToDelete);
                }
                if (!channelsToDelete.isEmpty()) {
                    this.channelsRepository.deleteAll(channelsToDelete);
                }
                returnValue.setMessage("Record Deleted");
                returnValue.setMessageDetail("Successfully deleted " + channelsToDelete.size() + " channel(s) and " + recipientsToDelete.size() + " recipient(s).");
                logger.info("Deleted {} channel(s) and {} recipient(s)", (Object)channelsToDelete.size(), (Object)recipientsToDelete.size());
            } else {
                returnValue.setMessage("No Records Found");
                returnValue.setMessageDetail("No matching Channel/Recipient records found for given IDs.");
                logger.info("No matching Channel/Recipient records found for IDs: {}", (Object)data.getIntId());
            }
        }
        return returnValue;
    }
}

