/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.inOutgatewaySummary.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.PdfGeneratorService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="gatewayInBoundSummaryPdf")
public class GatewayInBoundSummaryPdf
implements PdfGeneratorService {
    private static final Logger logger = LogManager.getLogger(GatewayInBoundSummaryPdf.class);
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final String TITLE = "Inbound Gateway Summary";
    private static final String LOGO = "/var/www/html/apple-icon.png";
    private static final String DTF = "dd-MM-yyyy hh:mm:ss a";
    @Autowired
    BillingCDRRepository repo;
    @Autowired
    PdfReportRepository pdfRepo;
    @Autowired
    PdfPageNumberEvent footer;
    @Autowired
    DateFormatUtility util;
    private LocalDateTime now;

    public RequestResponse generatePdfReport(SearchRequest req, String file, Principal p) {
        RequestResponse res = new RequestResponse();
        this.now = LocalDateTime.now();
        this.initFooter();
        try {
            List cols = this.resolveColumns(req);
            List rows = this.fetch(req);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document doc = cols.size() > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)baos);
            writer.setPageEvent((PdfPageEvent)this.footer);
            doc.open();
            this.addLogoAndDocTitle(doc, req, Integer.valueOf(cols.size()));
            doc.newPage();
            this.addStyledTable(doc, cols, rows);
            doc.close();
            this.write(file, baos.toByteArray());
            res.setStatus(Constants.Error.OK);
            res.setMessage("PDF generated");
            res.setData((Object)file);
        }
        catch (Exception e) {
            e.printStackTrace();
            res.setStatus(Constants.Error.ERROR);
            res.setMessage("Failed");
        }
        return res;
    }

    private void addStyledTable(Document doc, List<String> cols, List<Object[]> data) throws Exception {
        PdfPTable t = new PdfPTable(cols.size());
        t.setWidthPercentage(100.0f);
        BaseColor headerBlue = new BaseColor(2, 111, 194);
        BaseColor altGrey = new BaseColor(230, 230, 230);
        for (String c : cols) {
            PdfPCell h = new PdfPCell(new Phrase(this.map(c), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
            h.setHorizontalAlignment(1);
            h.setVerticalAlignment(5);
            h.setBackgroundColor(headerBlue);
            h.setBorder(0);
            h.setPadding(8.0f);
            t.addCell(h);
        }
        t.setHeaderRows(1);
        if (data == null || data.isEmpty()) {
            PdfPCell c = new PdfPCell(new Phrase("No Records Found"));
            c.setColspan(cols.size());
            c.setHorizontalAlignment(1);
            c.setBorder(0);
            t.addCell(c);
        } else {
            int rowIndex = 0;
            for (Object[] r : data) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("coralInboundGateway", this.safe(r[0]));
                m.put("totalCall", this.safe(r[1]));
                m.put("answered", this.safe(r[2]));
                m.put("unAnswered", this.safe(r[3]));
                m.put("ringDuration", DateFormatUtility.findLocalTime((Long)this.toL(r[4])));
                m.put("avgRingDuration", DateFormatUtility.findLocalTime((Long)this.toL(r[5])));
                m.put("talkDuration", DateFormatUtility.findLocalTime((Long)this.toL(r[6])));
                m.put("avgCallDuration", DateFormatUtility.findLocalTime((Long)this.toL(r[7])));
                BaseColor bg = rowIndex % 2 == 0 ? BaseColor.WHITE : altGrey;
                for (String c : cols) {
                    PdfPCell cell = new PdfPCell(new Phrase((String)m.get(c)));
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.setBackgroundColor(bg);
                    cell.setBorder(0);
                    cell.setPadding(6.0f);
                    t.addCell(cell);
                }
                ++rowIndex;
            }
        }
        doc.add((Element)t);
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)LOGO);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
            }
            img.setAlignment(1);
            logoCell.addElement((Element)img);
            PdfPCell title = new PdfPCell(new Phrase(TITLE, COURIER));
            title.setHorizontalAlignment(1);
            title.setBorder(0);
            PdfPCell dt = new PdfPCell(new Phrase("Report generated on " + this.now.format(DateTimeFormatter.ofPattern(DTF)), COURIER_SMALL));
            dt.setHorizontalAlignment(1);
            dt.setBorder(0);
            table.addCell(logoCell);
            table.addCell(title);
            table.addCell(dt);
            document.add((Element)table);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String emptyToNull(String v) {
        return v == null || v.trim().isEmpty() ? null : v.trim();
    }

    private LocalDate parseDateSafe(String v) {
        try {
            return v == null || v.trim().isEmpty() ? null : LocalDate.parse(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<Object[]> fetch(SearchRequest request) {
        String search;
        boolean hasSearch;
        LocalDate fromDate = null;
        LocalDate toDate = null;
        String inBoundGateway = null;
        if (inBoundGateway != null && inBoundGateway.trim().isEmpty()) {
            inBoundGateway = null;
        }
        if (request.getAdvancedFilters() != null) {
            for (AdvanceFilter f : request.getAdvancedFilters()) {
                if ("callDate".equalsIgnoreCase(f.getFieldName())) {
                    if ("from".equalsIgnoreCase(f.getDirection())) {
                        fromDate = this.parseDateSafe(f.getValue());
                    }
                    if ("to".equalsIgnoreCase(f.getDirection())) {
                        toDate = this.parseDateSafe(f.getValue());
                    }
                }
                if (!"coralInboundGateway".equalsIgnoreCase(f.getFieldName())) continue;
                inBoundGateway = this.emptyToNull(f.getValue());
            }
        }
        boolean bl = hasSearch = (search = request.getSearch()) != null && !search.trim().isEmpty();
        if (hasSearch) {
            search = search.trim().toLowerCase();
        }
        List rows = this.repo.getInboundSummary(fromDate, toDate, inBoundGateway);
        if (hasSearch) {
            String searchTerm = search;
            rows = rows.stream().filter(arr -> arr != null && ((Object[])arr).length > 0 && arr[0] != null && arr[0].toString().toLowerCase().contains(searchTerm)).collect(Collectors.toList());
        }
        return rows;
    }

    private String safe(Object v) {
        return v == null ? "" : v.toString();
    }

    private long toL(Object v) {
        return v == null ? 0L : ((Number)v).longValue();
    }

    private List<String> resolveColumns(SearchRequest r) {
        if (r.getColumnNames() == null || r.getColumnNames().isEmpty()) {
            return Arrays.asList("coralInboundGateway", "totalCall", "answered", "unAnswered", "ringDuration", "avgRingDuration", "talkDuration", "avgCallDuration");
        }
        return r.getColumnNames();
    }

    private String map(String c) {
        switch (c) {
            case "coralInboundGateway": {
                return "Inbound Gateway";
            }
            case "totalCall": {
                return "Total Calls";
            }
            case "answered": {
                return "Answered Calls";
            }
            case "unAnswered": {
                return "Unanswered Calls";
            }
            case "ringDuration": {
                return "Ring Time";
            }
            case "avgRingDuration": {
                return "Avg Ring Time";
            }
            case "talkDuration": {
                return "Talk Time";
            }
            case "avgCallDuration": {
                return "Avg Talk Time";
            }
        }
        return c;
    }

    private void write(String p, byte[] d) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(p);){
            fos.write(d);
        }
    }

    private void initFooter() {
        try {
            this.footer.initialize(LOGO, TITLE, DTF, this.now);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String path) {
        try {
            PdfReportFilters f = new PdfReportFilters();
            f.setId(id);
            f.setReportName(TITLE);
            f.setPdfLocation(path);
            f.setCreatedOnDate(this.now);
            f.setStatus("InProgress");
            f.setFilterParameters(new ObjectMapper().writeValueAsString((Object)data));
            this.pdfRepo.save((Object)f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

