/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.activityLogs.service;

import com.coraltele.db.telemetry.main.entity.ActivityLogs;
import com.coraltele.db.telemetry.main.repository.ActivityLogsRepository;
import com.coraltele.db.telemetry.main.specification.ActivityLogSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.activityLogs.model.ActivityLogListModel;
import com.coraltele.service.telemetry.main.activityLogs.model.ActivityLogModel;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ActivityLogService {
    private static final Logger logger = LogManager.getLogger(ActivityLogService.class);
    @Autowired
    ActivityLogsRepository activityLogsRepository;
    @Autowired
    UserService userService;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse createData(ActivityLogModel data, Principal principal) {
        logger.debug("Create new ActivityLog: {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            ActivityLogs activityLogs = new ActivityLogs();
            activityLogs.setEventStatus(data.getEventStatus());
            activityLogs.setEventCategory(data.getEventCategory());
            activityLogs.setEventGroup(data.getEventGroup());
            activityLogs.setCallerNumber(data.getCallerNumber());
            activityLogs.setDestinationNumber(data.getDestinationNumber());
            activityLogs.setCreatedBy(principal.getName());
            activityLogs.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
            activityLogs.setEvent(data.getEvent());
            activityLogs.setUserId(data.getUserId());
            activityLogs.setEpochDate(data.getEpochDate());
            activityLogs.setEventData(data.getEventData().toString());
            activityLogs.setDeviceId(data.getDeviceId());
            this.activityLogsRepository.save((Object)activityLogs);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Data Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create activityLogs");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse last50Records(Principal principal) {
        logger.debug("list of 50 ActivityLog");
        RequestResponse returnValue = new RequestResponse();
        try {
            List list = this.activityLogsRepository.findTop50ByCreatedByOrderByCreatedOnDesc(principal.getName());
            if (!list.isEmpty()) {
                ArrayList<ActivityLogModel> addValue = new ArrayList<ActivityLogModel>();
                for (ActivityLogs data : list) {
                    ActivityLogModel activityLogs = new ActivityLogModel();
                    activityLogs.setId(data.getId());
                    activityLogs.setCreatedBy(data.getCreatedBy());
                    activityLogs.setEventCategory(data.getEventCategory());
                    activityLogs.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
                    activityLogs.setEventStatus(data.getEventStatus());
                    activityLogs.setEvent(data.getEvent());
                    activityLogs.setEventGroup(data.getEventGroup());
                    activityLogs.setCallerNumber(data.getCallerNumber());
                    activityLogs.setDestinationNumber(data.getDestinationNumber());
                    addValue.add(activityLogs);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("List fetched Successfully");
                returnValue.setData(addValue);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("No Record found");
                returnValue.setMessageDetail("Empty list exist of current user");
                logger.error(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create activityLogs");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getALLLogs(SearchRequest searchRequestData, Principal principal, String eventType) {
        RequestResponse returnValue = new RequestResponse();
        boolean adminUser = false;
        boolean dispatcherRole = false;
        if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        } else if (this.userService.checkRoleDispatcher(principal.getName())) {
            dispatcherRole = true;
        }
        Specification filters = ActivityLogSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)adminUser, (boolean)dispatcherRole, (String)principal.getName(), (String)eventType);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.activityLogsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.activityLogsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ActivityLogListModel> entityToModelConversion(List<ActivityLogs> activityLogs) {
        ArrayList<ActivityLogListModel> addValue = new ArrayList<ActivityLogListModel>();
        for (ActivityLogs row : activityLogs) {
            ActivityLogListModel data = new ActivityLogListModel();
            data.setId(row.getId());
            if (row.getCreatedOn() != null) {
                data.setCreatedOn(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getCreatedOn()));
            }
            if (row.getEpochDate() != null) {
                data.setEpochDate(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getEpochDate()));
            }
            data.setEventGroup(row.getEventGroup());
            data.setEventStatus(row.getEventStatus());
            data.setCallerNumber(row.getCallerNumber());
            data.setDestinationNumber(row.getDestinationNumber());
            data.setCreatedBy(row.getCreatedBy());
            data.setEvent(row.getEvent());
            data.setEventCategory(row.getEventCategory());
            data.setUserId(row.getUserId());
            data.setDeviceId(row.getDeviceId());
            data.setEventData((Object)row.getEventData());
            addValue.add(data);
        }
        return addValue;
    }
}

